/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import java.util.HashSet;
import java.util.Set;

public final class RateLimitingConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "5fa50aacf9914a78f91595ee1cb7046e";
    public static final String CONFIG_DEF_NAME = "rate-limiting";
    public static final String CONFIG_DEF_NAMESPACE = "search.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.config", "capacityIncrement double default=1000", "maxAvailableCapacity double default=10000", "recheckForCapacityProbability double default=0.001"};
    private final DoubleNode capacityIncrement;
    private final DoubleNode maxAvailableCapacity;
    private final DoubleNode recheckForCapacityProbability;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public RateLimitingConfig(Builder builder) {
        this(builder, true);
    }

    private RateLimitingConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for rate-limiting must be initialized: " + builder.__uninitialized);
        }
        this.capacityIncrement = builder.capacityIncrement == null ? new DoubleNode(1000.0) : new DoubleNode(builder.capacityIncrement.doubleValue());
        this.maxAvailableCapacity = builder.maxAvailableCapacity == null ? new DoubleNode(10000.0) : new DoubleNode(builder.maxAvailableCapacity.doubleValue());
        this.recheckForCapacityProbability = builder.recheckForCapacityProbability == null ? new DoubleNode(0.001) : new DoubleNode(builder.recheckForCapacityProbability.doubleValue());
    }

    public double capacityIncrement() {
        return this.capacityIncrement.value();
    }

    public double maxAvailableCapacity() {
        return this.maxAvailableCapacity.value();
    }

    public double recheckForCapacityProbability() {
        return this.recheckForCapacityProbability.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(RateLimitingConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Double capacityIncrement = null;
        private Double maxAvailableCapacity = null;
        private Double recheckForCapacityProbability = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(RateLimitingConfig config) {
            this.capacityIncrement(config.capacityIncrement());
            this.maxAvailableCapacity(config.maxAvailableCapacity());
            this.recheckForCapacityProbability(config.recheckForCapacityProbability());
        }

        private Builder override(Builder __superior) {
            if (__superior.capacityIncrement != null) {
                this.capacityIncrement(__superior.capacityIncrement);
            }
            if (__superior.maxAvailableCapacity != null) {
                this.maxAvailableCapacity(__superior.maxAvailableCapacity);
            }
            if (__superior.recheckForCapacityProbability != null) {
                this.recheckForCapacityProbability(__superior.recheckForCapacityProbability);
            }
            return this;
        }

        public Builder capacityIncrement(double __value) {
            this.capacityIncrement = __value;
            return this;
        }

        private Builder capacityIncrement(String __value) {
            return this.capacityIncrement(Double.valueOf(__value));
        }

        public Builder maxAvailableCapacity(double __value) {
            this.maxAvailableCapacity = __value;
            return this;
        }

        private Builder maxAvailableCapacity(String __value) {
            return this.maxAvailableCapacity(Double.valueOf(__value));
        }

        public Builder recheckForCapacityProbability(double __value) {
            this.recheckForCapacityProbability = __value;
            return this;
        }

        private Builder recheckForCapacityProbability(String __value) {
            return this.recheckForCapacityProbability(Double.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return RateLimitingConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return RateLimitingConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return RateLimitingConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public RateLimitingConfig build() {
            return new RateLimitingConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

