/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.MarkerWordItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.PrefixItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.SubstringItem;
import com.yahoo.prelude.query.SuffixItem;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.UriItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.parser.AbstractParser;
import com.yahoo.prelude.query.parser.Token;
import com.yahoo.search.query.parser.ParserEnvironment;
import java.util.ArrayList;
import java.util.List;

abstract class StructuredParser
extends AbstractParser {
    protected StructuredParser(ParserEnvironment environment) {
        super(environment);
    }

    protected abstract Item handleComposite(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Item compositeItem() {
        int position = this.tokens.getPosition();
        Item item = null;
        try {
            this.tokens.skipMultiple(Token.Kind.PLUS);
            if (!this.tokens.skip(Token.Kind.LBRACE)) {
                Item item2 = null;
                return item2;
            }
            item = this.handleComposite(false);
            this.tokens.skip(Token.Kind.RBRACE);
            Item item3 = item;
            return item3;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    protected void setSubmodeFromIndex(String indexName, IndexFacts.Session indexFacts) {
        this.submodes.setFromIndex(indexName, indexFacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Item indexableItem() {
        int position = this.tokens.getPosition();
        Item item = null;
        try {
            String indexName = this.indexPrefix();
            this.setSubmodeFromIndex(indexName, this.indexFacts);
            item = this.number();
            if (item == null) {
                item = this.phrase(indexName);
            }
            if (item == null && indexName != null && this.wordsAhead()) {
                item = this.phrase(indexName);
            }
            this.submodes.reset();
            int weight = -1;
            if (item != null) {
                weight = this.weightSuffix();
            }
            if (indexName != null && item != null) {
                item.setIndexName(indexName);
            }
            if (weight != -1 && item != null) {
                item.setWeight(weight);
            }
            Item item2 = item;
            return item2;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    private boolean wordsAhead() {
        while (this.tokens.hasNext()) {
            if (this.tokens.currentIsNoIgnore(Token.Kind.SPACE)) {
                return false;
            }
            if (this.tokens.currentIsNoIgnore(Token.Kind.NUMBER) || this.tokens.currentIsNoIgnore(Token.Kind.WORD)) {
                return true;
            }
            this.tokens.skipNoIgnore();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nothingAhead(boolean skip) {
        int position = this.tokens.getPosition();
        try {
            boolean quoted = false;
            while (this.tokens.hasNext()) {
                if (this.tokens.currentIsNoIgnore(Token.Kind.QUOTE)) {
                    this.tokens.skipMultiple(Token.Kind.QUOTE);
                    quoted = !quoted;
                    continue;
                }
                if (!quoted && this.tokens.currentIsNoIgnore(Token.Kind.SPACE)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.tokens.currentIsNoIgnore(Token.Kind.NUMBER) || this.tokens.currentIsNoIgnore(Token.Kind.WORD)) {
                    boolean bl = false;
                    return bl;
                }
                this.tokens.skipNoIgnore();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (!skip) {
                this.tokens.setPosition(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String indexPrefix() {
        int position = this.tokens.getPosition();
        Object item = null;
        try {
            ArrayList<Token> firstWord = new ArrayList<Token>();
            ArrayList<Token> secondWord = new ArrayList<Token>();
            this.tokens.skip(Token.Kind.LSQUAREBRACKET);
            if (!(this.tokens.currentIs(Token.Kind.WORD) || this.tokens.currentIs(Token.Kind.NUMBER) || this.tokens.currentIs(Token.Kind.UNDERSCORE))) {
                String string = null;
                return string;
            }
            firstWord.add(this.tokens.next());
            while (this.tokens.currentIsNoIgnore(Token.Kind.UNDERSCORE) || this.tokens.currentIsNoIgnore(Token.Kind.WORD) || this.tokens.currentIsNoIgnore(Token.Kind.NUMBER)) {
                firstWord.add(this.tokens.next());
            }
            while (this.tokens.currentIsNoIgnore(Token.Kind.DOT)) {
                secondWord.add(this.tokens.next());
                if (this.tokens.currentIsNoIgnore(Token.Kind.WORD) || this.tokens.currentIsNoIgnore(Token.Kind.NUMBER)) {
                    secondWord.add(this.tokens.next());
                } else {
                    String string = null;
                    return string;
                }
                while (this.tokens.currentIsNoIgnore(Token.Kind.UNDERSCORE) || this.tokens.currentIsNoIgnore(Token.Kind.WORD) || this.tokens.currentIsNoIgnore(Token.Kind.NUMBER)) {
                    secondWord.add(this.tokens.next());
                }
            }
            if (!this.tokens.skipNoIgnore(Token.Kind.COLON)) {
                String string = null;
                return string;
            }
            item = this.concatenate(firstWord) + this.concatenate(secondWord);
            if (!this.indexFacts.isIndex((String)(item = this.indexFacts.getCanonicName((String)item)))) {
                item = null;
                String string = null;
                return string;
            }
            if (this.nothingAhead(false)) {
                this.nothingAhead(true);
                position = this.tokens.getPosition();
                item = this.indexPrefix();
            }
            Object object = item;
            return object;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    private String concatenate(List<Token> tokens) {
        StringBuilder s = new StringBuilder();
        for (Token t : tokens) {
            s.append(t.toString());
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int weightSuffix() {
        int position = this.tokens.getPosition();
        int item = -1;
        try {
            if (!this.tokens.skipNoIgnore(Token.Kind.EXCLAMATION)) {
                int n = -1;
                return n;
            }
            item = 150;
            if (this.tokens.currentIsNoIgnore(Token.Kind.NUMBER)) {
                try {
                    item = Integer.parseInt(this.tokens.next().toString());
                }
                catch (NumberFormatException e) {
                    item = -1;
                }
            } else {
                while (this.tokens.currentIsNoIgnore(Token.Kind.EXCLAMATION)) {
                    item += 50;
                    this.tokens.skipNoIgnore();
                }
            }
            int n = item;
            return n;
        }
        finally {
            if (item == -1) {
                this.tokens.setPosition(position);
            }
        }
    }

    private boolean endOfNumber() {
        return this.tokens.currentIsNoIgnore(Token.Kind.SPACE) || this.tokens.currentIsNoIgnore(Token.Kind.RSQUAREBRACKET) || this.tokens.currentIsNoIgnore(Token.Kind.SEMICOLON) || this.tokens.currentIsNoIgnore(Token.Kind.RBRACE) || this.tokens.currentIsNoIgnore(Token.Kind.EOF) || this.tokens.currentIsNoIgnore(Token.Kind.EXCLAMATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decimalPart() {
        int position = this.tokens.getPosition();
        boolean consumed = false;
        try {
            if (!this.tokens.skipNoIgnore(Token.Kind.DOT)) {
                String string = "";
                return string;
            }
            if (this.tokens.currentIsNoIgnore(Token.Kind.NUMBER)) {
                consumed = true;
                String string = "." + this.tokens.next().toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            if (!consumed) {
                this.tokens.setPosition(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntItem number() {
        int position = this.tokens.getPosition();
        IntItem item = null;
        try {
            Token t;
            item = this.numberRange();
            this.tokens.skip(Token.Kind.LSQUAREBRACKET);
            if (item == null) {
                this.tokens.skipNoIgnore(Token.Kind.SPACE);
            }
            if (item == null && this.tokens.currentIsNoIgnore(Token.Kind.MINUS) && this.tokens.currentNoIgnore((int)1).kind == Token.Kind.NUMBER) {
                this.tokens.skipNoIgnore();
                t = this.tokens.next();
                item = new IntItem("-" + t.toString() + this.decimalPart(), true);
                item.setOrigin(t.substring);
            } else if (item == null && this.tokens.currentIs(Token.Kind.NUMBER)) {
                t = this.tokens.next();
                item = new IntItem(t.toString() + this.decimalPart(), true);
                item.setOrigin(t.substring);
            }
            if (item == null) {
                item = this.numberSmaller();
            }
            if (item == null) {
                item = this.numberGreater();
            }
            if (item != null && !this.endOfNumber()) {
                item = null;
            }
            IntItem intItem = item;
            return intItem;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntItem numberRange() {
        int position = this.tokens.getPosition();
        IntItem item = null;
        try {
            Token initial = this.tokens.next();
            if (initial.kind != Token.Kind.LSQUAREBRACKET) {
                IntItem intItem = null;
                return intItem;
            }
            Object rangeStart = "";
            boolean negative = this.tokens.skip(Token.Kind.MINUS);
            if (this.tokens.currentIs(Token.Kind.NUMBER)) {
                rangeStart = (negative ? "-" : "") + this.tokens.next().toString() + this.decimalPart();
            }
            if (!this.tokens.skip(Token.Kind.SEMICOLON)) {
                IntItem intItem = null;
                return intItem;
            }
            Object rangeEnd = "";
            negative = this.tokens.skip(Token.Kind.MINUS);
            if (this.tokens.currentIs(Token.Kind.NUMBER)) {
                rangeEnd = (negative ? "-" : "") + this.tokens.next().toString() + this.decimalPart();
            }
            String range = "[" + (String)rangeStart + ";" + (String)rangeEnd;
            if (this.tokens.skip(Token.Kind.SEMICOLON)) {
                negative = this.tokens.skip(Token.Kind.MINUS);
                if (this.tokens.currentIs(Token.Kind.NUMBER)) {
                    String rangeLimit = (negative ? "-" : "") + this.tokens.next().toString();
                    range = range + ";" + rangeLimit;
                }
            }
            this.tokens.skip(Token.Kind.RSQUAREBRACKET);
            item = new IntItem(range + "]", true);
            item.setOrigin(new Substring(initial.substring.start, this.tokens.currentNoIgnore().substring.start, initial.getSubstring().getSuperstring()));
            IntItem intItem = item;
            return intItem;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntItem numberSmaller() {
        int position = this.tokens.getPosition();
        IntItem item = null;
        try {
            Token initial = this.tokens.next();
            if (initial.kind != Token.Kind.SMALLER) {
                IntItem intItem = null;
                return intItem;
            }
            boolean negative = this.tokens.skipNoIgnore(Token.Kind.MINUS);
            if (!this.tokens.currentIs(Token.Kind.NUMBER)) {
                IntItem intItem = null;
                return intItem;
            }
            item = new IntItem("<" + (negative ? "-" : "") + this.tokens.next() + this.decimalPart(), true);
            item.setOrigin(new Substring(initial.substring.start, this.tokens.currentNoIgnore().substring.start, initial.getSubstring().getSuperstring()));
            IntItem intItem = item;
            return intItem;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntItem numberGreater() {
        int position = this.tokens.getPosition();
        IntItem item = null;
        try {
            Token initial = this.tokens.next();
            if (initial.kind != Token.Kind.GREATER) {
                IntItem intItem = null;
                return intItem;
            }
            boolean negative = this.tokens.skipNoIgnore(Token.Kind.MINUS);
            if (!this.tokens.currentIs(Token.Kind.NUMBER)) {
                IntItem intItem = null;
                return intItem;
            }
            item = new IntItem(">" + (negative ? "-" : "") + this.tokens.next() + this.decimalPart(), true);
            item.setOrigin(new Substring(initial.substring.start, this.tokens.currentNoIgnore().substring.start, initial.getSubstring().getSuperstring()));
            IntItem intItem = item;
            return intItem;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item phraseWord(String indexName, boolean quoted, boolean insidePhrase) {
        int position = this.tokens.getPosition();
        Item item = null;
        try {
            item = this.word(indexName, quoted);
            if (item == null && this.tokens.currentIs(Token.Kind.NUMBER)) {
                Token t = this.tokens.next();
                if (insidePhrase) {
                    item = new WordItem(t, true);
                } else {
                    item = new IntItem(t.toString(), true);
                    ((TermItem)item).setOrigin(t.substring);
                }
            }
            Item item2 = item;
            return item2;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Item word(String indexName, boolean quoted) {
        int position = this.tokens.getPosition();
        Item item = null;
        try {
            if (!(this.tokens.currentIs(Token.Kind.WORD) || (this.tokens.currentIs(Token.Kind.NUMBER) || this.tokens.currentIs(Token.Kind.MINUS) || this.tokens.currentIs(Token.Kind.UNDERSCORE)) && (this.submodes.url || this.submodes.site))) {
                Item item2 = null;
                return item2;
            }
            Token word = this.tokens.next();
            item = this.submodes.url ? new WordItem(word, true) : this.segment(indexName, word, quoted);
            if (this.submodes.url || this.submodes.site) {
                StringBuilder buffer = null;
                Token token = this.tokens.currentNoIgnore();
                while (token.kind == Token.Kind.WORD || token.kind == Token.Kind.NUMBER || token.kind == Token.Kind.MINUS || token.kind == Token.Kind.UNDERSCORE) {
                    if (buffer == null) {
                        buffer = this.getStringContents(item);
                    }
                    buffer.append(token);
                    this.tokens.skipNoIgnore();
                    token = this.tokens.currentNoIgnore();
                }
                if (buffer != null) {
                    Substring termSubstring = ((BlockItem)((Object)item)).getOrigin();
                    Substring substring = new Substring(termSubstring.start, token.substring.start, termSubstring.getSuperstring());
                    String str = buffer.toString();
                    item = new WordItem(str, "", true, substring);
                }
            }
            Item item3 = item;
            return item3;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    private StringBuilder getStringContents(Item item) {
        if (item instanceof TermItem) {
            return new StringBuilder(((TermItem)item).stringValue());
        }
        if (item instanceof SegmentItem) {
            return new StringBuilder(((SegmentItem)item).getRawWord());
        }
        throw new RuntimeException("Parser bug. Unexpected item type, send stack trace in a bug ticket to the Vespa team.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item phrase(String indexName) {
        int position = this.tokens.getPosition();
        Item item = null;
        try {
            Item item2 = item = this.phraseBody(indexName);
            return item2;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    private Item phraseBody(String indexName) {
        boolean starBeforeFirst;
        boolean quoted = false;
        CompositeItem composite = null;
        Item firstWord = null;
        boolean starAfterFirst = false;
        if (this.tokens.skipMultiple(Token.Kind.QUOTE)) {
            quoted = !quoted;
        }
        boolean addStartOfHostMarker = this.addStartMarking();
        this.braceLevelURL = 0;
        do {
            Item word;
            starBeforeFirst = this.tokens.skip(Token.Kind.STAR);
            if (this.tokens.skipMultiple(Token.Kind.QUOTE)) {
                quoted = !quoted;
            }
            if ((word = this.phraseWord(indexName, quoted, firstWord != null || composite != null)) == null) {
                if (this.tokens.skipMultiple(Token.Kind.QUOTE)) {
                    boolean bl = quoted = !quoted;
                }
                if (!quoted || !this.tokens.hasNext()) break;
                this.tokens.skipNoIgnore();
                continue;
            }
            if (quoted && word instanceof PhraseSegmentItem) {
                ((PhraseSegmentItem)word).setExplicit(true);
            }
            if (composite != null) {
                composite.addItem(word);
                this.connectLastTermsIn(composite);
            } else if (firstWord != null) {
                if (this.submodes.site || this.submodes.url) {
                    UriItem uriItem = new UriItem();
                    if (this.submodes.site) {
                        uriItem.setEndAnchorDefault(true);
                    }
                    composite = uriItem;
                } else {
                    composite = quoted || this.indexFacts.getIndex(indexName).getPhraseSegmenting() ? new PhraseItem() : new AndItem();
                }
                if ((quoted || this.submodes.site || this.submodes.url) && composite instanceof PhraseItem) {
                    ((PhraseItem)composite).setExplicit(true);
                }
                if (addStartOfHostMarker) {
                    composite.addItem(MarkerWordItem.createStartOfHost());
                }
                if (firstWord instanceof IntItem) {
                    IntItem asInt = (IntItem)firstWord;
                    firstWord = new WordItem(asInt.stringValue(), asInt.getIndexName(), true, asInt.getOrigin());
                }
                composite.addItem(firstWord);
                composite.addItem(word);
                this.connectLastTermsIn(composite);
            } else if (word instanceof PhraseItem) {
                composite = (PhraseItem)word;
            } else {
                firstWord = word;
                starAfterFirst = this.tokens.skipNoIgnore(Token.Kind.STAR);
            }
            if (!quoted && this.tokens.currentIs(Token.Kind.QUOTE)) break;
            boolean atWord = this.skipToNextPhraseWord(quoted);
            if (!atWord && this.tokens.skipMultipleNoIgnore(Token.Kind.QUOTE)) {
                boolean bl = quoted = !quoted;
            }
            if (!atWord && !quoted || quoted && this.tokens.skipMultiple(Token.Kind.QUOTE)) break;
        } while (this.tokens.hasNext());
        this.braceLevelURL = 0;
        if (composite != null) {
            if (this.addEndMarking()) {
                composite.addItem(MarkerWordItem.createEndOfHost());
            }
            return composite;
        }
        if (firstWord != null && this.submodes.site) {
            if (starAfterFirst && !addStartOfHostMarker) {
                return firstWord;
            }
            composite = new PhraseItem();
            ((PhraseItem)composite).setExplicit(true);
            if (addStartOfHostMarker) {
                composite.addItem(MarkerWordItem.createStartOfHost());
            }
            if (firstWord instanceof IntItem) {
                IntItem asInt = (IntItem)firstWord;
                firstWord = new WordItem(asInt.stringValue(), asInt.getIndexName(), true, asInt.getOrigin());
            }
            composite.addItem(firstWord);
            if (!starAfterFirst) {
                composite.addItem(MarkerWordItem.createEndOfHost());
            }
            return composite;
        }
        if (firstWord != null && firstWord instanceof TermItem && (starAfterFirst || starBeforeFirst)) {
            TermItem firstTerm = (TermItem)firstWord;
            if (starAfterFirst) {
                if (starBeforeFirst) {
                    return new SubstringItem(firstTerm.stringValue(), true);
                }
                return new PrefixItem(firstTerm.stringValue(), true);
            }
            return new SuffixItem(firstTerm.stringValue(), true);
        }
        return firstWord;
    }

    private void connectLastTermsIn(CompositeItem composite) {
        int items = composite.items().size();
        if (items < 2) {
            return;
        }
        Item nextToLast = composite.items().get(items - 2);
        if (nextToLast instanceof AndSegmentItem) {
            List<Item> subItems = ((AndSegmentItem)nextToLast).items();
            nextToLast = subItems.get(subItems.size() - 1);
        }
        if (!(nextToLast instanceof TermItem)) {
            return;
        }
        Item last = composite.items().get(items - 1);
        if (last instanceof AndSegmentItem) {
            last = ((AndSegmentItem)last).items().get(0);
        }
        if (last instanceof TaggableItem) {
            TermItem t1 = (TermItem)nextToLast;
            t1.setConnectivity(last, 1.0);
        }
    }

    private boolean addStartMarking() {
        if (this.submodes.explicitAnchoring() && this.tokens.currentIs(Token.Kind.HAT)) {
            this.tokens.skip();
            return true;
        }
        return false;
    }

    private boolean addEndMarking() {
        if (this.submodes.explicitAnchoring() && this.tokens.currentIs(Token.Kind.DOLLAR)) {
            this.tokens.skip();
            return true;
        }
        if (this.submodes.site && this.tokens.currentIs(Token.Kind.STAR)) {
            this.tokens.skip();
            return false;
        }
        return this.submodes.site && !this.tokens.currentIs(Token.Kind.DOT);
    }

    private boolean skipToNextPhraseWord(boolean quoted) {
        boolean skipped = false;
        do {
            skipped = false;
            if (this.submodes.url) {
                if (this.tokens.currentIsNoIgnore(Token.Kind.RBRACE)) {
                    --this.braceLevelURL;
                }
                if (this.tokens.currentIsNoIgnore(Token.Kind.LBRACE)) {
                    ++this.braceLevelURL;
                }
                if (!this.tokens.hasNext() || this.tokens.currentIsNoIgnore(Token.Kind.SPACE) || this.braceLevelURL < 0) continue;
                this.tokens.skip();
                skipped = true;
                continue;
            }
            if (this.submodes.site) {
                if (!this.tokens.hasNext() || this.tokens.currentIsNoIgnore(Token.Kind.SPACE) || this.tokens.currentIsNoIgnore(Token.Kind.STAR) || this.tokens.currentIsNoIgnore(Token.Kind.HAT) || this.tokens.currentIsNoIgnore(Token.Kind.DOLLAR) || this.tokens.currentIsNoIgnore(Token.Kind.RBRACE)) continue;
                this.tokens.skip();
                skipped = true;
                continue;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.DOT)) {
                skipped = true;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.COMMA)) {
                skipped = true;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.PLUS)) {
                skipped = true;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.MINUS)) {
                skipped = true;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.UNDERSCORE)) {
                skipped = true;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.HAT)) {
                skipped = true;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.DOLLAR)) {
                skipped = true;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.STAR)) {
                skipped = true;
            }
            if (this.tokens.skipMultipleNoIgnore(Token.Kind.COLON)) {
                skipped = true;
            }
            if (quoted) {
                if (this.tokens.skipMultipleNoIgnore(Token.Kind.RBRACE)) {
                    skipped = true;
                }
                if (this.tokens.skipMultipleNoIgnore(Token.Kind.LBRACE)) {
                    skipped = true;
                }
            }
            if (!this.tokens.skipMultipleNoIgnore(Token.Kind.NOISE)) continue;
            skipped = true;
        } while (skipped && !this.tokens.currentIsNoIgnore(Token.Kind.WORD) && !this.tokens.currentIsNoIgnore(Token.Kind.NUMBER) && !this.URLModeWordChar());
        return this.tokens.currentIsNoIgnore(Token.Kind.WORD) || this.tokens.currentIsNoIgnore(Token.Kind.NUMBER) || this.URLModePhraseChar();
    }

    private boolean URLModeWordChar() {
        if (!this.submodes.url) {
            return false;
        }
        return this.tokens.currentIsNoIgnore(Token.Kind.UNDERSCORE) || this.tokens.currentIsNoIgnore(Token.Kind.MINUS);
    }

    private boolean URLModePhraseChar() {
        if (!this.submodes.url) {
            return false;
        }
        return !this.tokens.currentIsNoIgnore(Token.Kind.RBRACE) && !this.tokens.currentIsNoIgnore(Token.Kind.SPACE);
    }
}

