/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.SummaryParameters;
import com.yahoo.prelude.fastsearch.TimeoutException;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.prelude.querytransform.QueryRewrite;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.searchchain.Execution;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;

public class FastSearcher
extends VespaBackEndSearcher {
    private final Dispatcher dispatcher;

    public FastSearcher(String serverId, Dispatcher dispatcher, SummaryParameters docSumParams, ClusterParams clusterParams, DocumentdbInfoConfig documentdbInfoConfig) {
        this.init(serverId, docSumParams, clusterParams, documentdbInfoConfig);
        this.dispatcher = dispatcher;
    }

    @Override
    public Pong ping(Ping ping, Execution execution) {
        throw new IllegalStateException("This ping should not have been called.");
    }

    @Override
    protected void transformQuery(Query query) {
        QueryRewrite.rewriteSddocname(query);
    }

    private void injectSource(HitGroup hits) {
        for (Hit hit : hits.asUnorderedHits()) {
            if (!(hit instanceof FastHit)) continue;
            hit.setSource(this.getName());
        }
    }

    @Override
    public Result doSearch2(Query query, Execution execution) {
        Result result;
        block12: {
            if (this.dispatcher.searchCluster().allGroupsHaveSize1()) {
                this.forceSinglePassGrouping(query);
            }
            SearchInvoker invoker = this.getSearchInvoker(query);
            try {
                Result result2 = invoker.search(query, execution);
                this.injectSource(result2.hits());
                if (query.properties().getBoolean(Ranking.RANKFEATURES, false)) {
                    this.fill(result2, query.getPresentation().getSummary(), execution);
                }
                result = result2;
                if (invoker == null) break block12;
            }
            catch (Throwable result2) {
                try {
                    if (invoker != null) {
                        try {
                            invoker.close();
                        }
                        catch (Throwable throwable) {
                            result2.addSuppressed(throwable);
                        }
                    }
                    throw result2;
                }
                catch (TimeoutException e) {
                    return new Result(query, ErrorMessage.createTimeout(e.getMessage()));
                }
                catch (IOException e) {
                    Result result3 = new Result(query);
                    if (query.getTraceLevel() >= 1) {
                        query.trace(this.getName() + " error response: " + result3, false, 1);
                    }
                    result3.hits().addError(ErrorMessage.createBackendCommunicationError(this.getName() + " failed: " + e.getMessage()));
                    return result3;
                }
            }
            invoker.close();
        }
        return result;
    }

    @Override
    protected void doPartialFill(Result result, String summaryClass) {
        if (result.isFilled(summaryClass)) {
            return;
        }
        Query query = result.getQuery();
        this.traceQuery(this.getName(), "fill", query, query.getOffset(), query.getHits(), 1, FastSearcher.quotedSummaryClass(summaryClass));
        try (FillInvoker invoker = this.getFillInvoker(result);){
            invoker.fill(result, summaryClass);
        }
    }

    private void forceSinglePassGrouping(Query query) {
        for (GroupingRequest groupingRequest : query.getSelect().getGrouping()) {
            this.forceSinglePassGrouping(groupingRequest.getRootOperation());
        }
    }

    private void forceSinglePassGrouping(GroupingOperation operation) {
        operation.setForceSinglePass(true);
        for (GroupingOperation childOperation : operation.getChildren()) {
            this.forceSinglePassGrouping(childOperation);
        }
    }

    private SearchInvoker getSearchInvoker(Query query) {
        return this.dispatcher.getSearchInvoker(query, this);
    }

    private FillInvoker getFillInvoker(Result result) {
        return this.dispatcher.getFillInvoker(result, this);
    }

    private static Optional<String> quotedSummaryClass(String summaryClass) {
        return Optional.of(summaryClass == null ? "[null]" : "'" + summaryClass + "'");
    }

    @Override
    public String toString() {
        return "fast searcher (" + this.getName() + ") ";
    }

    @Override
    protected boolean isLoggingFine() {
        return this.getLogger().isLoggable(Level.FINE);
    }
}

