/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.TypeLiteral;
import com.yahoo.search.yql.ArgumentsTypeChecker;
import com.yahoo.search.yql.ExpressionOperator;
import com.yahoo.search.yql.JavaListTypeChecker;
import com.yahoo.search.yql.JavaTypeChecker;
import com.yahoo.search.yql.JavaUnionTypeChecker;
import com.yahoo.search.yql.NodeTypeChecker;
import com.yahoo.search.yql.Operator;
import com.yahoo.search.yql.OperatorNode;
import com.yahoo.search.yql.OperatorNodeListTypeChecker;
import com.yahoo.search.yql.OperatorTypeChecker;
import com.yahoo.search.yql.SequenceOperator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class TypeCheckers {
    public static final TypeLiteral<List<String>> LIST_OF_STRING = new TypeLiteral<List<String>>(){};
    public static final TypeLiteral<List<List<String>>> LIST_OF_LIST_OF_STRING = new TypeLiteral<List<List<String>>>(){};
    public static final TypeLiteral<List<OperatorNode<SequenceOperator>>> SEQUENCES = new TypeLiteral<List<OperatorNode<SequenceOperator>>>(){};
    public static final TypeLiteral<List<OperatorNode<ExpressionOperator>>> EXPRS = new TypeLiteral<List<OperatorNode<ExpressionOperator>>>(){};
    public static final TypeLiteral<List<List<OperatorNode<ExpressionOperator>>>> LIST_OF_EXPRS = new TypeLiteral<List<List<OperatorNode<ExpressionOperator>>>>(){};
    public static final ImmutableSet<Class<?>> LITERAL_TYPES = ImmutableSet.builder().add(String.class).add(Integer.class).add(Double.class).add(Boolean.class).add(Float.class).add(Byte.class).add(Long.class).add(List.class).add(Map.class).build();

    private TypeCheckers() {
    }

    public static ArgumentsTypeChecker make(Operator target, Object ... types) {
        if (types == null) {
            types = new Object[]{};
        }
        ArrayList checkers = Lists.newArrayListWithCapacity((int)types.length);
        for (int i = 0; i < types.length; ++i) {
            checkers.add(TypeCheckers.createChecker(target, i, types[i]));
        }
        return new ArgumentsTypeChecker(target, checkers);
    }

    private static OperatorTypeChecker createChecker(Operator parent, int idx, Object value) {
        if (value instanceof TypeLiteral) {
            TypeLiteral lit = (TypeLiteral)value;
            Class raw = lit.getRawType();
            if (List.class.isAssignableFrom(raw)) {
                Preconditions.checkArgument((boolean)(lit.getType() instanceof ParameterizedType), (Object)"TypeLiteral without a ParameterizedType for List");
                ParameterizedType type = (ParameterizedType)lit.getType();
                TypeLiteral arg = TypeLiteral.get((Type)type.getActualTypeArguments()[0]);
                if (OperatorNode.class.isAssignableFrom(arg.getRawType())) {
                    Class rawType;
                    Preconditions.checkArgument((boolean)(arg.getType() instanceof ParameterizedType), (Object)"Type spec must be List<OperatorNode<?>>");
                    Class optype = rawType = TypeLiteral.get((Type)((ParameterizedType)arg.getType()).getActualTypeArguments()[0]).getRawType();
                    return new OperatorNodeListTypeChecker(parent, idx, optype, (Set<? extends Operator>)ImmutableSet.of());
                }
                return new JavaListTypeChecker(parent, idx, arg.getRawType());
            }
            throw new IllegalArgumentException("don't know how to handle TypeLiteral " + value);
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            if (Operator.class.isAssignableFrom(clazz)) {
                return new NodeTypeChecker(parent, idx, clazz, (Set<? extends Operator>)ImmutableSet.of());
            }
            return new JavaTypeChecker(parent, idx, clazz);
        }
        if (value instanceof Operator) {
            Object allowed;
            Operator operator = (Operator)value;
            Class<?> clazz = operator.getClass();
            if (Enum.class.isInstance(value)) {
                Class<?> enumClazz = clazz;
                allowed = EnumSet.of((Enum)enumClazz.cast(value));
            } else {
                allowed = ImmutableSet.of((Object)operator);
            }
            return new NodeTypeChecker(parent, idx, clazz, (Set<? extends Operator>)allowed);
        }
        if (value instanceof EnumSet) {
            EnumSet v = (EnumSet)value;
            Enum elt = (Enum)Iterables.get((Iterable)v, (int)0);
            if (elt instanceof Operator) {
                Class<?> opclass = elt.getClass();
                EnumSet allowed = v;
                return new NodeTypeChecker(parent, idx, opclass, allowed);
            }
        } else if (value instanceof Set) {
            return new JavaUnionTypeChecker(parent, idx, (Set)value);
        }
        throw new IllegalArgumentException("I don't know how to create a checker from " + value);
    }
}

