/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.statistics;

import com.yahoo.collections.Tuple2;
import com.yahoo.concurrent.ThreadLocalDirectory;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.statistics.MeasureQpsConfig;
import com.yahoo.statistics.Callback;
import com.yahoo.statistics.Handle;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;

@Deprecated
public class PeakQpsSearcher
extends Searcher {
    private final ThreadLocalDirectory<Deque<QueryRatePerSecond>, Long> directory = PeakQpsSearcher.createDirectory();
    private final Value qpsStatistics;
    private final CompoundName propertyName;
    private final boolean useMetaHit;

    public PeakQpsSearcher(MeasureQpsConfig config, Statistics manager) {
        MeasureQpsConfig.Outputmethod.Enum method = config.outputmethod();
        if (method == MeasureQpsConfig.Outputmethod.METAHIT) {
            this.useMetaHit = true;
            this.propertyName = new CompoundName(config.queryproperty());
            this.qpsStatistics = null;
        } else if (method == MeasureQpsConfig.Outputmethod.STATISTICS) {
            String event = config.eventname();
            if (event == null || event.isEmpty()) {
                event = this.getId().getName();
                event = event.replace('.', '_');
            }
            this.qpsStatistics = new Value(event, manager, new Value.Parameters().setAppendChar(Character.valueOf('_')).setLogMax(Boolean.valueOf(true)).setLogMean(Boolean.valueOf(true)).setLogMin(Boolean.valueOf(false)).setLogRaw(Boolean.valueOf(false)).setNameExtension(Boolean.valueOf(true)).setCallback((Callback)new Fetcher()));
            this.useMetaHit = false;
            this.propertyName = null;
        } else {
            throw new IllegalStateException("Config definition out of sync with implementation. No way to create output for method " + method + ".");
        }
    }

    static ThreadLocalDirectory<Deque<QueryRatePerSecond>, Long> createDirectory() {
        return new ThreadLocalDirectory((ThreadLocalDirectory.Updater)new QueryRate());
    }

    static List<QueryRatePerSecond> merge(List<Deque<QueryRatePerSecond>> measurements) {
        ArrayList<QueryRatePerSecond> rates = new ArrayList<QueryRatePerSecond>();
        while (measurements.size() > 0) {
            ArrayDeque<Deque<QueryRatePerSecond>> consumeFrom = new ArrayDeque<Deque<QueryRatePerSecond>>(measurements.size());
            long current = Long.MAX_VALUE;
            ListIterator<Deque<QueryRatePerSecond>> i = measurements.listIterator();
            while (i.hasNext()) {
                Deque<QueryRatePerSecond> deck = i.next();
                if (deck.size() == 0) {
                    i.remove();
                    continue;
                }
                QueryRatePerSecond threadData = deck.peekFirst();
                if (threadData.when < current) {
                    consumeFrom.clear();
                    current = threadData.when;
                    consumeFrom.add(deck);
                    continue;
                }
                if (threadData.when != current) continue;
                consumeFrom.add(deck);
            }
            if (consumeFrom.size() <= 0) continue;
            rates.add(PeakQpsSearcher.consume(consumeFrom));
        }
        return rates;
    }

    private static QueryRatePerSecond consume(Deque<Deque<QueryRatePerSecond>> consumeFrom) {
        Deque<QueryRatePerSecond> valueQueue = consumeFrom.pop();
        QueryRatePerSecond value = valueQueue.pop();
        QueryRatePerSecond thisSecond = new QueryRatePerSecond(value.when);
        thisSecond.add(value.howMany);
        while (consumeFrom.size() > 0) {
            valueQueue = consumeFrom.pop();
            value = valueQueue.pop();
            thisSecond.add(value.howMany);
        }
        return thisSecond;
    }

    @Override
    public Result search(Query query, Execution execution) {
        long when = query.getStartTime() / 1000L;
        QpsHit meta = null;
        this.directory.update((Object)when);
        if (this.useMetaHit && query.properties().getBoolean(this.propertyName, false)) {
            List<QueryRatePerSecond> l = PeakQpsSearcher.merge(this.directory.fetch());
            Tuple2<Integer, Double> maxAndMean = this.maxAndMean(l);
            meta = new QpsHit((Integer)maxAndMean.first, (Double)maxAndMean.second);
        }
        Result r = execution.search(query);
        if (meta != null) {
            r.hits().add(meta);
        }
        return r;
    }

    private Tuple2<Integer, Double> maxAndMean(List<QueryRatePerSecond> l) {
        int max = Integer.MIN_VALUE;
        double sum = 0.0;
        if (l.size() == 0) {
            return new Tuple2((Object)0, (Object)0.0);
        }
        for (QueryRatePerSecond qps : l) {
            sum += (double)qps.howMany;
            if (qps.howMany <= max) continue;
            max = qps.howMany;
        }
        return new Tuple2((Object)max, (Object)(sum / (double)l.size()));
    }

    private class Fetcher
    implements Callback {
        private Fetcher() {
        }

        public void run(Handle h, boolean firstRun) {
            List data = PeakQpsSearcher.this.directory.fetch();
            List<QueryRatePerSecond> chewed = PeakQpsSearcher.merge(data);
            for (QueryRatePerSecond qps : chewed) {
                PeakQpsSearcher.this.qpsStatistics.put((double)qps.howMany);
            }
        }
    }

    static class QueryRate
    implements ThreadLocalDirectory.Updater<Deque<QueryRatePerSecond>, Long> {
        QueryRate() {
        }

        public Deque<QueryRatePerSecond> update(Deque<QueryRatePerSecond> current, Long when) {
            QueryRatePerSecond last = current.peekLast();
            if (last == null || last.when != when) {
                last = new QueryRatePerSecond(when);
                current.addLast(last);
            }
            last.increment();
            return current;
        }

        public Deque<QueryRatePerSecond> createGenerationInstance(Deque<QueryRatePerSecond> previous) {
            if (previous == null) {
                return new ArrayDeque<QueryRatePerSecond>();
            }
            return new ArrayDeque<QueryRatePerSecond>(previous.size());
        }
    }

    static class QueryRatePerSecond {
        long when;
        int howMany;

        QueryRatePerSecond(long when) {
            this.when = when;
            this.howMany = 0;
        }

        void add(int x) {
            this.howMany += x;
        }

        void increment() {
            ++this.howMany;
        }

        public String toString() {
            return "QueryRatePerSecond(" + this.when + ": " + this.howMany + ")";
        }
    }

    public static class QpsHit
    extends Hit {
        public static final String MEAN_QPS = "mean_qps";
        public static final String PEAK_QPS = "peak_qps";
        public static final String SCHEME = "meta";

        public QpsHit(Integer peakQps, Double meanQps) {
            super("meta:qps");
            this.setField(PEAK_QPS, peakQps);
            this.setField(MEAN_QPS, meanQps);
        }

        @Override
        public boolean isMeta() {
            return true;
        }

        @Override
        public String toString() {
            return "QPS hit: Peak QPS " + this.getField(PEAK_QPS) + ", mean QPS " + this.getField(MEAN_QPS) + ".";
        }
    }
}

