/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.HasIndexItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;

@After(value={"SelectParameterParsing"})
@Before(value={"backend"})
public class QueryValidator
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        IndexFacts.Session session = execution.context().getIndexFacts().newSession(query);
        ToolBox.visit(new ItemValidator(session), query.getModel().getQueryTree().getRoot());
        return execution.search(query);
    }

    private static class ItemValidator
    extends ToolBox.QueryVisitor {
        IndexFacts.Session session;

        public ItemValidator(IndexFacts.Session session) {
            this.session = session;
        }

        @Override
        public boolean visit(Item item) {
            String indexName;
            if (item instanceof HasIndexItem && this.session.getIndex(indexName = ((HasIndexItem)((Object)item)).getIndexName()).isTensor()) {
                throw new IllegalArgumentException("Cannot search '" + indexName + "': It is a tensor field");
            }
            return true;
        }

        @Override
        public void onExit() {
        }
    }
}

