/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;

public class WeakAndReplacementSearcher
extends Searcher {
    private static final CompoundName WEAKAND_REPLACE = new CompoundName("weakAnd.replace");

    @Override
    public Result search(Query query, Execution execution) {
        if (!query.properties().getBoolean(WEAKAND_REPLACE)) {
            return execution.search(query);
        }
        this.replaceOrItems(query);
        return execution.search(query);
    }

    private void replaceOrItems(Query query) {
        Item root = query.getModel().getQueryTree().getRoot();
        int hits = query.properties().getInteger("wand.hits", 100);
        query.getModel().getQueryTree().setRoot(this.replaceOrItems(root, hits));
        if (root != query.getModel().getQueryTree().getRoot()) {
            query.trace("Replaced OR by WeakAnd", true, 2);
        }
    }

    private Item replaceOrItems(Item item, int hits) {
        if (!(item instanceof CompositeItem)) {
            return item;
        }
        CompositeItem compositeItem = (CompositeItem)item;
        if (compositeItem instanceof OrItem) {
            WeakAndItem newItem = new WeakAndItem(hits);
            newItem.setWeight(compositeItem.getWeight());
            compositeItem.items().forEach(newItem::addItem);
            compositeItem = newItem;
        }
        for (int i = 0; i < compositeItem.getItemCount(); ++i) {
            Item subItem = compositeItem.getItem(i);
            Item replacedItem = this.replaceOrItems(subItem, hits);
            if (replacedItem == subItem) continue;
            compositeItem.setItem(i, replacedItem);
        }
        return compositeItem;
    }
}

