/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.RankProperties;
import java.util.Objects;

public class Matching
implements Cloneable {
    private static final QueryProfileType argumentType = new QueryProfileType("matching");
    public static final String TERMWISELIMIT = "termwiselimit";
    public static final String NUMTHREADSPERSEARCH = "numthreadspersearch";
    public static final String NUMSEARCHPARTITIIONS = "numsearchpartitions";
    public static final String MINHITSPERTHREAD = "minhitsperthread";
    public Double termwiseLimit = null;
    private Integer numThreadsPerSearch = null;
    private Integer numSearchPartitions = null;
    private Integer minHitsPerThread = null;

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public Integer getNumSearchPartitions() {
        return this.numSearchPartitions;
    }

    public void setNumSearchPartitions(int numSearchPartitions) {
        this.numSearchPartitions = numSearchPartitions;
    }

    public Integer getMinHitsPerThread() {
        return this.minHitsPerThread;
    }

    public void setMinHitsPerThread(int minHitsPerThread) {
        this.minHitsPerThread = minHitsPerThread;
    }

    public void setTermwiselimit(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalInputException("termwiselimit must be in the range [0.0, 1.0]. It is " + value);
        }
        this.termwiseLimit = value;
    }

    public Double getTermwiseLimit() {
        return this.termwiseLimit;
    }

    public void setNumThreadsPerSearch(int value) {
        this.numThreadsPerSearch = value;
    }

    public Integer getNumThreadsPerSearch() {
        return this.numThreadsPerSearch;
    }

    public void prepare(RankProperties rankProperties) {
        if (this.termwiseLimit != null) {
            rankProperties.put("vespa.matching.termwise_limit", String.valueOf(this.termwiseLimit));
        }
        if (this.numThreadsPerSearch != null) {
            rankProperties.put("vespa.matching.numthreadspersearch", String.valueOf(this.numThreadsPerSearch));
        }
        if (this.numSearchPartitions != null) {
            rankProperties.put("vespa.matching.numsearchpartitions", String.valueOf(this.numSearchPartitions));
        }
        if (this.minHitsPerThread != null) {
            rankProperties.put("vespa.matching.minhitsperthread", String.valueOf(this.minHitsPerThread));
        }
    }

    public Matching clone() {
        try {
            return (Matching)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen", e);
        }
    }

    public int hashCode() {
        int hash = 0;
        if (this.termwiseLimit != null) {
            hash += 11 * this.termwiseLimit.hashCode();
        }
        if (this.numThreadsPerSearch != null) {
            hash += 13 * this.numThreadsPerSearch.hashCode();
        }
        if (this.numSearchPartitions != null) {
            hash += 17 * this.numSearchPartitions.hashCode();
        }
        if (this.minHitsPerThread != null) {
            hash += 19 * this.minHitsPerThread.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Matching)) {
            return false;
        }
        Matching other = (Matching)o;
        if (!Objects.equals(this.termwiseLimit, other.termwiseLimit)) {
            return false;
        }
        if (!Objects.equals(this.numThreadsPerSearch, other.numThreadsPerSearch)) {
            return false;
        }
        if (!Objects.equals(this.numSearchPartitions, other.numSearchPartitions)) {
            return false;
        }
        return Objects.equals(this.minHitsPerThread, other.minHitsPerThread);
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(TERMWISELIMIT, "double"));
        argumentType.addField(new FieldDescription(NUMTHREADSPERSEARCH, "integer"));
        argumentType.addField(new FieldDescription(NUMSEARCHPARTITIIONS, "integer"));
        argumentType.addField(new FieldDescription(MINHITSPERTHREAD, "integer"));
        argumentType.freeze();
    }
}

