/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.search.Query;
import com.yahoo.search.query.profile.types.QueryProfileType;

public class QueryProfileTypeRegistry
extends ComponentRegistry<QueryProfileType> {
    private int nextAnonymousId = 0;
    private final int nativeProfileCount;

    public QueryProfileTypeRegistry() {
        Query.addNativeQueryProfileTypesTo(this);
        this.nativeProfileCount = this.allComponents().size();
    }

    public void register(QueryProfileType type) {
        super.register(type.getId(), (Object)type);
    }

    public boolean hasApplicationTypes() {
        return this.allComponents().size() > this.nativeProfileCount;
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        for (QueryProfileType queryProfileType : this.allComponents()) {
            queryProfileType.freeze();
        }
    }

    public static QueryProfileTypeRegistry emptyFrozen() {
        QueryProfileTypeRegistry registry = new QueryProfileTypeRegistry();
        registry.freeze();
        return registry;
    }

    public ComponentId createAnonymousId(String name) {
        return ComponentId.newAnonymous((String)(name + "_" + this.nextAnonymousId++));
    }
}

