/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.result;

import com.yahoo.io.ByteWriter;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.prelude.hitfield.HitField;
import com.yahoo.prelude.hitfield.JSONString;
import com.yahoo.prelude.hitfield.XMLString;
import com.yahoo.processing.rendering.AsynchronousSectionedRenderer;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.pagetemplates.model.Renderer;
import com.yahoo.search.pagetemplates.model.Source;
import com.yahoo.search.pagetemplates.result.SectionHitGroup;
import com.yahoo.search.rendering.XmlRenderer;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.DefaultErrorHit;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.StructuredData;
import com.yahoo.text.Utf8String;
import com.yahoo.text.XML;
import com.yahoo.text.XMLWriter;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class PageTemplatesXmlRenderer
extends AsynchronousSectionedRenderer<Result> {
    public static final String DEFAULT_MIMETYPE = "text/xml";
    public static final String DEFAULT_ENCODING = "utf-8";
    private static final Utf8String GROUP = new Utf8String("group");
    private static final Utf8String HIT = new Utf8String("hit");
    private static final Utf8String ERROR = new Utf8String("error");
    private static final Utf8String CODE = new Utf8String("code");
    private static final Utf8String COVERAGE_DOCS = new Utf8String("coverage-docs");
    private static final Utf8String COVERAGE_NODES = new Utf8String("coverage-nodes");
    private static final Utf8String COVERAGE_FULL = new Utf8String("coverage-full");
    private static final Utf8String COVERAGE = new Utf8String("coverage");
    private static final Utf8String RESULTS_FULL = new Utf8String("results-full");
    private static final Utf8String RESULTS = new Utf8String("results");
    private static final Utf8String TYPE = new Utf8String("type");
    private static final Utf8String RELEVANCE = new Utf8String("relevance");
    private static final Utf8String SOURCE = new Utf8String("source");
    private XMLWriter writer;

    public PageTemplatesXmlRenderer() {
        this(null);
    }

    public PageTemplatesXmlRenderer(Executor executor) {
        super(executor);
    }

    public void init() {
        super.init();
        this.writer = null;
    }

    public String getEncoding() {
        if (this.getResult() == null || this.getResult().getQuery() == null || this.getResult().getQuery().getModel().getEncoding() == null) {
            return DEFAULT_ENCODING;
        }
        return this.getResult().getQuery().getModel().getEncoding();
    }

    public String getMimeType() {
        return DEFAULT_MIMETYPE;
    }

    private XMLWriter wrapWriter(Writer writer) {
        return XMLWriter.from((Writer)writer, (int)10, (int)-1);
    }

    private void header(XMLWriter writer, Result result) {
        writer.xmlHeader(this.getRequestedEncoding(result.getQuery()));
        writer.openTag("page").attribute("version", (Object)"1.0").attribute("layout", result.hits().getField("layout"));
        PageTemplatesXmlRenderer.renderCoverageAttributes(result.getCoverage(false), writer);
        writer.closeStartTag();
        this.renderSectionContent(writer, result.hits());
    }

    private static void renderCoverageAttributes(Coverage coverage, XMLWriter writer) {
        if (coverage == null) {
            return;
        }
        writer.attribute(COVERAGE_DOCS, coverage.getDocs());
        writer.attribute(COVERAGE_NODES, (long)coverage.getNodes());
        writer.attribute(COVERAGE_FULL, coverage.getFull());
        writer.attribute(COVERAGE, (long)coverage.getResultPercentage());
        writer.attribute(RESULTS_FULL, (long)coverage.getFullResultSets());
        writer.attribute(RESULTS, (long)coverage.getResultSets());
    }

    public void error(XMLWriter writer, Result result) {
        ErrorMessage error = result.hits().getError();
        writer.openTag(ERROR).attribute(CODE, (long)error.getCode()).content((Object)error.getMessage(), false).closeTag();
    }

    private void queryContext(XMLWriter writer, Query owner) {
        if (owner.getTraceLevel() != 0) {
            XMLWriter xmlWriter = XMLWriter.from((Writer)writer);
            xmlWriter.openTag("meta").attribute("type", (Object)"context");
            TraceNode traceRoot = owner.getModel().getExecution().trace().traceNode().root();
            traceRoot.accept((TraceVisitor)new XmlRenderer.RenderingVisitor(xmlWriter, owner.getStartTime()));
            xmlWriter.closeTag();
        }
    }

    private void renderSingularHit(XMLWriter writer, Hit hit) {
        if (!hit.isMeta() && !writer.isIn("content")) {
            writer.openTag("content");
        }
        writer.openTag(HIT);
        this.renderHitAttributes(hit, writer);
        writer.closeStartTag();
        this.renderField(writer, "id", hit.getId());
        hit.forEachField((name, value) -> this.renderField(writer, (String)name, value));
        writer.closeTag();
    }

    private void renderHitAttributes(Hit hit, XMLWriter writer) {
        writer.attribute(TYPE, hit.types().stream().collect(Collectors.joining(" ")));
        if (hit.getRelevance() != null) {
            writer.attribute(RELEVANCE, hit.getRelevance().toString());
        }
        writer.attribute(SOURCE, hit.getSource());
    }

    private void renderField(XMLWriter writer, String name, Object value) {
        writer.openTag(name);
        this.renderFieldContent(writer, value);
        writer.closeTag();
    }

    private void renderFieldContent(XMLWriter writer, Object value) {
        writer.escapedContent(this.asXML(value), false);
    }

    private String asXML(Object value) {
        if (value == null) {
            return "(null)";
        }
        if (value instanceof HitField) {
            return ((HitField)value).quotedContent(false);
        }
        if (value instanceof StructuredData || value instanceof XMLString || value instanceof JSONString) {
            return value.toString();
        }
        return XML.xmlEscape((String)value.toString(), (boolean)false, (char)'\u001f');
    }

    private void renderHitAttributes(XMLWriter writer, Hit hit) {
        writer.attribute(TYPE, hit.types().stream().collect(Collectors.joining(" ")));
        if (hit.getRelevance() != null) {
            writer.attribute(RELEVANCE, hit.getRelevance().toString());
        }
        writer.attribute(SOURCE, hit.getSource());
    }

    private void renderHitGroup(XMLWriter writer, HitGroup hit) {
        if (hit.types().contains("section")) {
            this.renderSection(writer, hit);
        } else if (hit.types().contains("meta")) {
            writer.openTag("meta");
            writer.closeStartTag();
        } else {
            this.renderGroup(writer, hit);
        }
    }

    private void renderGroup(XMLWriter writer, HitGroup hit) {
        writer.openTag(GROUP);
        this.renderHitAttributes(writer, hit);
        writer.closeStartTag();
    }

    private void renderSection(XMLWriter writer, HitGroup hit) {
        writer.openTag("section");
        writer.attribute("id", (Object)hit.getDisplayId());
        writer.attribute("layout", hit.getField("layout"));
        writer.attribute("region", hit.getField("region"));
        writer.attribute("placement", hit.getField("placement"));
        writer.closeStartTag();
        this.renderSectionContent(writer, hit);
    }

    private void renderSectionContent(XMLWriter writer, HitGroup hit) {
        if (hit instanceof SectionHitGroup) {
            SectionHitGroup sectionGroup = (SectionHitGroup)hit;
            for (Source source : sectionGroup.sources()) {
                writer.openTag("source").attribute("url", (Object)source.getUrl());
                this.renderParameters(source.parameters(), writer);
                writer.closeTag();
            }
            for (Renderer renderer : sectionGroup.renderers()) {
                writer.openTag("renderer").attribute("for", (Object)renderer.getRendererFor()).attribute("name", (Object)renderer.getName());
                this.renderParameters(renderer.parameters(), writer);
                writer.closeTag();
            }
        }
    }

    private void renderParameters(Map<String, String> parameters, XMLWriter writer) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            writer.openTag("parameter").attribute("name", (Object)parameter.getKey()).content((Object)parameter.getValue(), false).closeTag();
        }
    }

    private boolean simpleRenderHit(XMLWriter writer, Hit hit) {
        if (hit instanceof DefaultErrorHit) {
            return PageTemplatesXmlRenderer.simpleRenderDefaultErrorHit(writer, (DefaultErrorHit)hit);
        }
        return hit instanceof GroupingListHit;
    }

    public static boolean simpleRenderDefaultErrorHit(XMLWriter writer, ErrorHit defaultErrorHit) {
        writer.openTag("errordetails");
        Iterator<? extends ErrorMessage> i = defaultErrorHit.errorIterator();
        while (i.hasNext()) {
            ErrorMessage error = i.next();
            PageTemplatesXmlRenderer.renderMessageDefaultErrorHit(writer, error);
        }
        writer.closeTag();
        return true;
    }

    public static void renderMessageDefaultErrorHit(XMLWriter writer, ErrorMessage error) {
        writer.openTag("error");
        writer.attribute("source", (Object)error.getSource());
        writer.attribute("error", (Object)error.getMessage());
        writer.attribute("code", (Object)Integer.toString(error.getCode()));
        writer.content((Object)error.getDetailedMessage(), false);
        if (error.getCause() != null) {
            writer.openTag("cause");
            writer.content((Object)"\n", true);
            StringWriter stackTrace = new StringWriter();
            error.getCause().printStackTrace(new PrintWriter(stackTrace));
            writer.content((Object)stackTrace.toString(), true);
            writer.closeTag();
        }
        writer.closeTag();
    }

    private Result getResult() {
        try {
            return (Result)this.getResponse();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("PageTemplatesXmlRenderer attempted used outside a search context, got a " + this.getResponse().getClass().getName());
        }
    }

    public void beginResponse(OutputStream stream) {
        Charset cs = Charset.forName(this.getRequestedEncoding(this.getResult().getQuery()));
        CharsetEncoder encoder = cs.newEncoder();
        this.writer = this.wrapWriter((Writer)new ByteWriter(stream, encoder));
        this.header(this.writer, this.getResult());
        if (this.getResult().hits().getError() != null || this.getResult().hits().getQuery().errors().size() > 0) {
            this.error(this.writer, this.getResult());
        }
        if (this.getResult().getContext(false) != null) {
            this.queryContext(this.writer, this.getResult().getQuery());
        }
    }

    public final String getRequestedEncoding(Query query) {
        String encoding = query.getModel().getEncoding();
        if (encoding != null) {
            return encoding;
        }
        return this.getEncoding();
    }

    public void beginList(DataList<?> list) {
        if (this.getRecursionLevel() == 1) {
            return;
        }
        HitGroup hit = (HitGroup)list;
        boolean renderedSimple = this.simpleRenderHit(this.writer, hit);
        if (renderedSimple) {
            return;
        }
        this.renderHitGroup(this.writer, hit);
    }

    public void data(Data data) {
        Hit hit = (Hit)data;
        boolean renderedSimple = this.simpleRenderHit(this.writer, hit);
        if (!renderedSimple) {
            this.renderSingularHit(this.writer, hit);
        }
    }

    public void endList(DataList<?> list) {
        if (this.writer.isIn("content")) {
            this.writer.closeTag();
        }
        if (this.getRecursionLevel() > 1) {
            this.writer.closeTag();
        }
    }

    public void endResponse() {
        this.writer.closeTag();
        this.writer.close();
    }
}

