/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation;

import com.google.common.collect.ImmutableList;
import com.yahoo.search.Result;
import com.yahoo.search.federation.FederationSearcher;
import com.yahoo.search.searchchain.FutureResult;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

class FederationResult {
    private final List<TargetResult> targetResults;
    private List<TargetResult> targetsToWaitFor;

    private FederationResult(ImmutableList<TargetResult> targetResults) {
        this.targetResults = targetResults;
        this.targetsToWaitFor = targetResults.stream().anyMatch(rec$ -> ((TargetResult)rec$).isMandatory()) ? targetResults.stream().filter(rec$ -> ((TargetResult)rec$).isMandatory()).collect(Collectors.toList()) : new ArrayList<TargetResult>((Collection<TargetResult>)targetResults);
    }

    public void waitForAll(int queryTimeout, Clock clock) {
        long startTime = clock.millis();
        while (!this.targetsToWaitFor.isEmpty()) {
            TargetResult nextToWaitFor = this.targetWithSmallestTimeout(this.targetsToWaitFor, queryTimeout);
            long timeLeftOfNextTimeout = (long)nextToWaitFor.timeout(queryTimeout) - (clock.millis() - startTime);
            nextToWaitFor.getIfAvailable(timeLeftOfNextTimeout);
            this.targetsToWaitFor.remove(nextToWaitFor);
        }
    }

    public List<TargetResult> all() {
        return this.targetResults;
    }

    private TargetResult targetWithSmallestTimeout(List<TargetResult> results, int queryTimeout) {
        TargetResult smallest = null;
        for (TargetResult result : results) {
            if (smallest != null && result.timeout(queryTimeout) >= smallest.timeout(queryTimeout)) continue;
            smallest = result;
        }
        return smallest;
    }

    public static class Builder {
        private final ImmutableList.Builder<TargetResult> results = new ImmutableList.Builder();

        public void add(FederationSearcher.Target target, FutureResult futureResult) {
            this.results.add((Object)new TargetResult(target, futureResult));
        }

        public FederationResult build() {
            return new FederationResult((ImmutableList<TargetResult>)this.results.build());
        }
    }

    static class TargetResult {
        final FederationSearcher.Target target;
        private final FutureResult futureResult;
        private Optional<Result> availableResult = Optional.empty();

        private TargetResult(FederationSearcher.Target target, FutureResult futureResult) {
            this.target = target;
            this.futureResult = futureResult;
        }

        private boolean isMandatory() {
            return !this.target.federationOptions().getOptional();
        }

        public Optional<Result> getIfAvailable(long timeout) {
            if (this.availableResult.isPresent()) {
                return this.availableResult;
            }
            this.availableResult = this.futureResult.getIfAvailable(timeout, TimeUnit.MILLISECONDS);
            this.availableResult.ifPresent(result -> this.target.modifyTargetResult((Result)result));
            return this.availableResult;
        }

        public Result getOrTimeoutError() {
            return this.getIfAvailable(0L).orElse(this.futureResult.get(0L, TimeUnit.MILLISECONDS));
        }

        public boolean successfullyCompleted() {
            return this.futureResult.isDone() && !this.futureResult.isCancelled();
        }

        private int timeout(long queryTimeout) {
            return (int)this.target.federationOptions().getSearchChainExecutionTimeoutInMilliseconds(queryTimeout);
        }

        public String toString() {
            return "result for " + this.target;
        }
    }
}

