/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.yahoo.collections.Hashlet;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.ObjectTraverser;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.Value;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class MatchFeatureData {
    private final Hashlet<String, Integer> hashlet = new Hashlet();

    MatchFeatureData(List<String> keys) {
        this.hashlet.reserve(keys.size());
        int i = 0;
        for (String key : keys) {
            this.hashlet.put((Object)key, (Object)i++);
        }
    }

    HitValue addHit() {
        return new HitValue(this.hashlet);
    }

    static class HitValue
    extends Value {
        private final Hashlet<String, Integer> hashlet;
        private final byte[][] dataValues;
        private final double[] doubleValues;

        public Type type() {
            return Type.OBJECT;
        }

        public boolean valid() {
            return true;
        }

        public int fieldCount() {
            return this.hashlet.size();
        }

        public void traverse(ObjectTraverser ot) {
            for (int i = 0; i < this.hashlet.size(); ++i) {
                String fn = (String)this.hashlet.key(i);
                int offset = (Integer)this.hashlet.value(i);
                ot.field(fn, this.valueAt(offset));
            }
        }

        public Inspector field(String name) {
            int offset = this.hashlet.getIndexOfKey((Object)name);
            if (offset < 0) {
                return HitValue.invalid();
            }
            return this.valueAt(offset);
        }

        public Iterable<Map.Entry<String, Inspector>> fields() {
            ArrayList<Map.Entry<String, Inspector>> list = new ArrayList<Map.Entry<String, Inspector>>(this.hashlet.size());
            for (int i = 0; i < this.hashlet.size(); ++i) {
                String fn = (String)this.hashlet.key(i);
                int offset = (Integer)this.hashlet.value(i);
                list.add(new AbstractMap.SimpleEntry<String, Inspector>(fn, this.valueAt(offset)));
            }
            return list;
        }

        private HitValue(Hashlet<String, Integer> hashlet) {
            this.hashlet = hashlet;
            this.dataValues = new byte[hashlet.size()][];
            this.doubleValues = new double[hashlet.size()];
        }

        void set(int index, byte[] data) {
            this.dataValues[index] = data;
        }

        void set(int index, double value) {
            this.doubleValues[index] = value;
        }

        private Inspector valueAt(int index) {
            if (this.dataValues[index] != null) {
                return new Value.DataValue(this.dataValues[index]);
            }
            return new Value.DoubleValue(this.doubleValues[index]);
        }
    }
}

