/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cluster;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.search.cluster.BaseNodeMonitor;
import com.yahoo.search.cluster.MonitorConfiguration;
import com.yahoo.search.cluster.NodeManager;
import com.yahoo.search.cluster.TrafficNodeMonitor;
import com.yahoo.search.result.ErrorMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterMonitor<T> {
    private static final Logger log = Logger.getLogger(ClusterMonitor.class.getName());
    private final MonitorConfiguration configuration = new MonitorConfiguration();
    private final NodeManager<T> nodeManager;
    private final MonitorThread monitorThread;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Map<T, TrafficNodeMonitor<T>> nodeMonitors = Collections.synchronizedMap(new LinkedHashMap());

    @Deprecated
    public ClusterMonitor(NodeManager<T> manager) {
        this(manager, true);
    }

    public ClusterMonitor(NodeManager<T> manager, boolean startPingThread) {
        this.nodeManager = manager;
        this.monitorThread = new MonitorThread("search.clustermonitor");
        if (startPingThread) {
            this.monitorThread.start();
        }
    }

    public void start() {
        if (!this.monitorThread.isAlive()) {
            this.monitorThread.start();
        }
    }

    public MonitorConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void add(T node, boolean internal) {
        this.nodeMonitors.put(node, new TrafficNodeMonitor<T>(node, this.configuration, internal));
    }

    public BaseNodeMonitor<T> getNodeMonitor(T node) {
        return this.nodeMonitors.get(node);
    }

    public synchronized void failed(T node, ErrorMessage error) {
        if (this.closed.get()) {
            return;
        }
        TrafficNodeMonitor<T> monitor = this.nodeMonitors.get(node);
        Boolean wasWorking = monitor.isKnownWorking();
        monitor.failed(error);
        if (wasWorking != monitor.isKnownWorking()) {
            this.nodeManager.failed(node);
        }
    }

    public synchronized void responded(T node) {
        if (this.closed.get()) {
            return;
        }
        TrafficNodeMonitor<T> monitor = this.nodeMonitors.get(node);
        Boolean wasWorking = monitor.isKnownWorking();
        monitor.responded();
        if (wasWorking != monitor.isKnownWorking()) {
            this.nodeManager.working(node);
        }
    }

    public void ping(Executor executor) {
        Iterator<BaseNodeMonitor<T>> i = this.nodeMonitorIterator();
        while (i.hasNext() && !this.closed.get()) {
            BaseNodeMonitor<T> monitor = i.next();
            this.nodeManager.ping(this, monitor.getNode(), executor);
        }
        if (this.closed.get()) {
            return;
        }
        this.nodeManager.pingIterationCompleted();
    }

    public Iterator<BaseNodeMonitor<T>> nodeMonitorIterator() {
        return this.nodeMonitors().iterator();
    }

    public List<BaseNodeMonitor<T>> nodeMonitors() {
        return new ArrayList<BaseNodeMonitor<T>>(this.nodeMonitors.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.closed.set(true);
        Object object = this;
        synchronized (object) {
            this.nodeMonitors.clear();
        }
        object = this.nodeManager;
        synchronized (object) {
            this.nodeManager.notifyAll();
        }
        try {
            if (this.monitorThread.isAlive()) {
                this.monitorThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class MonitorThread
    extends Thread {
        MonitorThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("Starting cluster monitor thread " + this.getName());
            ExecutorService pingExecutor = Executors.newCachedThreadPool(ThreadFactoryFactory.getDaemonThreadFactory((String)"search.ping"));
            while (!ClusterMonitor.this.closed.get()) {
                try {
                    log.finest("Activating ping");
                    ClusterMonitor.this.ping(pingExecutor);
                    NodeManager nodeManager = ClusterMonitor.this.nodeManager;
                    synchronized (nodeManager) {
                        ClusterMonitor.this.nodeManager.wait(ClusterMonitor.this.configuration.getCheckInterval());
                    }
                }
                catch (Throwable e) {
                    if (ClusterMonitor.this.closed.get() && e instanceof InterruptedException) break;
                    if (!(e instanceof Exception)) {
                        log.log(Level.WARNING, "Error in monitor thread, will quit", e);
                        break;
                    }
                    log.log(Level.WARNING, "Exception in monitor thread", e);
                }
            }
            pingExecutor.shutdown();
            try {
                pingExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info("Stopped cluster monitor thread " + this.getName());
        }
    }
}

