/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cluster;

import com.yahoo.search.cluster.MonitorConfiguration;
import com.yahoo.search.result.ErrorMessage;
import java.util.logging.Logger;

public abstract class BaseNodeMonitor<T> {
    protected static Logger log = Logger.getLogger(BaseNodeMonitor.class.getName());
    protected T node;
    protected boolean isWorking = true;
    protected boolean isQuarantined = false;
    protected long failedAt = 0L;
    protected long respondedAt = 0L;
    protected long succeededAt = 0L;
    protected MonitorConfiguration configuration;
    private final boolean internal;

    public BaseNodeMonitor(boolean internal) {
        this.internal = internal;
    }

    public T getNode() {
        return this.node;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    @Deprecated
    public boolean isQuarantined() {
        return this.isQuarantined;
    }

    public abstract void failed(ErrorMessage var1);

    public abstract void responded();

    @Deprecated
    public boolean isIdle() {
        return this.now() - this.respondedAt >= this.configuration.getIdleLimit();
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    protected abstract void setWorking(boolean var1, String var2);

    public boolean isInternal() {
        return this.internal;
    }
}

