/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.semantics.engine.Match;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.TermProduction;
import com.yahoo.protect.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LiteralPhraseProduction
extends TermProduction {
    private final List<String> terms = new ArrayList<String>();

    public LiteralPhraseProduction() {
    }

    public LiteralPhraseProduction(String label) {
        super(label);
    }

    public void addTerm(String term) {
        Validator.ensureNotNull((String)"A term in a produced phrase", (Object)term);
        this.terms.add(term);
    }

    public List<String> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    @Override
    public void produce(RuleEvaluation e, int offset) {
        PhraseItem newPhrase = new PhraseItem();
        newPhrase.setIndexName(this.getLabel());
        for (String term : this.terms) {
            newPhrase.addItem(new WordItem(term));
        }
        if (this.replacing) {
            Match matched = e.getNonreferencedMatch(0);
            this.insertMatch(e, matched, newPhrase, offset);
        } else {
            newPhrase.setWeight(this.getWeight());
            if (e.getTraceLevel() >= 6) {
                e.trace(6, "Adding '" + newPhrase + "'");
            }
            e.addItem(newPhrase, this.getTermType());
        }
    }

    @Override
    public String toInnerTermString() {
        return this.getLabelString() + "\"" + this.getSpaceSeparated(this.terms) + "\"";
    }

    private String getSpaceSeparated(List<String> terms) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> i = terms.iterator();
        while (i.hasNext()) {
            builder.append(i.next());
            if (!i.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }
}

