/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultipleResultsSearcher
extends Searcher {
    private static final String propertyPrefix = "multipleresultsets.";
    private static final CompoundName additionalHitsFactorName = new CompoundName("multipleresultsets.additionalHitsFactor");
    private static final CompoundName maxTimesRetrieveHeterogeneousHitsName = new CompoundName("multipleresultsets.maxTimesRetrieveHeterogeneousHits");
    private static final CompoundName numHits = new CompoundName("multipleresultsets.numHits");

    @Override
    public Result search(Query query, Execution e) {
        try {
            Parameters parameters = new Parameters(query);
            query.trace("MultipleResultsSearcher: " + parameters, false, 2);
            HitsRetriever hitsRetriever = new HitsRetriever(query, e, parameters);
            for (DocumentGroup documentGroup : parameters.documentGroups) {
                if (hitsRetriever.numHits(documentGroup) >= documentGroup.targetNumberOfDocuments) continue;
                hitsRetriever.retrieveMoreHits(documentGroup);
            }
            return hitsRetriever.createMultipleResultSets();
        }
        catch (ParameterException exception) {
            Result result = new Result(query);
            result.hits().addError(ErrorMessage.createInvalidQueryParameter(exception.msg));
            return result;
        }
    }

    private static class ParameterException
    extends Exception {
        String msg;

        ParameterException(String msg) {
            this.msg = msg;
        }
    }

    private static class DocumentGroup {
        String documentName;
        int targetNumberOfDocuments;

        DocumentGroup(String documentName, int targetNumberOfDocuments) {
            this.documentName = documentName;
            this.targetNumberOfDocuments = targetNumberOfDocuments;
        }
    }

    private static class Parameters {
        List<DocumentGroup> documentGroups = new ArrayList<DocumentGroup>();
        double additionalHitsFactor = 0.8;
        int maxTimesRetrieveHeterogeneousHits = 2;

        Parameters(Query query) throws ParameterException {
            this.readNumHitsSpecification(query);
            this.readMaxTimesRetrieveHeterogeneousHits(query);
            this.readAdditionalHitsFactor(query);
        }

        private void readAdditionalHitsFactor(Query query) throws ParameterException {
            String additionalHitsFactorStr = query.properties().getString(additionalHitsFactorName);
            if (additionalHitsFactorStr == null) {
                return;
            }
            try {
                this.additionalHitsFactor = Double.parseDouble(additionalHitsFactorStr);
            }
            catch (NumberFormatException e) {
                throw new ParameterException("Expected floating point number, got '" + additionalHitsFactorStr + "'.");
            }
        }

        private void readMaxTimesRetrieveHeterogeneousHits(Query query) {
            this.maxTimesRetrieveHeterogeneousHits = query.properties().getInteger(maxTimesRetrieveHeterogeneousHitsName, this.maxTimesRetrieveHeterogeneousHits);
        }

        private void readNumHitsSpecification(Query query) throws ParameterException {
            String[] numHitsForDocumentNames;
            String numHitsSpecification = query.properties().getString(numHits);
            if (numHitsSpecification == null) {
                return;
            }
            for (String s : numHitsForDocumentNames = numHitsSpecification.split(",")) {
                this.handleDocumentNameWithNumberOfHits(s);
            }
        }

        public String toString() {
            String s = "additionalHitsFactor=" + this.additionalHitsFactor + ", maxTimesRetrieveHeterogeneousHits=" + this.maxTimesRetrieveHeterogeneousHits + ", numHitsSpecification='";
            for (DocumentGroup group : this.documentGroups) {
                s = s + group.documentName + ":" + group.targetNumberOfDocuments + ", ";
            }
            s = s + "'";
            return s;
        }

        private void handleDocumentNameWithNumberOfHits(String s) throws ParameterException {
            String[] documentNameWithNumberOfHits = s.split(":");
            if (documentNameWithNumberOfHits.length != 2) {
                String msg = "Expected a single ':' in '" + s + "'.";
                if (documentNameWithNumberOfHits.length > 2) {
                    msg = msg + " Please check for missing commas.";
                }
                throw new ParameterException(msg);
            }
            String documentName = documentNameWithNumberOfHits[0].trim();
            try {
                int numHits = Integer.parseInt(documentNameWithNumberOfHits[1].trim());
                this.numRequestedHits(documentName, numHits);
            }
            catch (NumberFormatException e) {
                throw new ParameterException("Excpected an integer but got '" + documentNameWithNumberOfHits[1] + "'");
            }
        }

        private void numRequestedHits(String documentName, int numHits) {
            this.documentGroups.add(new DocumentGroup(documentName, numHits));
        }
    }

    private static class PartitionedResult {
        private Map<String, HitGroup> resultSets = new HashMap<String, HitGroup>();
        private List<Hit> otherHits = new ArrayList<Hit>();

        PartitionedResult(List<DocumentGroup> documentGroups, Result result) throws ParameterException {
            for (DocumentGroup group : documentGroups) {
                this.addGroup(group);
            }
            this.addHits(result, true);
        }

        void addHits(Result result, boolean addOtherHits) {
            Iterator<Hit> i = result.hits().iterator();
            while (i.hasNext()) {
                this.add(i.next(), addOtherHits);
            }
        }

        void addHits(Result result) {
            this.addHits(result, false);
        }

        void add(Hit hit, boolean addOtherHits) {
            HitGroup resultSet;
            String documentName = (String)hit.getField("sddocname");
            if (documentName != null && (resultSet = this.resultSets.get(documentName)) != null) {
                resultSet.add(hit);
                return;
            }
            if (addOtherHits) {
                this.otherHits.add(hit);
            }
        }

        int numHits(String documentName) {
            return this.resultSets.get(documentName).size();
        }

        void insertInto(HitGroup group) {
            for (Hit hit : this.otherHits) {
                group.add(hit);
            }
            for (HitGroup hitGroup : this.resultSets.values()) {
                hitGroup.copyOrdering(group);
                group.add(hitGroup);
            }
        }

        void cropResultSet(String documentName, int numDocuments) {
            this.resultSets.get(documentName).trim(0, numDocuments);
        }

        private void addGroup(DocumentGroup group) throws ParameterException {
            String documentName = group.documentName;
            if (this.resultSets.put(group.documentName, new HitGroup(documentName){
                private static final long serialVersionUID = 5732822886080288688L;
            }) != null) {
                throw new ParameterException("Document name " + group.documentName + "mentioned multiple times");
            }
        }
    }

    private class HitsRetriever {
        PartitionedResult partitionedResult;
        private int numRetrieveMoreHitsCalls = 0;
        private int nextOffset;
        private Query query;
        private final Parameters parameters;
        private final int hits;
        private final int offset;
        private Execution execution;
        private Result initialResult;

        HitsRetriever(Query query, Execution execution, Parameters parameters) throws ParameterException {
            this.offset = query.getOffset();
            this.hits = query.getHits();
            this.nextOffset = query.getOffset() + query.getHits();
            this.query = query;
            this.parameters = parameters;
            this.execution = execution;
            this.initialResult = this.retrieveHits();
            this.partitionedResult = new PartitionedResult(parameters.documentGroups, this.initialResult);
            this.query = query;
        }

        void retrieveMoreHits(DocumentGroup documentGroup) {
            if (++this.numRetrieveMoreHitsCalls < this.parameters.maxTimesRetrieveHeterogeneousHits) {
                this.retrieveHeterogenousHits();
                if (this.numHits(documentGroup) < documentGroup.targetNumberOfDocuments) {
                    this.retrieveMoreHits(documentGroup);
                }
            } else {
                this.retrieveRemainingHitsForGroup(documentGroup);
            }
        }

        void retrieveHeterogenousHits() {
            int numHitsToRetrieve = (int)((double)this.hits * this.parameters.additionalHitsFactor);
            int maxNumHitsToRetrieve = 1000;
            numHitsToRetrieve = Math.min(numHitsToRetrieve, 1000);
            try {
                this.query.setWindow(this.nextOffset, numHitsToRetrieve);
                this.partitionedResult.addHits(this.retrieveHits());
            }
            finally {
                this.restoreWindow();
                this.nextOffset += numHitsToRetrieve;
            }
        }

        private void restoreWindow() {
            this.query.setWindow(this.offset, this.hits);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void retrieveRemainingHitsForGroup(DocumentGroup documentGroup) {
            Set<String> oldRestrictList = this.query.getModel().getRestrict();
            try {
                int numMissingHits = documentGroup.targetNumberOfDocuments - this.numHits(documentGroup);
                int offset = this.numHits(documentGroup);
                this.query.getModel().getRestrict().clear();
                this.query.getModel().getRestrict().add(documentGroup.documentName);
                this.query.setWindow(offset, numMissingHits);
                this.partitionedResult.addHits(this.retrieveHits());
            }
            finally {
                this.restoreWindow();
                this.query.getModel().getRestrict().clear();
                this.query.getModel().getRestrict().addAll(oldRestrictList);
            }
        }

        int numHits(DocumentGroup documentGroup) {
            return this.partitionedResult.numHits(documentGroup.documentName);
        }

        Result createMultipleResultSets() {
            Iterator<Hit> i = this.initialResult.hits().iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            for (DocumentGroup group : this.parameters.documentGroups) {
                this.partitionedResult.cropResultSet(group.documentName, group.targetNumberOfDocuments);
            }
            this.partitionedResult.insertInto(this.initialResult.hits());
            return this.initialResult;
        }

        private Result retrieveHits() {
            Result result = this.execution.search(this.query);
            this.execution.fill(result);
            if (this.initialResult != null) {
                this.initialResult.hits().addErrorsFrom(result.hits());
            }
            return result;
        }
    }
}

