/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NonReducibleCompositeItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class WeakAndItem
extends NonReducibleCompositeItem {
    public static final int defaultN = 100;
    private int n;
    private String index;
    private int scoreThreshold = 0;

    public WeakAndItem() {
        this(100);
    }

    public WeakAndItem(int N) {
        this("", N);
    }

    public WeakAndItem(String index, int n) {
        this.n = n;
        this.index = index == null ? "" : index;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WEAK_AND;
    }

    @Override
    public String getName() {
        return "WEAKAND";
    }

    @Override
    public void setIndexName(String index) {
        String toSet = index == null ? "" : index;
        super.setIndexName(toSet);
        this.index = toSet;
    }

    public String getIndexName() {
        return this.index;
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.n);
        buffer.append(") ");
    }

    public int getN() {
        return this.n;
    }

    public void setN(int N) {
        this.n = N;
    }

    @Deprecated
    public int getScoreThreshold() {
        return this.scoreThreshold;
    }

    @Deprecated
    public void setScoreThreshold(int scoreThreshold) {
        this.scoreThreshold = scoreThreshold;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.n, (ByteBuffer)buffer);
        WeakAndItem.putString(this.index, buffer);
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("N", this.n);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.n, this.index);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        WeakAndItem other = (WeakAndItem)object;
        if (this.n != other.n) {
            return false;
        }
        return Objects.equals(this.index, other.index);
    }
}

