/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.FalseItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.search.Query;
import com.yahoo.search.query.QueryTree;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;

public class QueryCanonicalizer {
    public static final String queryCanonicalization = "queryCanonicalization";

    public static String canonicalize(Query query) {
        return QueryCanonicalizer.canonicalize(query.getModel().getQueryTree());
    }

    public static String canonicalize(QueryTree query) {
        ListIterator<Item> rootItemIterator = query.getItemIterator();
        CanonicalizationResult result = QueryCanonicalizer.recursivelyCanonicalize(rootItemIterator.next(), rootItemIterator);
        if (query.isEmpty() && !result.isError()) {
            result = CanonicalizationResult.error("No query");
        }
        return result.error().orElse(null);
    }

    private static CanonicalizationResult recursivelyCanonicalize(Item item, ListIterator<Item> parentIterator) {
        if (item instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)item;
            ListIterator<Item> i = composite.getItemIterator();
            while (i.hasNext()) {
                CanonicalizationResult childResult = QueryCanonicalizer.recursivelyCanonicalize(i.next(), i);
                if (!childResult.isError()) continue;
                return childResult;
            }
        }
        return QueryCanonicalizer.canonicalizeThis(item, parentIterator);
    }

    private static CanonicalizationResult canonicalizeThis(Item item, ListIterator<Item> parentIterator) {
        if (item instanceof NullItem) {
            parentIterator.remove();
        }
        if (!(item instanceof CompositeItem)) {
            return CanonicalizationResult.success();
        }
        CompositeItem composite = (CompositeItem)item;
        boolean replacedByFalse = QueryCanonicalizer.collapseFalse(composite, parentIterator);
        if (replacedByFalse) {
            return CanonicalizationResult.success();
        }
        QueryCanonicalizer.collapseLevels(composite);
        if (composite instanceof EquivItem) {
            QueryCanonicalizer.removeDuplicates((EquivItem)composite);
        } else if (composite instanceof RankItem) {
            QueryCanonicalizer.makeDuplicatesCheap((RankItem)composite);
        } else if (composite instanceof NotItem && ((NotItem)composite).getPositiveItem() == null) {
            return CanonicalizationResult.error("Can not search for only negative items");
        }
        if (composite.getItemCount() == 0) {
            parentIterator.remove();
        }
        composite.extractSingleChild().ifPresent(extractedChild -> parentIterator.set((Item)extractedChild));
        return CanonicalizationResult.success();
    }

    private static void collapseLevels(CompositeItem composite) {
        if (composite instanceof RankItem || composite instanceof NotItem) {
            QueryCanonicalizer.collapseLevels(composite, composite.getItemIterator());
        } else if (composite instanceof AndItem || composite instanceof OrItem || composite instanceof WeakAndItem) {
            ListIterator<Item> i = composite.getItemIterator();
            while (i.hasNext()) {
                QueryCanonicalizer.collapseLevels(composite, i);
            }
        }
    }

    private static void collapseLevels(CompositeItem composite, ListIterator<Item> i) {
        if (!i.hasNext()) {
            return;
        }
        Item child = i.next();
        if (child == null) {
            return;
        }
        if (child.getClass() != composite.getClass()) {
            return;
        }
        if (child instanceof WeakAndItem && !QueryCanonicalizer.equalWeakAndSettings((WeakAndItem)child, (WeakAndItem)composite)) {
            return;
        }
        i.remove();
        QueryCanonicalizer.moveChildren((CompositeItem)child, i);
    }

    private static boolean equalWeakAndSettings(WeakAndItem a, WeakAndItem b) {
        if (!a.getIndexName().equals(b.getIndexName())) {
            return false;
        }
        return a.getN() == b.getN();
    }

    private static void moveChildren(CompositeItem from, ListIterator<Item> toIterator) {
        ListIterator<Item> i = from.getItemIterator();
        while (i.hasNext()) {
            toIterator.add(i.next());
        }
    }

    private static boolean collapseFalse(CompositeItem composite, ListIterator<Item> parentIterator) {
        if (!QueryCanonicalizer.containsFalse(composite)) {
            return false;
        }
        if (composite instanceof AndItem) {
            parentIterator.set(new FalseItem());
            return true;
        }
        if (composite instanceof OrItem) {
            QueryCanonicalizer.removeFalseIn(composite.getItemIterator());
            return false;
        }
        if (composite instanceof NotItem || composite instanceof RankItem) {
            ListIterator<Item> i = composite.getItemIterator();
            if (i.next() instanceof FalseItem) {
                parentIterator.set(new FalseItem());
                return true;
            }
            QueryCanonicalizer.removeFalseIn(i);
            return false;
        }
        return false;
    }

    private static boolean containsFalse(CompositeItem composite) {
        ListIterator<Item> i = composite.getItemIterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof FalseItem)) continue;
            return true;
        }
        return false;
    }

    private static void removeFalseIn(ListIterator<Item> iterator) {
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof FalseItem)) continue;
            iterator.remove();
        }
    }

    private static void removeDuplicates(EquivItem composite) {
        int origSize = composite.getItemCount();
        block0: for (int i = origSize - 1; i >= 1; --i) {
            Item deleteCandidate = composite.getItem(i);
            for (int j = 0; j < i; ++j) {
                Item check = composite.getItem(j);
                if (deleteCandidate.getClass() != check.getClass()) continue;
                if (deleteCandidate instanceof PhraseItem) {
                    PhraseItem phraseDeletionCandidate = (PhraseItem)deleteCandidate;
                    PhraseItem phraseToCheck = (PhraseItem)check;
                    if (!phraseDeletionCandidate.getIndexedString().equals(phraseToCheck.getIndexedString())) continue;
                    composite.removeItem(i);
                    continue block0;
                }
                if (deleteCandidate instanceof PhraseSegmentItem) {
                    PhraseSegmentItem phraseSegmentDeletionCandidate = (PhraseSegmentItem)deleteCandidate;
                    PhraseSegmentItem phraseSegmentToCheck = (PhraseSegmentItem)check;
                    if (!phraseSegmentDeletionCandidate.getIndexedString().equals(phraseSegmentToCheck.getIndexedString())) continue;
                    composite.removeItem(i);
                    continue block0;
                }
                if (!(deleteCandidate instanceof BlockItem)) continue;
                BlockItem blockDeletionCandidate = (BlockItem)((Object)deleteCandidate);
                BlockItem blockToCheck = (BlockItem)((Object)check);
                if (!blockDeletionCandidate.stringValue().equals(blockToCheck.stringValue())) continue;
                composite.removeItem(i);
                continue block0;
            }
        }
    }

    private static void makeDuplicatesCheap(RankItem rankItem) {
        HashSet<TermItem> rankTerms = new HashSet<TermItem>();
        for (int i = 1; i < rankItem.getItemCount(); ++i) {
            if (!(rankItem.getItem(i) instanceof TermItem)) continue;
            rankTerms.add((TermItem)rankItem.getItem(i));
        }
        QueryCanonicalizer.makeDuplicatesCheap(rankItem.getItem(0), rankTerms);
    }

    private static void makeDuplicatesCheap(Item item, Set<TermItem> rankTerms) {
        if (item instanceof CompositeItem) {
            ListIterator<Item> i = ((CompositeItem)item).getItemIterator();
            while (i.hasNext()) {
                QueryCanonicalizer.makeDuplicatesCheap(i.next(), rankTerms);
            }
        } else if (rankTerms.contains(item)) {
            item.setRanked(false);
            item.setPositionData(false);
        }
    }

    public static class CanonicalizationResult {
        private final Optional<String> error;

        private CanonicalizationResult(Optional<String> error) {
            this.error = error;
        }

        public Optional<String> error() {
            return this.error;
        }

        public static CanonicalizationResult error(String error) {
            return new CanonicalizationResult(Optional.of(error));
        }

        public static CanonicalizationResult success() {
            return new CanonicalizationResult(Optional.empty());
        }

        public boolean isError() {
            return this.error.isPresent();
        }
    }
}

