/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Preconditions;
import com.yahoo.search.yql.Operator;
import com.yahoo.search.yql.OperatorTypeChecker;
import java.util.List;

final class ArgumentsTypeChecker {
    private final Operator target;
    private final List<OperatorTypeChecker> checkers;

    public ArgumentsTypeChecker(Operator target, List<OperatorTypeChecker> checkers) {
        this.target = target;
        this.checkers = checkers;
    }

    public void check(Object ... args) {
        if (args == null) {
            Preconditions.checkArgument((this.checkers.size() == 0 ? 1 : 0) != 0, (String)"Operator %s argument count mismatch: expected %s got 0", (Object)this.target, (int)this.checkers.size());
            return;
        }
        Preconditions.checkArgument((args.length == this.checkers.size() ? 1 : 0) != 0, (String)"Operator %s argument count mismatch: expected: %s got %s", (Object)this.target, (Object)this.checkers.size(), (Object)args.length);
        for (int i = 0; i < this.checkers.size(); ++i) {
            this.checkers.get(i).check(args[i]);
        }
    }
}

