/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.language.process.Embedder;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.types.ConversionContext;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

public class TensorFieldType
extends FieldType {
    private final TensorType type;

    public TensorFieldType(TensorType type) {
        this.type = type;
    }

    @Override
    public TensorType asTensorType() {
        return this.type;
    }

    @Override
    public Class getValueClass() {
        return Tensor.class;
    }

    @Override
    public String stringValue() {
        return this.type.toString();
    }

    @Override
    public String toString() {
        return "field type " + this.stringValue();
    }

    @Override
    public String toInstanceDescription() {
        return "a tensor";
    }

    @Override
    public Object convertFrom(Object o, QueryProfileRegistry registry) {
        return this.convertFrom(o, ConversionContext.empty());
    }

    @Override
    public Object convertFrom(Object o, ConversionContext context) {
        if (o instanceof Tensor) {
            return o;
        }
        if (o instanceof String && ((String)o).startsWith("embed(")) {
            return this.encode((String)o, context);
        }
        if (o instanceof String) {
            return Tensor.from((TensorType)this.type, (String)((String)o));
        }
        return null;
    }

    private Tensor encode(String s, ConversionContext context) {
        if (!s.endsWith(")")) {
            throw new IllegalArgumentException("Expected any string enclosed in embed(), but the argument does not end by ')'");
        }
        String text = s.substring("embed(".length(), s.length() - 1);
        return context.embedder().embed(text, this.toEmbedderContext(context), this.type);
    }

    private Embedder.Context toEmbedderContext(ConversionContext context) {
        return new Embedder.Context(context.destination()).setLanguage(context.language());
    }

    public static TensorFieldType fromTypeString(String s) {
        return new TensorFieldType(TensorType.fromSpec((String)s));
    }
}

