/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.google.common.annotations.Beta;
import com.yahoo.search.grouping.request.DocumentValue;
import com.yahoo.search.grouping.request.GroupingExpression;

@Beta
public class ArrayAtLookup
extends DocumentValue {
    private final String attributeName;
    private final GroupingExpression indexArgument;

    public ArrayAtLookup(String attributeName, GroupingExpression indexArg) {
        this(null, null, attributeName, indexArg);
    }

    private ArrayAtLookup(String label, Integer level, String attributeName, GroupingExpression indexArgument) {
        super("array.at(" + attributeName + ", " + indexArgument + ")", label, level);
        this.attributeName = attributeName;
        this.indexArgument = indexArgument;
    }

    @Override
    public ArrayAtLookup copy() {
        return new ArrayAtLookup(this.getLabel(), this.getLevelOrNull(), this.getAttributeName(), this.getIndexArgument().copy());
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public GroupingExpression getIndexArgument() {
        return this.indexArgument;
    }
}

