/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.benchmark;

import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.RuleImporter;
import com.yahoo.prelude.semantics.parser.ParseException;
import com.yahoo.search.Query;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

public class RuleBaseBenchmark {
    public void benchmark(String ruleBaseFile, String queryFile, int iterations) throws IOException, ParseException {
        String line;
        File fsa;
        String fsaFile = null;
        if (ruleBaseFile.endsWith(".sr") && !(fsa = new File(fsaFile = ruleBaseFile.substring(0, ruleBaseFile.length() - 3) + ".fsa")).exists()) {
            fsaFile = null;
        }
        RuleBase ruleBase = new RuleImporter().importFile(ruleBaseFile, fsaFile);
        ArrayList<String> queries = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(queryFile));
        while ((line = reader.readLine()) != null) {
            queries.add(line);
        }
        Date start = new Date();
        for (int i = 0; i < iterations; ++i) {
            for (String queryString : queries) {
                Query query = new Query("?query=" + queryString);
                ruleBase.analyze(query, 0);
            }
        }
        Date end = new Date();
        long elapsed = end.getTime() - start.getTime();
        System.out.print("BENCHMARK: rulebase=" + ruleBaseFile + "\n           fsa=" + fsaFile + "\n           queries=" + queryFile + "\n           iterations=" + iterations + "\n           elapsed=" + elapsed + "ms\n");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("USAGE: RuleBaseBenchmark ruleBaseFile queryFile iterations");
            System.exit(1);
        }
        try {
            new RuleBaseBenchmark().benchmark(args[0], args[1], Integer.parseInt(args[2]));
        }
        catch (Exception e) {
            System.out.println("ERROR: " + RuleBaseBenchmark.collectMessage(e));
            System.exit(1);
        }
    }

    private static String collectMessage(Throwable e) {
        if (e.getCause() == null) {
            return RuleBaseBenchmark.messageOrName(e);
        }
        return RuleBaseBenchmark.messageOrName(e) + ": " + RuleBaseBenchmark.collectMessage(e.getCause());
    }

    private static String messageOrName(Throwable e) {
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        return e.getClass().getName();
    }
}

