/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PureWeightedItem;
import java.nio.ByteBuffer;

public class PureWeightedString
extends PureWeightedItem {
    private final String value;

    public PureWeightedString(String value) {
        this(value, 100);
    }

    public PureWeightedString(String value, int weight) {
        super(weight);
        this.value = value;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.PURE_WEIGHTED_STRING;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        PureWeightedString.putString(this.value, buffer);
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append(this.value);
        super.appendBodyString(buffer);
    }

    public String getString() {
        return this.value;
    }
}

