/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public class Location {
    private int dimensions = 0;
    private int x1 = 0;
    private int y1 = 0;
    private int x2 = 1;
    private int y2 = 1;
    private int x = 0;
    private int y = 0;
    private int r = -1;
    private boolean renderCircle = false;
    private boolean renderRectangle = false;
    private long aspect = 0L;
    private String attribute;

    public boolean equals(Object other) {
        if (!(other instanceof Location)) {
            return false;
        }
        Location l = (Location)other;
        return this.dimensions == l.dimensions && this.renderCircle == l.renderCircle && this.renderRectangle == l.renderRectangle && this.aspect == l.aspect && this.x1 == l.x1 && this.x2 == l.x2 && this.y1 == l.y1 && this.y2 == l.y2 && this.x == l.x && this.y == l.y && this.r == l.r;
    }

    public boolean hasDimensions() {
        return this.dimensions != 0;
    }

    public void setDimensions(int d) {
        if (this.hasDimensions() && this.dimensions != d) {
            throw new IllegalArgumentException("already has dimensions=" + this.dimensions + ", cannot change it to " + d);
        }
        if (d != 2) {
            throw new IllegalArgumentException("Illegal location, dimensions must be 2, but was: " + d);
        }
        this.dimensions = d;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setBoundingBox(double n, double s, double e, double w) {
        this.setDimensions(2);
        if (this.hasBoundingBox()) {
            throw new IllegalArgumentException("can only set bounding box once");
        }
        int px1 = (int)Math.round(w * 1000000.0);
        int px2 = (int)Math.round(e * 1000000.0);
        int py1 = (int)Math.round(s * 1000000.0);
        int py2 = (int)Math.round(n * 1000000.0);
        if (px1 > px2) {
            throw new IllegalArgumentException("cannot have w > e");
        }
        this.x1 = px1;
        this.x2 = px2;
        if (py1 > py2) {
            throw new IllegalArgumentException("cannot have s > n");
        }
        this.y1 = py1;
        this.y2 = py2;
        this.renderRectangle = true;
    }

    private void adjustAspect() {
        double degrees = (double)this.y / 1000000.0;
        if (degrees <= -90.0 || degrees >= 90.0) {
            this.aspect = 0L;
            return;
        }
        double radians = degrees * Math.PI / 180.0;
        double cosLatRadians = Math.cos(radians);
        this.aspect = (long)(cosLatRadians * 4.294967295E9);
    }

    public void setGeoCircle(double ns, double ew, double radius_in_degrees) {
        this.setDimensions(2);
        if (this.isGeoCircle()) {
            throw new IllegalArgumentException("can only set geo circle once");
        }
        int px = (int)(ew * 1000000.0);
        int py = (int)(ns * 1000000.0);
        int pr = (int)(radius_in_degrees * 1000000.0);
        if (ew < -180.1 || ew > 180.1) {
            throw new IllegalArgumentException("e/w location must be in range [-180,+180]");
        }
        if (ns < -90.1 || ns > 90.1) {
            throw new IllegalArgumentException("n/s location must be in range [-90,+90]");
        }
        if (radius_in_degrees < 0.0) {
            pr = -1;
        }
        this.x = px;
        this.y = py;
        this.r = pr;
        this.renderCircle = true;
        this.adjustAspect();
    }

    public void setXyCircle(int px, int py, int radius_in_units) {
        this.setDimensions(2);
        if (this.isGeoCircle()) {
            throw new IllegalArgumentException("can only set geo circle once");
        }
        if (radius_in_units < 0) {
            radius_in_units = -1;
        }
        this.x = px;
        this.y = py;
        this.r = radius_in_units;
        this.renderCircle = true;
    }

    private void parseRectangle(String rectangle) {
        int endof = rectangle.indexOf(93);
        if (endof == -1) {
            throw new IllegalArgumentException("Illegal location syntax: " + rectangle);
        }
        String rectPart = rectangle.substring(1, endof);
        StringTokenizer tokens = new StringTokenizer(rectPart, ",");
        this.setDimensions(Integer.parseInt(tokens.nextToken()));
        this.x1 = Integer.parseInt(tokens.nextToken());
        this.y1 = Integer.parseInt(tokens.nextToken());
        this.x2 = Integer.parseInt(tokens.nextToken());
        this.y2 = Integer.parseInt(tokens.nextToken());
        if (tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("Illegal location syntax: " + rectangle);
        }
        this.renderRectangle = true;
        String theRest = rectangle.substring(endof + 1).trim();
        if (theRest.length() >= 15 && theRest.charAt(0) == '(') {
            this.parseCircle(theRest);
        }
    }

    private void parseCircle(String circle) {
        int endof = circle.indexOf(41);
        if (endof == -1) {
            throw new IllegalArgumentException("Illegal location syntax: " + circle);
        }
        String circlePart = circle.substring(1, endof);
        StringTokenizer tokens = new StringTokenizer(circlePart, ",");
        this.setDimensions(Integer.parseInt(tokens.nextToken()));
        this.x = Integer.parseInt(tokens.nextToken());
        this.y = Integer.parseInt(tokens.nextToken());
        this.r = Integer.parseInt(tokens.nextToken());
        Integer.parseInt(tokens.nextToken());
        Integer.parseInt(tokens.nextToken());
        Integer.parseInt(tokens.nextToken());
        if (tokens.hasMoreTokens()) {
            String aspectToken = tokens.nextToken();
            if (aspectToken.equalsIgnoreCase("CalcLatLon")) {
                this.adjustAspect();
            } else {
                try {
                    this.aspect = Long.parseLong(aspectToken);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Aspect " + aspectToken + " for location must be an integer or 'CalcLatLon' for automatic aspect calculation.", nfe);
                }
                if (this.aspect > 0xFFFFFFFFL || this.aspect < 0L) {
                    throw new IllegalArgumentException("Aspect " + this.aspect + " for location parameter must be less than 4294967296 (2^32)");
                }
            }
        }
        this.renderCircle = true;
        String theRest = circle.substring(endof + 1).trim();
        if (theRest.length() > 5 && theRest.charAt(0) == '[') {
            this.parseRectangle(theRest);
        }
    }

    public Location() {
    }

    public Location(String rawLocation) {
        int attributeSepPos = rawLocation.indexOf(58);
        String locationSpec = rawLocation;
        if (attributeSepPos != -1) {
            String tempAttribute = rawLocation.substring(0, attributeSepPos);
            if (tempAttribute != null && !tempAttribute.isEmpty()) {
                this.attribute = tempAttribute;
            }
            locationSpec = rawLocation.substring(attributeSepPos + 1);
        }
        if (locationSpec.charAt(0) == '[') {
            this.parseRectangle(locationSpec);
        } else if (locationSpec.charAt(0) == '(') {
            this.parseCircle(locationSpec);
        } else {
            throw new IllegalArgumentException("Illegal location syntax");
        }
    }

    public String toString() {
        return this.render(false);
    }

    public String backendString() {
        return this.render(true);
    }

    private String render(boolean forBackend) {
        StringBuilder ser = new StringBuilder();
        if (this.attribute != null) {
            ser.append(this.attribute).append(':');
        }
        if (this.renderRectangle) {
            ser.append("[").append(this.dimensions).append(",");
            ser.append(this.x1).append(",").append(this.y1).append(",").append(this.x2).append(",").append(this.y2);
            ser.append("]");
        }
        if (this.renderCircle) {
            ser.append("(").append(this.dimensions).append(",").append(this.x).append(",").append(this.y);
            ser.append(",").append(forBackend ? this.backendRadius() : this.r).append(",").append(0).append(",").append(1).append(",").append(0);
            if (this.aspect != 0L) {
                ser.append(",").append(this.aspect);
            }
            ser.append(")");
        }
        return ser.toString();
    }

    public int getBoundingWidth() {
        if (this.renderCircle) {
            return this.r * 2;
        }
        return this.x2 - this.x1;
    }

    public int getBoundingHeight() {
        if (this.renderCircle) {
            return this.r * 2;
        }
        return this.y2 - this.y1;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean hasAttribute() {
        return this.attribute != null;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attributeName) {
        this.attribute = attributeName;
    }

    public boolean isGeoCircle() {
        return this.renderCircle && this.dimensions == 2;
    }

    public boolean hasBoundingBox() {
        return this.renderRectangle;
    }

    private void checkGeoCircle() {
        if (!this.isGeoCircle()) {
            throw new IllegalArgumentException("only geo circles support this api");
        }
    }

    public double degNS() {
        this.checkGeoCircle();
        return 1.0E-6 * (double)this.y;
    }

    public double degEW() {
        this.checkGeoCircle();
        return 1.0E-6 * (double)this.x;
    }

    public double degRadius() {
        this.checkGeoCircle();
        return this.r < 0 ? -1.0 : 1.0E-6 * (double)this.r;
    }

    private int backendRadius() {
        return this.r < 0 ? -1 : this.r;
    }

    public int encode(ByteBuffer buffer) {
        byte[] loc = Utf8.toBytes((String)this.backendString());
        buffer.put(loc);
        return loc.length;
    }
}

