/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors.tracing;

import com.yahoo.vespa.streamingvisitors.tracing.MonotonicNanoClock;
import com.yahoo.vespa.streamingvisitors.tracing.SamplingStrategy;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class ProbabilisticSampleRate
implements SamplingStrategy {
    private final MonotonicNanoClock nanoClock;
    private final Supplier<Random> randomSupplier;
    private final double desiredSamplesPerSec;
    private final AtomicLong lastSampledAtNanoTime = new AtomicLong(0L);

    public ProbabilisticSampleRate(MonotonicNanoClock nanoClock, Supplier<Random> randomSupplier, double desiredSamplesPerSec) {
        this.nanoClock = nanoClock;
        this.randomSupplier = randomSupplier;
        this.desiredSamplesPerSec = desiredSamplesPerSec;
    }

    public static ProbabilisticSampleRate withSystemDefaults(double desiredSamplesPerSec) {
        return new ProbabilisticSampleRate(System::nanoTime, ThreadLocalRandom::current, desiredSamplesPerSec);
    }

    @Override
    public boolean shouldSample() {
        long lastSampledAt = this.lastSampledAtNanoTime.get();
        long now = this.nanoClock.nanoTimeNow();
        double secsSinceLastSample = (double)(now - lastSampledAt) / 1.0E9;
        double sampleProb = Math.min(secsSinceLastSample * this.desiredSamplesPerSec, 1.0);
        if (this.randomSupplier.get().nextDouble() < sampleProb) {
            this.lastSampledAtNanoTime.set(now);
            return true;
        }
        return false;
    }
}

