/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yahoo.search.yql.CaseInsensitiveFileStream;
import com.yahoo.search.yql.CaseInsensitiveInputStream;
import com.yahoo.search.yql.ExpressionOperator;
import com.yahoo.search.yql.Location;
import com.yahoo.search.yql.OperatorNode;
import com.yahoo.search.yql.ProgramCompileException;
import com.yahoo.search.yql.ProjectionBuilder;
import com.yahoo.search.yql.SequenceOperator;
import com.yahoo.search.yql.SortOperator;
import com.yahoo.search.yql.StatementOperator;
import com.yahoo.search.yql.StringUnescaper;
import com.yahoo.search.yql.yqlplusLexer;
import com.yahoo.search.yql.yqlplusParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

final class ProgramParser {
    ProgramParser() {
    }

    public yqlplusParser prepareParser(String programName, InputStream input) throws IOException {
        return this.prepareParser(programName, (CharStream)new CaseInsensitiveInputStream(input));
    }

    public yqlplusParser prepareParser(String programName, String input) throws IOException {
        return this.prepareParser(programName, (CharStream)new CaseInsensitiveInputStream(input));
    }

    public yqlplusParser prepareParser(File file) throws IOException {
        return this.prepareParser(file.getAbsoluteFile().toString(), (CharStream)new CaseInsensitiveFileStream(file.getAbsolutePath()));
    }

    private yqlplusParser prepareParser(final String programName, CharStream input) {
        yqlplusLexer lexer = new yqlplusLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
                throw new ProgramCompileException(new Location(programName, line, charPositionInLine), "%s", msg);
            }
        });
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        yqlplusParser parser = new yqlplusParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
                throw new ProgramCompileException(new Location(programName, line, charPositionInLine), "%s", msg);
            }
        });
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        return parser;
    }

    private yqlplusParser.ProgramContext parseProgram(yqlplusParser parser) throws RecognitionException {
        try {
            return parser.program();
        }
        catch (RecognitionException e) {
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return parser.program();
        }
    }

    public OperatorNode<StatementOperator> parse(String programName, String program) throws IOException, RecognitionException {
        yqlplusParser parser = this.prepareParser(programName, program);
        return this.convertProgram(this.parseProgram(parser), parser, programName);
    }

    private Location toLocation(Scope scope, ParseTree node) {
        Token start;
        if (node instanceof ParserRuleContext) {
            start = ((ParserRuleContext)node).start;
        } else if (node instanceof TerminalNode) {
            start = ((TerminalNode)node).getSymbol();
        } else {
            throw new ProgramCompileException("Location is not available for type " + node.getClass());
        }
        return new Location(scope != null ? scope.programName : "<string>", start.getLine(), start.getCharPositionInLine());
    }

    private List<String> readName(yqlplusParser.Namespaced_nameContext node) {
        ArrayList path = Lists.newArrayList();
        for (ParseTree elt : node.children) {
            if (ProgramParser.getParseTreeIndex(elt) == 52) continue;
            path.add(elt.getText());
        }
        return path;
    }

    private OperatorNode<SequenceOperator> convertSelect(ParseTree node, Scope scopeParent) {
        ParseTree sourceNode;
        Preconditions.checkArgument((boolean)(node instanceof yqlplusParser.Select_statementContext));
        Scope scope = scopeParent.child();
        ProjectionBuilder proj = null;
        OperatorNode<SequenceOperator> source = null;
        OperatorNode<ExpressionOperator> filter = null;
        List orderby = null;
        OperatorNode<ExpressionOperator> offset = null;
        OperatorNode<ExpressionOperator> limit = null;
        OperatorNode<ExpressionOperator> timeout = null;
        ParseTree parseTree = sourceNode = node.getChild(2) != null ? node.getChild(2).getChild(0) : null;
        if (sourceNode != null) {
            switch (ProgramParser.getParseTreeIndex(sourceNode)) {
                case 17: {
                    Location location = this.toLocation(scope, sourceNode.getChild(2));
                    source = OperatorNode.create(location, SequenceOperator.ALL, new Object[0]);
                    source.putAnnotation("alias", "row");
                    scope.defineDataSource(location, "row");
                    break;
                }
                case 18: {
                    yqlplusParser.Source_listContext multiSourceContext = ((yqlplusParser.Select_source_multiContext)sourceNode).source_list();
                    source = this.readMultiSource(scope, multiSourceContext);
                    source.putAnnotation("alias", "row");
                    scope.defineDataSource(this.toLocation(scope, (ParseTree)multiSourceContext), "row");
                    break;
                }
                case 19: {
                    source = this.convertSource((ParserRuleContext)sourceNode.getChild(1), scope);
                }
            }
        } else {
            source = OperatorNode.create(SequenceOperator.EMPTY, new Object[0]);
        }
        block13: for (int i = 1; i < node.getChildCount(); ++i) {
            ParseTree child = node.getChild(i);
            switch (ProgramParser.getParseTreeIndex(child)) {
                case 13: {
                    if (ProgramParser.getParseTreeIndex(child.getChild(0)) != 14) continue block13;
                    proj = this.readProjection(((yqlplusParser.Project_specContext)child.getChild(0)).field_def(), scope);
                    continue block13;
                }
                case 32: {
                    filter = this.convertExpr((ParseTree)((yqlplusParser.WhereContext)child).expression(), scope);
                    continue block13;
                }
                case 27: {
                    List<yqlplusParser.Orderby_fieldContext> orderFieds = ((yqlplusParser.OrderbyContext)child).orderby_fields().orderby_field();
                    orderby = Lists.newArrayListWithExpectedSize((int)orderFieds.size());
                    for (int j = 0; j < orderFieds.size(); ++j) {
                        orderby.add(this.convertSortKey(orderFieds.get(j), scope));
                    }
                    continue block13;
                }
                case 30: {
                    limit = this.convertExpr((ParseTree)((yqlplusParser.LimitContext)child).fixed_or_parameter(), scope);
                    continue block13;
                }
                case 31: {
                    offset = this.convertExpr((ParseTree)((yqlplusParser.OffsetContext)child).fixed_or_parameter(), scope);
                    continue block13;
                }
                case 15: {
                    timeout = this.convertExpr((ParseTree)((yqlplusParser.TimeoutContext)child).fixed_or_parameter(), scope);
                }
            }
        }
        OperatorNode<SequenceOperator> result = source;
        if (filter != null) {
            result = OperatorNode.create(SequenceOperator.FILTER, result, filter);
        }
        boolean projectBeforeSort = false;
        if (orderby != null) {
            if (proj != null) {
                block15: for (OperatorNode sortKey : orderby) {
                    OperatorNode sortExpression = (OperatorNode)sortKey.getArgument(0);
                    List<OperatorNode<ExpressionOperator>> sortReadFields = this.getReadFieldExpressions(sortExpression);
                    for (OperatorNode<ExpressionOperator> sortReadField : sortReadFields) {
                        String sortKeyField = (String)((Object)sortReadField.getArgument(1));
                        if (!proj.isAlias(sortKeyField)) continue;
                        projectBeforeSort = true;
                        continue block15;
                    }
                }
            }
            result = projectBeforeSort ? OperatorNode.create(SequenceOperator.SORT, proj.make(result), orderby) : OperatorNode.create(SequenceOperator.SORT, result, orderby);
        }
        if (offset != null && limit != null) {
            result = OperatorNode.create(SequenceOperator.SLICE, result, offset, limit);
        } else if (offset != null) {
            result = OperatorNode.create(SequenceOperator.OFFSET, result, offset);
        } else if (limit != null) {
            result = OperatorNode.create(SequenceOperator.LIMIT, result, limit);
        }
        if (proj != null && !projectBeforeSort) {
            result = proj.make(result);
        }
        if (timeout != null) {
            result = OperatorNode.create(SequenceOperator.TIMEOUT, result, timeout);
        }
        return result;
    }

    private OperatorNode<SequenceOperator> readMultiSource(Scope scope, yqlplusParser.Source_listContext multiSource) {
        ArrayList sourceNameList = Lists.newArrayList();
        List<yqlplusParser.Namespaced_nameContext> nameSpaces = multiSource.namespaced_name();
        for (yqlplusParser.Namespaced_nameContext node : nameSpaces) {
            List<String> name = this.readName(node);
            sourceNameList.add(name);
        }
        return OperatorNode.create(this.toLocation(scope, (ParseTree)multiSource), SequenceOperator.MULTISOURCE, sourceNameList);
    }

    private OperatorNode<SequenceOperator> convertPipe(yqlplusParser.Query_statementContext queryStatementContext, List<yqlplusParser.Pipeline_stepContext> nodes, Scope scope) {
        OperatorNode<SequenceOperator> result = this.convertQuery(queryStatementContext.getChild(0), scope.getRoot());
        for (yqlplusParser.Pipeline_stepContext step : nodes) {
            yqlplusParser.ArgumentsContext arguments;
            if (ProgramParser.getParseTreeIndex(step.getChild(0)) == 9) {
                result = OperatorNode.create(SequenceOperator.PIPE, result, ImmutableList.of(), ImmutableList.of(this.convertExpr(step.getChild(0), scope)));
                continue;
            }
            List<String> name = this.readName(step.namespaced_name());
            Object args = ImmutableList.of();
            if (step.getChildCount() > 1 && (arguments = step.arguments()).getChildCount() > 2) {
                List<yqlplusParser.ArgumentContext> argumentContextList = arguments.argument();
                args = Lists.newArrayListWithExpectedSize((int)argumentContextList.size());
                for (yqlplusParser.ArgumentContext argumentContext : argumentContextList) {
                    args.add(this.convertExpr((ParseTree)argumentContext.expression(), scope.getRoot()));
                }
            }
            result = OperatorNode.create(SequenceOperator.PIPE, result, scope.resolvePath(name), args);
        }
        return result;
    }

    private OperatorNode<SequenceOperator> convertQuery(ParseTree node, Scope scope) {
        if (node instanceof yqlplusParser.Select_statementContext) {
            return this.convertSelect(node, scope.getRoot());
        }
        if (node instanceof yqlplusParser.Source_statementContext) {
            yqlplusParser.Source_statementContext sourceStatementContext = (yqlplusParser.Source_statementContext)node;
            return this.convertPipe(sourceStatementContext.query_statement(), sourceStatementContext.pipeline_step(), scope);
        }
        throw new IllegalArgumentException("Unexpected argument type to convertQueryStatement: " + node.toStringTree());
    }

    private String assignAlias(String alias, ParserRuleContext node, Scope scope) {
        if (alias == null) {
            alias = "source";
        }
        if (node instanceof yqlplusParser.Alias_defContext) {
            ParserRuleContext idChild = node;
            if (node.getChildCount() > 1) {
                idChild = node.getChild(1);
            }
            if (scope.isCursor(alias = idChild.getText())) {
                throw new ProgramCompileException(this.toLocation(scope, (ParseTree)idChild), "Source alias '%s' is already used", alias);
            }
            scope.defineDataSource(this.toLocation(scope, (ParseTree)idChild), alias);
            return alias;
        }
        Object candidate = alias;
        int c = 0;
        while (scope.isCursor((String)candidate)) {
            candidate = alias + ++c;
        }
        scope.defineDataSource(null, (String)candidate);
        return alias;
    }

    private OperatorNode<SequenceOperator> convertSource(ParserRuleContext sourceSpecNode, Scope scope) {
        OperatorNode<SequenceOperator> result;
        String alias;
        ParserRuleContext dataSourceNode = sourceSpecNode;
        ParserRuleContext aliasContext = null;
        if (sourceSpecNode instanceof yqlplusParser.Source_specContext) {
            dataSourceNode = (ParserRuleContext)sourceSpecNode.getChild(0);
            if (sourceSpecNode.getChildCount() == 2) {
                aliasContext = (ParserRuleContext)sourceSpecNode.getChild(1);
            }
            dataSourceNode = dataSourceNode.getChild(0) instanceof yqlplusParser.Call_sourceContext || dataSourceNode.getChild(0) instanceof yqlplusParser.Sequence_sourceContext ? (ParserRuleContext)dataSourceNode.getChild(0) : (ParserRuleContext)dataSourceNode.getChild(1);
        }
        switch (ProgramParser.getParseTreeIndex((ParseTree)dataSourceNode)) {
            case 24: {
                List<String> names = this.readName((yqlplusParser.Namespaced_nameContext)dataSourceNode.getChild(yqlplusParser.Namespaced_nameContext.class, 0));
                alias = this.assignAlias(names.get(names.size() - 1), aliasContext, scope);
                Object arguments = ImmutableList.of();
                yqlplusParser.ArgumentsContext argumentsContext = (yqlplusParser.ArgumentsContext)dataSourceNode.getRuleContext(yqlplusParser.ArgumentsContext.class, 0);
                if (argumentsContext != null) {
                    List<yqlplusParser.ArgumentContext> argumentContexts = argumentsContext.argument();
                    arguments = Lists.newArrayListWithExpectedSize((int)argumentContexts.size());
                    for (yqlplusParser.ArgumentContext argumentContext : argumentContexts) {
                        arguments.add(this.convertExpr((ParseTree)argumentContext, scope));
                    }
                }
                if (names.size() == 1 && scope.isVariable(names.get(0))) {
                    String ident = names.get(0);
                    if (arguments.size() > 0) {
                        throw new ProgramCompileException(this.toLocation(scope, (ParseTree)argumentsContext), "Invalid call-with-arguments on local source '%s'", ident);
                    }
                    result = OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), SequenceOperator.EVALUATE, OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), ExpressionOperator.VARREF, ident));
                    break;
                }
                result = OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), SequenceOperator.SCAN, scope.resolvePath(names), arguments);
                break;
            }
            case 25: {
                yqlplusParser.IdentContext identContext = (yqlplusParser.IdentContext)dataSourceNode.getRuleContext(yqlplusParser.IdentContext.class, 0);
                String ident = identContext.getText();
                if (!scope.isVariable(ident)) {
                    throw new ProgramCompileException(this.toLocation(scope, (ParseTree)identContext), "Unknown variable reference '%s'", ident);
                }
                alias = this.assignAlias(ident, aliasContext, scope);
                result = OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), SequenceOperator.EVALUATE, OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), ExpressionOperator.VARREF, ident));
                break;
            }
            case 7: {
                alias = this.assignAlias(null, dataSourceNode, scope);
                result = this.convertQuery((ParseTree)dataSourceNode, scope);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected argument type to convertSource: " + dataSourceNode.getText());
            }
        }
        result.putAnnotation("alias", alias);
        return result;
    }

    private OperatorNode<StatementOperator> convertProgram(ParserRuleContext program, yqlplusParser parser, String programName) {
        Scope scope = new Scope(parser, programName);
        ArrayList stmts = Lists.newArrayList();
        int output = 0;
        for (ParseTree node : program.children) {
            if (!(node instanceof ParserRuleContext)) continue;
            ParserRuleContext ruleContext = (ParserRuleContext)node;
            if (ruleContext.getRuleIndex() != 5) {
                throw new ProgramCompileException("Unknown program element: " + node.getText());
            }
            yqlplusParser.StatementContext statementContext = (yqlplusParser.StatementContext)ruleContext;
            yqlplusParser.Source_statementContext source_statement = statementContext.output_statement().source_statement();
            OperatorNode<SequenceOperator> query = source_statement.getChildCount() == 1 ? this.convertQuery(source_statement.query_statement().getChild(0), scope) : this.convertQuery((ParseTree)source_statement, scope);
            Object variable = "result" + ++output;
            boolean isCountVariable = false;
            ParseTree outputStatement = node.getChild(0);
            Location location = this.toLocation(scope, outputStatement);
            for (int i = 1; i < outputStatement.getChildCount(); ++i) {
                ParseTree child = outputStatement.getChild(i);
                if (ProgramParser.getParseTreeIndex(child) != 10) {
                    throw new ProgramCompileException("Unknown statement attribute: " + child.toStringTree());
                }
                yqlplusParser.Output_specContext outputSpecContext = (yqlplusParser.Output_specContext)child;
                variable = outputSpecContext.ident().getText();
                if (outputSpecContext.COUNT() == null) continue;
                isCountVariable = true;
            }
            scope.defineVariable(location, (String)variable);
            stmts.add(OperatorNode.create(location, StatementOperator.EXECUTE, query, variable));
            stmts.add(OperatorNode.create(location, isCountVariable ? StatementOperator.COUNT : StatementOperator.OUTPUT, variable));
        }
        return OperatorNode.create(StatementOperator.PROGRAM, stmts);
    }

    private OperatorNode<SortOperator> convertSortKey(yqlplusParser.Orderby_fieldContext node, Scope scope) {
        TerminalNode descDef = node.DESC();
        OperatorNode<ExpressionOperator> exprNode = this.convertExpr((ParseTree)node.expression(), scope);
        if (descDef != null) {
            return OperatorNode.create(this.toLocation(scope, (ParseTree)descDef), SortOperator.DESC, exprNode);
        }
        return OperatorNode.create(this.toLocation(scope, (ParseTree)node), SortOperator.ASC, exprNode);
    }

    private ProjectionBuilder readProjection(List<yqlplusParser.Field_defContext> fieldDefs, Scope scope) {
        if (null == fieldDefs) {
            throw new ProgramCompileException("Null fieldDefs");
        }
        ProjectionBuilder proj = new ProjectionBuilder();
        for (yqlplusParser.Field_defContext rulenode : fieldDefs) {
            OperatorNode<ExpressionOperator> expr = this.convertExpr(rulenode.getChild(0), scope);
            String aliasName = null;
            if (rulenode.getChildCount() > 1) {
                aliasName = rulenode.alias_def().ID().getText();
            }
            proj.addField(aliasName, expr);
        }
        return proj;
    }

    public static int getParseTreeIndex(ParseTree parseTree) {
        if (parseTree instanceof TerminalNode) {
            return ((TerminalNode)parseTree).getSymbol().getType();
        }
        return ((RuleNode)parseTree).getRuleContext().getRuleIndex();
    }

    public OperatorNode<ExpressionOperator> convertExpr(ParseTree parseTree, Scope scope) {
        switch (ProgramParser.getParseTreeIndex(parseTree)) {
            case 9: {
                ParseTree firstChild = parseTree.getChild(0);
                if (ProgramParser.getParseTreeIndex(firstChild) == 41) {
                    ParseTree secondChild = parseTree.getChild(1);
                    OperatorNode<ExpressionOperator> annotation = this.convertExpr((ParseTree)((yqlplusParser.AnnotationContext)firstChild).constantMapExpression(), scope);
                    OperatorNode<ExpressionOperator> expr = OperatorNode.create(this.toLocation(scope, secondChild), ExpressionOperator.VESPA_GROUPING, secondChild.getText());
                    List names = (List)((Object)annotation.getArgument(0));
                    List annotates = (List)((Object)annotation.getArgument(1));
                    for (int i = 0; i < names.size(); ++i) {
                        expr.putAnnotation((String)names.get(i), this.readConstantExpression((OperatorNode)annotates.get(i)));
                    }
                    return expr;
                }
                return OperatorNode.create(this.toLocation(scope, firstChild), ExpressionOperator.VESPA_GROUPING, firstChild.getText());
            }
            case 39: {
                return OperatorNode.create(ExpressionOperator.NULL, new Object[0]);
            }
            case 37: {
                return this.convertExpr(parseTree.getChild(0), scope);
            }
            case 73: {
                ParseTree firstChild = parseTree.getChild(0);
                if (ProgramParser.getParseTreeIndex(firstChild) == 60) {
                    return OperatorNode.create(this.toLocation(scope, firstChild), ExpressionOperator.LITERAL, Integer.valueOf(firstChild.getText()));
                }
                return this.convertExpr(firstChild, scope);
            }
            case 35: {
                List<yqlplusParser.ConstantPropertyNameAndValueContext> propertyList = ((yqlplusParser.ConstantMapExpressionContext)parseTree).constantPropertyNameAndValue();
                ArrayList names = Lists.newArrayListWithExpectedSize((int)propertyList.size());
                ArrayList exprs = Lists.newArrayListWithExpectedSize((int)propertyList.size());
                for (yqlplusParser.ConstantPropertyNameAndValueContext child : propertyList) {
                    names.add(StringUnescaper.unquote(child.getChild(0).getText()));
                    exprs.add(this.convertExpr(child.getChild(2), scope));
                }
                return OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.MAP, names, exprs);
            }
            case 34: {
                List<yqlplusParser.PropertyNameAndValueContext> propertyList = ((yqlplusParser.MapExpressionContext)parseTree).propertyNameAndValue();
                ArrayList names = Lists.newArrayListWithExpectedSize((int)propertyList.size());
                ArrayList exprs = Lists.newArrayListWithCapacity((int)propertyList.size());
                for (yqlplusParser.PropertyNameAndValueContext child : propertyList) {
                    names.add(StringUnescaper.unquote(child.getChild(0).getText()));
                    exprs.add(this.convertExpr(child.getChild(2), scope));
                }
                return OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.MAP, names, exprs);
            }
            case 67: {
                List<yqlplusParser.ConstantExpressionContext> expressionList = ((yqlplusParser.ConstantArrayContext)parseTree).constantExpression();
                ArrayList values = Lists.newArrayListWithExpectedSize((int)expressionList.size());
                for (yqlplusParser.ConstantExpressionContext expr : expressionList) {
                    values.add(this.convertExpr((ParseTree)expr, scope));
                }
                return OperatorNode.create(this.toLocation(scope, expressionList.isEmpty() ? parseTree : (ParseTree)expressionList.get(0)), ExpressionOperator.ARRAY, values);
            }
            case 61: {
                List<yqlplusParser.ExpressionContext> expressionList = ((yqlplusParser.ArrayLiteralContext)parseTree).expression();
                ArrayList values = Lists.newArrayListWithExpectedSize((int)expressionList.size());
                for (yqlplusParser.ExpressionContext expr : expressionList) {
                    values.add(this.convertExpr((ParseTree)expr, scope));
                }
                return OperatorNode.create(this.toLocation(scope, expressionList.isEmpty() ? parseTree : (ParseTree)expressionList.get(0)), ExpressionOperator.ARRAY, values);
            }
            case 55: {
                yqlplusParser.DereferencedExpressionContext dereferencedExpression = (yqlplusParser.DereferencedExpressionContext)parseTree;
                Iterator it = dereferencedExpression.children.iterator();
                OperatorNode<ExpressionOperator> result = this.convertExpr((ParseTree)it.next(), scope);
                while (it.hasNext()) {
                    ParseTree defTree = (ParseTree)it.next();
                    if (ProgramParser.getParseTreeIndex(defTree) == 57) {
                        result = OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.PROPREF, result, defTree.getChild(1).getText());
                        continue;
                    }
                    result = OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.INDEX, result, this.convertExpr(defTree.getChild(1), scope));
                }
                return result;
            }
            case 58: {
                ParseTree firstChild = parseTree.getChild(0);
                switch (ProgramParser.getParseTreeIndex(firstChild)) {
                    case 60: {
                        return this.convertExpr(firstChild, scope);
                    }
                    case 59: {
                        List<yqlplusParser.ArgumentContext> args = ((yqlplusParser.ArgumentsContext)firstChild.getChild(1)).argument();
                        ArrayList arguments = Lists.newArrayListWithExpectedSize((int)args.size());
                        for (yqlplusParser.ArgumentContext argContext : args) {
                            arguments.add(this.convertExpr((ParseTree)argContext.expression(), scope));
                        }
                        return OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.CALL, scope.resolvePath(this.readName((yqlplusParser.Namespaced_nameContext)firstChild.getChild(0))), arguments);
                    }
                    case 62: {
                        return OperatorNode.create(this.toLocation(scope, firstChild), ExpressionOperator.VARREF, firstChild.getChild(1).getText());
                    }
                    case 34: 
                    case 61: 
                    case 68: {
                        return this.convertExpr(firstChild, scope);
                    }
                    case 25: {
                        return this.convertExpr(parseTree.getChild(1), scope);
                    }
                }
                break;
            }
            case 62: {
                ParserRuleContext parameterContext = (ParserRuleContext)parseTree;
                yqlplusParser.IdentContext identContext = (yqlplusParser.IdentContext)parameterContext.getRuleContext(yqlplusParser.IdentContext.class, 0);
                return OperatorNode.create(this.toLocation(scope, (ParseTree)identContext), ExpressionOperator.VARREF, identContext.getText());
            }
            case 40: {
                yqlplusParser.AnnotationContext annotateExpressionContext = ((yqlplusParser.AnnotateExpressionContext)parseTree).annotation();
                OperatorNode<ExpressionOperator> annotation = this.convertExpr((ParseTree)annotateExpressionContext.constantMapExpression(), scope);
                OperatorNode<ExpressionOperator> expr = this.convertExpr(parseTree.getChild(1), scope);
                List names = (List)((Object)annotation.getArgument(0));
                List annotates = (List)((Object)annotation.getArgument(1));
                for (int i = 0; i < names.size(); ++i) {
                    expr.putAnnotation((String)names.get(i), this.readConstantExpression((OperatorNode)annotates.get(i)));
                }
                return expr;
            }
            case 38: {
                return this.convertExpr(parseTree.getChild(0), scope);
            }
            case 43: {
                yqlplusParser.LogicalANDExpressionContext andExpressionContext = (yqlplusParser.LogicalANDExpressionContext)parseTree;
                return this.readConjOp(ExpressionOperator.AND, andExpressionContext.equalityExpression(), scope);
            }
            case 42: {
                int childCount = parseTree.getChildCount();
                yqlplusParser.LogicalORExpressionContext logicalORExpressionContext = (yqlplusParser.LogicalORExpressionContext)parseTree;
                if (childCount > 1) {
                    return this.readConjOrOp(ExpressionOperator.OR, logicalORExpressionContext, scope);
                }
                List<yqlplusParser.EqualityExpressionContext> equalityExpressionList = ((yqlplusParser.LogicalANDExpressionContext)parseTree.getChild(0)).equalityExpression();
                if (equalityExpressionList.size() > 1) {
                    return this.readConjOp(ExpressionOperator.AND, equalityExpressionList, scope);
                }
                return this.convertExpr((ParseTree)equalityExpressionList.get(0), scope);
            }
            case 44: {
                yqlplusParser.EqualityExpressionContext equalityExpression = (yqlplusParser.EqualityExpressionContext)parseTree;
                yqlplusParser.RelationalExpressionContext relationalExpressionContext = equalityExpression.relationalExpression(0);
                OperatorNode<ExpressionOperator> expr = this.convertExpr((ParseTree)relationalExpressionContext, scope);
                yqlplusParser.InNotInTargetContext inNotInTarget = equalityExpression.inNotInTarget();
                int childCount = equalityExpression.getChildCount();
                if (childCount == 1) {
                    return expr;
                }
                if (inNotInTarget != null) {
                    boolean isIN;
                    yqlplusParser.Literal_listContext literalListContext = inNotInTarget.literal_list();
                    boolean bl = isIN = equalityExpression.IN() != null;
                    if (literalListContext == null) {
                        yqlplusParser.Select_statementContext selectStatementContext = inNotInTarget.select_statement();
                        OperatorNode<SequenceOperator> query = this.convertQuery((ParseTree)selectStatementContext, scope);
                        return OperatorNode.create(expr.getLocation(), isIN ? ExpressionOperator.IN_QUERY : ExpressionOperator.NOT_IN_QUERY, expr, query);
                    }
                    return this.readBinOp(isIN ? ExpressionOperator.IN : ExpressionOperator.NOT_IN, equalityExpression.getChild(0), (ParseTree)literalListContext, scope);
                }
                ParseTree firstChild = equalityExpression.getChild(1);
                if (equalityExpression.getChildCount() == 2) {
                    switch (ProgramParser.getParseTreeIndex(firstChild)) {
                        case 50: {
                            return this.readUnOp(ExpressionOperator.IS_NULL, (ParseTree)relationalExpressionContext, scope);
                        }
                        case 51: {
                            return this.readUnOp(ExpressionOperator.IS_NOT_NULL, (ParseTree)relationalExpressionContext, scope);
                        }
                    }
                    break;
                }
                switch (ProgramParser.getParseTreeIndex(firstChild.getChild(0))) {
                    case 44: {
                        return this.readBinOp(ExpressionOperator.EQ, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 42: {
                        return this.readBinOp(ExpressionOperator.NEQ, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 45: {
                        return this.readBinOp(ExpressionOperator.LIKE, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 47: {
                        return this.readBinOp(ExpressionOperator.NOT_LIKE, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 48: {
                        return this.readBinOp(ExpressionOperator.MATCHES, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 49: {
                        return this.readBinOp(ExpressionOperator.NOT_MATCHES, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 46: {
                        return this.readBinOp(ExpressionOperator.CONTAINS, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                }
                break;
            }
            case 47: {
                yqlplusParser.RelationalExpressionContext relationalExpressionContext = (yqlplusParser.RelationalExpressionContext)parseTree;
                yqlplusParser.RelationalOpContext opContext = relationalExpressionContext.relationalOp();
                if (opContext != null) {
                    switch (ProgramParser.getParseTreeIndex(relationalExpressionContext.relationalOp().getChild(0))) {
                        case 38: {
                            return this.readBinOp(ExpressionOperator.LT, parseTree, scope);
                        }
                        case 40: {
                            return this.readBinOp(ExpressionOperator.LTEQ, parseTree, scope);
                        }
                        case 39: {
                            return this.readBinOp(ExpressionOperator.GT, parseTree, scope);
                        }
                        case 41: {
                            return this.readBinOp(ExpressionOperator.GTEQ, parseTree, scope);
                        }
                    }
                    break;
                }
                return this.convertExpr((ParseTree)relationalExpressionContext.additiveExpression(0), scope);
            }
            case 49: 
            case 51: {
                if (parseTree.getChildCount() > 1) {
                    String opStr;
                    switch (opStr = parseTree.getChild(1).getText()) {
                        case "+": {
                            return this.readBinOp(ExpressionOperator.ADD, parseTree, scope);
                        }
                        case "-": {
                            return this.readBinOp(ExpressionOperator.SUB, parseTree, scope);
                        }
                        case "/": {
                            return this.readBinOp(ExpressionOperator.DIV, parseTree, scope);
                        }
                        case "*": {
                            return this.readBinOp(ExpressionOperator.MULT, parseTree, scope);
                        }
                        case "%": {
                            return this.readBinOp(ExpressionOperator.MOD, parseTree, scope);
                        }
                    }
                    if (parseTree.getChild(0) instanceof yqlplusParser.UnaryExpressionContext) {
                        return this.convertExpr(parseTree.getChild(0), scope);
                    }
                    throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown expression type: " + parseTree.toStringTree(), new Object[0]);
                }
                if (parseTree.getChild(0) instanceof yqlplusParser.UnaryExpressionContext) {
                    return this.convertExpr(parseTree.getChild(0), scope);
                }
                if (parseTree.getChild(0) instanceof yqlplusParser.MultiplicativeExpressionContext) {
                    return this.convertExpr(parseTree.getChild(0), scope);
                }
                throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown expression type: " + parseTree.getText(), new Object[0]);
            }
            case 54: {
                if (1 == parseTree.getChildCount()) {
                    return this.convertExpr(parseTree.getChild(0), scope);
                }
                if (2 == parseTree.getChildCount()) {
                    if ("-".equals(parseTree.getChild(0).getText())) {
                        return this.readUnOp(ExpressionOperator.NEGATE, parseTree, scope);
                    }
                    if ("!".equals(parseTree.getChild(0).getText())) {
                        return this.readUnOp(ExpressionOperator.NOT, parseTree, scope);
                    }
                    throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown unary operator " + parseTree.getText(), new Object[0]);
                }
                throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown child count " + parseTree.getChildCount() + " of " + parseTree.getText(), new Object[0]);
            }
            case 60: {
                List<String> path = this.readName((yqlplusParser.Namespaced_nameContext)parseTree.getChild(0));
                Location loc = this.toLocation(scope, parseTree.getChild(0));
                String alias = path.get(0);
                OperatorNode<ExpressionOperator> result = null;
                int start = 0;
                if (scope.isCursor(alias)) {
                    if (path.size() > 1) {
                        result = OperatorNode.create(loc, ExpressionOperator.READ_FIELD, alias, path.get(1));
                        start = 2;
                    } else {
                        result = OperatorNode.create(loc, ExpressionOperator.READ_RECORD, alias);
                        start = 1;
                    }
                } else {
                    if (scope.isBound(alias)) {
                        return OperatorNode.create(loc, ExpressionOperator.READ_MODULE, scope.getBinding(alias).toPathWith(path.subList(1, path.size())));
                    }
                    if (scope.getCursors().size() == 1) {
                        alias = scope.getCursors().iterator().next();
                        result = OperatorNode.create(loc, ExpressionOperator.READ_FIELD, alias, path.get(0));
                        start = 1;
                    } else {
                        throw new ProgramCompileException(loc, "Unknown field or alias '%s'", alias);
                    }
                }
                for (int idx = start; idx < path.size(); ++idx) {
                    result = OperatorNode.create(loc, ExpressionOperator.PROPREF, result, path.get(idx));
                }
                return result;
            }
            case 68: {
                return OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.LITERAL, this.convertLiteral((yqlplusParser.Scalar_literalContext)parseTree));
            }
            case 66: {
                return this.convertExpr(parseTree.getChild(0), scope);
            }
            case 71: {
                if (ProgramParser.getParseTreeIndex(parseTree.getChild(1)) == 70) {
                    return this.convertExpr(parseTree.getChild(1), scope);
                }
                List<yqlplusParser.Literal_elementContext> elements = ((yqlplusParser.Literal_listContext)parseTree).literal_element();
                ParseTree firldElement = elements.get(0).getChild(0);
                if (elements.size() == 1 && scope.getParser().isArrayParameter(firldElement)) {
                    return this.convertExpr(firldElement, scope);
                }
                ArrayList values = Lists.newArrayListWithExpectedSize((int)elements.size());
                for (yqlplusParser.Literal_elementContext child : elements) {
                    values.add(this.convertExpr(child.getChild(0), scope));
                }
                return OperatorNode.create(this.toLocation(scope, (ParseTree)elements.get(0)), ExpressionOperator.ARRAY, values);
            }
        }
        throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown expression type: " + parseTree.getText(), new Object[0]);
    }

    public Object convertLiteral(yqlplusParser.Scalar_literalContext literal) {
        int parseTreeIndex = ProgramParser.getParseTreeIndex(literal.getChild(0));
        String text = literal.getChild(0).getText();
        switch (parseTreeIndex) {
            case 60: {
                return Integer.valueOf(text);
            }
            case 61: {
                return Double.valueOf(text);
            }
            case 62: {
                return StringUnescaper.unquote(text);
            }
            case 23: {
                return true;
            }
            case 24: {
                return false;
            }
            case 59: {
                return Long.parseLong(text.substring(0, text.length() - 1));
            }
        }
        throw new ProgramCompileException("Unknow literal type " + text);
    }

    private Object readConstantExpression(OperatorNode<ExpressionOperator> node) {
        switch (node.getOperator()) {
            case LITERAL: {
                return node.getArgument(0);
            }
            case MAP: {
                ImmutableMap.Builder map = ImmutableMap.builder();
                List names = (List)((Object)node.getArgument(0));
                List exprs = (List)((Object)node.getArgument(1));
                for (int i = 0; i < names.size(); ++i) {
                    map.put((Object)((String)names.get(i)), this.readConstantExpression((OperatorNode)exprs.get(i)));
                }
                return map.build();
            }
            case ARRAY: {
                List exprs = (List)((Object)node.getArgument(0));
                ImmutableList.Builder lst = ImmutableList.builder();
                for (OperatorNode expr : exprs) {
                    lst.add(this.readConstantExpression(expr));
                }
                return lst.build();
            }
            case VARREF: {
                return node;
            }
        }
        throw new ProgramCompileException(node.getLocation(), "Internal error: Unknown constant expression type: " + node.getOperator(), new Object[0]);
    }

    private OperatorNode<ExpressionOperator> readBinOp(ExpressionOperator op, ParseTree node, Scope scope) {
        assert (node.getChildCount() == 3);
        return OperatorNode.create(op, this.convertExpr(node.getChild(0), scope), this.convertExpr(node.getChild(2), scope));
    }

    private OperatorNode<ExpressionOperator> readBinOp(ExpressionOperator op, ParseTree operand1, ParseTree operand2, Scope scope) {
        return OperatorNode.create(op, this.convertExpr(operand1, scope), this.convertExpr(operand2, scope));
    }

    private OperatorNode<ExpressionOperator> readConjOp(ExpressionOperator op, List<yqlplusParser.EqualityExpressionContext> nodes, Scope scope) {
        ArrayList arguments = Lists.newArrayListWithExpectedSize((int)nodes.size());
        for (ParseTree parseTree : nodes) {
            arguments.add(this.convertExpr(parseTree, scope));
        }
        return OperatorNode.create(op, arguments);
    }

    private OperatorNode<ExpressionOperator> readConjOrOp(ExpressionOperator op, yqlplusParser.LogicalORExpressionContext node, Scope scope) {
        List<yqlplusParser.LogicalANDExpressionContext> andExpressionList = node.logicalANDExpression();
        ArrayList arguments = Lists.newArrayListWithExpectedSize((int)andExpressionList.size());
        for (yqlplusParser.LogicalANDExpressionContext child : andExpressionList) {
            List<yqlplusParser.EqualityExpressionContext> equalities = child.equalityExpression();
            if (equalities.size() == 1) {
                arguments.add(this.convertExpr((ParseTree)equalities.get(0), scope));
                continue;
            }
            ArrayList andArguments = Lists.newArrayListWithExpectedSize((int)equalities.size());
            for (yqlplusParser.EqualityExpressionContext subTreeChild : equalities) {
                andArguments.add(this.convertExpr((ParseTree)subTreeChild, scope));
            }
            arguments.add(OperatorNode.create(ExpressionOperator.AND, andArguments));
        }
        return OperatorNode.create(op, arguments);
    }

    private OperatorNode<ExpressionOperator> readUnOp(ExpressionOperator op, ParseTree node, Scope scope) {
        assert (node instanceof TerminalNode || node.getChildCount() == 1 || node instanceof yqlplusParser.UnaryExpressionContext);
        if (node instanceof TerminalNode) {
            return OperatorNode.create(op, this.convertExpr(node, scope));
        }
        if (node.getChildCount() == 1) {
            return OperatorNode.create(op, this.convertExpr(node.getChild(0), scope));
        }
        return OperatorNode.create(op, this.convertExpr(node.getChild(1), scope));
    }

    private List<OperatorNode<ExpressionOperator>> getReadFieldExpressions(OperatorNode<ExpressionOperator> in) {
        ArrayList readFieldList = Lists.newArrayList();
        switch (in.getOperator()) {
            case READ_FIELD: {
                readFieldList.add(in);
                break;
            }
            case CALL: {
                List callArgs = (List)((Object)in.getArgument(1));
                for (OperatorNode callArg : callArgs) {
                    if (callArg.getOperator() != ExpressionOperator.READ_FIELD) continue;
                    readFieldList.add(callArg);
                }
                break;
            }
        }
        return readFieldList;
    }

    static class Scope {
        final Scope root;
        final Scope parent;
        Set<String> cursors = ImmutableSet.of();
        Set<String> variables = ImmutableSet.of();
        Set<String> views = Sets.newHashSet();
        Map<String, Binding> bindings = Maps.newHashMap();
        final yqlplusParser parser;
        final String programName;

        Scope(yqlplusParser parser, String programName) {
            this.parser = parser;
            this.programName = programName;
            this.root = this;
            this.parent = null;
        }

        Scope(Scope root, Scope parent) {
            this.root = root;
            this.parent = parent;
            this.parser = parent.parser;
            this.programName = parent.programName;
        }

        public yqlplusParser getParser() {
            return this.parser;
        }

        public Set<String> getCursors() {
            return this.cursors;
        }

        boolean isBound(String name) {
            return this.root.bindings.containsKey(name);
        }

        public Binding getBinding(String name) {
            return this.root.bindings.get(name);
        }

        public List<String> resolvePath(List<String> path) {
            if (path.size() < 1 || !this.isBound(path.get(0))) {
                return path;
            }
            return this.getBinding(path.get(0)).toPathWith(path.subList(1, path.size()));
        }

        boolean isCursor(String name) {
            return this.cursors.contains(name) || this.parent != null && this.parent.isCursor(name);
        }

        boolean isVariable(String name) {
            return this.variables.contains(name) || this.parent != null && this.parent.isVariable(name);
        }

        public void bindModule(Location loc, List<String> binding, String symbolName) {
            if (this.isBound(symbolName)) {
                throw new ProgramCompileException(loc, "Name '%s' is already used.", symbolName);
            }
            this.root.bindings.put(symbolName, new Binding(binding));
        }

        public void defineDataSource(Location loc, String name) {
            if (this.isCursor(name)) {
                throw new ProgramCompileException(loc, "Alias '%s' is already used.", name);
            }
            if (this.cursors.isEmpty()) {
                this.cursors = Sets.newHashSet();
            }
            this.cursors.add(name);
        }

        public void defineVariable(Location loc, String name) {
            if (this.isVariable(name)) {
                throw new ProgramCompileException(loc, "Variable/argument '%s' is already used.", name);
            }
            if (this.variables.isEmpty()) {
                this.variables = Sets.newHashSet();
            }
            this.variables.add(name);
        }

        public void defineView(Location loc, String text) {
            if (this != this.root) {
                throw new IllegalStateException("Views MUST be defined in 'root' scope only");
            }
            if (this.views.contains(text)) {
                throw new ProgramCompileException(loc, "View '%s' already defined", text);
            }
            this.views.add(text);
        }

        Scope child() {
            return new Scope(this.root, this);
        }

        Scope getRoot() {
            return this.root;
        }
    }

    static class Binding {
        private final List<String> binding;

        Binding(List<String> binding) {
            this.binding = binding;
        }

        public List<String> toPath() {
            return this.binding;
        }

        public List<String> toPathWith(List<String> rest) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(this.toPath(), rest));
        }
    }
}

