/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.rewrite;

import com.yahoo.fsa.FSA;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.search.Query;
import com.yahoo.search.intent.model.IntentModel;
import com.yahoo.search.intent.model.InterpretationNode;
import com.yahoo.search.query.rewrite.RewriterConstants;
import com.yahoo.text.interpretation.Annotations;
import com.yahoo.text.interpretation.Modification;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RewriterUtils {
    private static final Logger utilsLogger = Logger.getLogger(RewriterUtils.class.getName());
    private static final int TRACELEVEL = 3;

    public static FSA loadFSA(File file, Query query) throws IOException {
        RewriterUtils.log(utilsLogger, query, "Loading FSA file");
        String filePath = null;
        try {
            filePath = file.getAbsolutePath();
        }
        catch (SecurityException e1) {
            RewriterUtils.error(utilsLogger, query, "No read access for the FSA file");
            throw new IOException("No read access for the FSA file");
        }
        FSA fsa = RewriterUtils.loadFSA(filePath, query);
        return fsa;
    }

    public static FSA loadFSA(String filename, Query query) throws IOException {
        FSA fsa;
        RewriterUtils.log(utilsLogger, query, "Loading FSA file from: " + filename);
        if (!new File(filename).exists()) {
            RewriterUtils.error(utilsLogger, query, "File does not exist : " + filename);
            throw new IOException("File does not exist : " + filename);
        }
        try {
            fsa = new FSA(filename);
        }
        catch (RuntimeException e) {
            RewriterUtils.error(utilsLogger, query, "Invalid FSA file");
            throw new IOException("Invalid FSA file");
        }
        if (!fsa.isOk()) {
            RewriterUtils.error(utilsLogger, query, "Unable to load FSA file from : " + filename);
            throw new IOException("Not able to load FSA file from : " + filename);
        }
        RewriterUtils.log(utilsLogger, query, "Loaded FSA successfully from file : " + filename);
        return fsa;
    }

    public static String getRewriteFromFSA(Query query, HashMap<String, Object> rewriterDicts, String dictName, String key) throws RuntimeException {
        if (rewriterDicts == null) {
            RewriterUtils.error(utilsLogger, query, "HashMap containing rewriter dicts is null");
            throw new RuntimeException("HashMap containing rewriter dicts is null");
        }
        FSA fsa = (FSA)rewriterDicts.get(dictName);
        if (fsa == null) {
            RewriterUtils.error(utilsLogger, query, "Error retrieving FSA dictionary: " + dictName);
            throw new RuntimeException("Error retrieving FSA dictionary: " + dictName);
        }
        String result = null;
        result = fsa.lookup(key);
        RewriterUtils.log(utilsLogger, query, "Retrieved rewrite: " + result);
        return result;
    }

    public static String getQPConfig(Query query, String rewriterName, String paramName) {
        RewriterUtils.log(utilsLogger, query, "Retrieving config parameter value of: " + rewriterName + "." + paramName);
        return RewriterUtils.getUserParam(query, rewriterName + "." + paramName);
    }

    public static String getRewriterChain(Query query) {
        RewriterUtils.log(utilsLogger, query, "Retrieving rewriter chain value: QRWChain");
        return RewriterUtils.getUserParam(query, "QRWChain");
    }

    public static String getUserParam(Query query, String paramName) {
        RewriterUtils.log(utilsLogger, query, "Retrieving user param value: " + paramName);
        if (paramName == null) {
            RewriterUtils.error(utilsLogger, query, "Parameter name is null");
            return null;
        }
        String paramValue = null;
        paramValue = query.properties().getString(paramName);
        RewriterUtils.log(utilsLogger, query, "Param value retrieved is: " + paramValue);
        return paramValue;
    }

    public static HashMap<String, Object> getRewriteMeta(Query query) {
        RewriterUtils.log(utilsLogger, query, "Retrieving metadata passed by previous rewriter");
        HashMap<String, Object> rewriteMeta = (HashMap<String, Object>)query.properties().get(RewriterConstants.REWRITE_META);
        if (rewriteMeta == null) {
            RewriterUtils.log(utilsLogger, query, "No metadata available from previous rewriter");
            rewriteMeta = new HashMap<String, Object>();
            rewriteMeta.put("Rewritten", false);
            rewriteMeta.put("DictKey", RewriterUtils.getNormalizedOriginalQuery(query));
        } else {
            if (((Boolean)rewriteMeta.get("Rewritten")).booleanValue()) {
                RewriterUtils.log(utilsLogger, query, "Query has been rewritten by previous rewriters");
            } else {
                RewriterUtils.log(utilsLogger, query, "Query has not been rewritten by previous rewriters");
            }
            RewriterUtils.log(utilsLogger, query, "Dict key passed by previous rewriter: " + rewriteMeta.get("DictKey"));
        }
        return rewriteMeta;
    }

    public static void setRewriteMeta(Query query, HashMap<String, Object> metadata) {
        RewriterUtils.log(utilsLogger, query, "Passing metadata to the next rewriter");
        query.properties().set(RewriterConstants.REWRITE_META, metadata);
        RewriterUtils.log(utilsLogger, query, "Successfully passed metadata to the next rewriter");
    }

    public static String getSpellCorrected(Query query, boolean qss_rw, boolean qss_sugg) throws RuntimeException {
        RewriterUtils.log(utilsLogger, query, "Retrieving spell corrected query");
        IntentModel intentModel = IntentModel.getFrom(query);
        if (intentModel == null) {
            RewriterUtils.error(utilsLogger, query, "Unable to retrieve intent model");
            throw new RuntimeException("Not able to retrieve intent model");
        }
        double max_score = 0.0;
        String spellCorrected = null;
        for (InterpretationNode interpretationNode : intentModel.children()) {
            Modification modification = interpretationNode.getInterpretation().getModification();
            Annotations annotations = modification.getAnnotation();
            Double score = annotations.getDouble("score");
            if (score == null || !(score > max_score)) continue;
            Boolean isQSSRewrite = annotations.getBoolean("qss_rw");
            Boolean isQSSSuggest = annotations.getBoolean("qss_sugg");
            if ((!qss_rw || isQSSRewrite == null || !isQSSRewrite.booleanValue()) && (!qss_sugg || isQSSSuggest == null || !isQSSSuggest.booleanValue())) continue;
            max_score = score;
            spellCorrected = modification.getText();
        }
        if (spellCorrected != null) {
            RewriterUtils.log(utilsLogger, query, "Successfully retrieved spell corrected query: " + spellCorrected);
        } else {
            RewriterUtils.log(utilsLogger, query, "No spell corrected query is retrieved");
        }
        return spellCorrected;
    }

    public static String getNormalizedOriginalQuery(Query query) {
        return LinguisticsCase.toLowerCase((String)query.getModel().getQueryString()).trim();
    }

    public static void log(Logger logger, String msg) {
        logger.log(Level.FINE, () -> logger.getName() + ": " + msg);
    }

    public static void log(Logger logger, Query query, String msg) {
        if (query != null) {
            query.trace(logger.getName() + ": " + msg, true, 3);
        }
        logger.log(Level.FINE, () -> logger.getName() + ": " + msg);
    }

    public static void error(Logger logger, String msg) {
        logger.severe(logger.getName() + ": " + msg);
    }

    public static void error(Logger logger, Query query, String msg) {
        if (query != null) {
            query.trace(logger.getName() + ": " + msg, true, 3);
        }
        logger.severe(logger.getName() + ": " + msg);
    }
}

