/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.handler;

import com.google.common.util.concurrent.ListenableFuture;
import com.yahoo.collections.ListMap;
import com.yahoo.container.handler.Coverage;
import com.yahoo.container.handler.Timing;
import com.yahoo.container.jdisc.ExtendedResponse;
import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.container.logging.HitCounts;
import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.rendering.AsynchronousSectionedRenderer;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.handler.SearchResponse;
import com.yahoo.search.query.context.QueryContext;
import com.yahoo.yolean.trace.TraceNode;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HttpSearchResponse
extends ExtendedResponse {
    private final Result result;
    private final Query query;
    private final Renderer<Result> rendererCopy;
    private final Metric metric;
    private final Timing timing;
    private final HitCounts hitCounts;
    private final TraceNode trace;

    public HttpSearchResponse(int status, Result result, Query query, Renderer<Result> renderer) {
        this(status, result, query, renderer, null, null);
    }

    HttpSearchResponse(int status, Result result, Query query, Renderer<Result> renderer, TraceNode trace, Metric metric) {
        super(status);
        this.query = query;
        this.result = result;
        this.rendererCopy = renderer;
        this.metric = metric;
        this.timing = SearchResponse.createTiming(query, result);
        this.hitCounts = SearchResponse.createHitCounts(query, result);
        this.trace = trace;
        HttpSearchResponse.populateHeaders(this.headers(), result.getHeaders(false));
    }

    private static void populateHeaders(HeaderFields outputHeaders, ListMap<String, String> searchHeaders) {
        if (searchHeaders == null) {
            return;
        }
        for (Map.Entry header : searchHeaders.entrySet()) {
            for (String value : (List)header.getValue()) {
                outputHeaders.add((String)header.getKey(), value);
            }
        }
    }

    public ListenableFuture<Boolean> waitableRender(OutputStream stream) throws IOException {
        return HttpSearchResponse.waitableRender(this.result, this.query, this.rendererCopy, stream);
    }

    public static ListenableFuture<Boolean> waitableRender(Result result, Query query, Renderer<Result> renderer, OutputStream stream) throws IOException {
        SearchResponse.trimHits(result);
        SearchResponse.removeEmptySummaryFeatureFields(result);
        return renderer.render(stream, (Response)result, (Execution)query.getModel().getExecution(), (Request)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(OutputStream output, ContentChannel networkChannel, CompletionHandler handler) throws IOException {
        if (this.rendererCopy instanceof AsynchronousSectionedRenderer) {
            AsynchronousSectionedRenderer renderer = (AsynchronousSectionedRenderer)this.rendererCopy;
            renderer.setNetworkWiring(networkChannel, handler);
        }
        try {
            try {
                long nanoStart = System.nanoTime();
                ListenableFuture<Boolean> promise = this.waitableRender(output);
                if (this.metric != null) {
                    promise.addListener((Runnable)new RendererLatencyReporter(nanoStart), Runnable::run);
                }
            }
            finally {
                if (!(this.rendererCopy instanceof AsynchronousSectionedRenderer)) {
                    output.flush();
                }
            }
        }
        finally {
            if (networkChannel != null && !(this.rendererCopy instanceof AsynchronousSectionedRenderer)) {
                networkChannel.close(handler);
            }
        }
    }

    public void populateAccessLogEntry(AccessLogEntry accessLogEntry) {
        super.populateAccessLogEntry(accessLogEntry);
        if (this.trace != null) {
            accessLogEntry.setTrace(this.trace);
        }
        HttpSearchResponse.populateAccessLogEntry(accessLogEntry, this.getHitCounts());
    }

    static void populateAccessLogEntry(AccessLogEntry jdiscRequestAccessLogEntry, HitCounts hitCounts) {
        jdiscRequestAccessLogEntry.setHitCounts(hitCounts);
    }

    public String getParsedQuery() {
        return this.query.toString();
    }

    public Timing getTiming() {
        return this.timing;
    }

    public Coverage getCoverage() {
        return this.result.getCoverage(false);
    }

    public HitCounts getHitCounts() {
        return this.hitCounts;
    }

    public String getContentType() {
        return this.rendererCopy.getMimeType();
    }

    public String getCharacterEncoding() {
        String encoding = this.result.getQuery().getModel().getEncoding();
        return encoding != null ? encoding : this.rendererCopy.getEncoding();
    }

    public Query getQuery() {
        return this.query;
    }

    public Result getResult() {
        return this.result;
    }

    public Iterable<Execution.Trace.LogValue> getLogValues() {
        QueryContext context = this.query.getContext(false);
        return context == null ? Collections::emptyIterator : context::logValueIterator;
    }

    private class RendererLatencyReporter
    implements Runnable {
        final long nanoStart;

        RendererLatencyReporter(long nanoStart) {
            this.nanoStart = nanoStart;
        }

        @Override
        public void run() {
            long latencyNanos = System.nanoTime() - this.nanoStart;
            Metric.Context ctx = HttpSearchResponse.this.metric.createContext(Map.of("renderer", HttpSearchResponse.this.rendererCopy.getClassName(), "mime", HttpSearchResponse.this.rendererCopy.getMimeType()));
            HttpSearchResponse.this.metric.set("jdisc.render.latency", (Number)latencyNanos, ctx);
        }
    }
}

