/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.google.common.collect.ImmutableList;
import com.yahoo.search.dispatch.searchcluster.Node;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class Group {
    private static final Logger log = Logger.getLogger(Group.class.getName());
    private static final double maxContentSkew = 0.1;
    private static final int minDocsPerNodeToRequireLowSkew = 100;
    private final int id;
    private final ImmutableList<Node> nodes;
    private final AtomicBoolean hasSufficientCoverage = new AtomicBoolean(true);
    private final AtomicBoolean hasFullCoverage = new AtomicBoolean(true);
    private final AtomicLong activeDocuments = new AtomicLong(0L);
    private final AtomicBoolean isBlockingWrites = new AtomicBoolean(false);
    private final AtomicBoolean isBalanced = new AtomicBoolean(true);

    public Group(int id, List<Node> nodes) {
        this.id = id;
        this.nodes = ImmutableList.copyOf(nodes);
        int idx = 0;
        for (Node node : nodes) {
            node.setPathIndex(idx);
            ++idx;
        }
    }

    public int id() {
        return this.id;
    }

    public ImmutableList<Node> nodes() {
        return this.nodes;
    }

    public boolean hasSufficientCoverage() {
        return this.hasSufficientCoverage.get();
    }

    void setHasSufficientCoverage(boolean sufficientCoverage) {
        this.hasSufficientCoverage.lazySet(sufficientCoverage);
    }

    public int workingNodes() {
        return (int)this.nodes.stream().filter(node -> node.isWorking() == Boolean.TRUE).count();
    }

    public void aggregateNodeValues() {
        long activeDocs = this.nodes.stream().filter(node -> node.isWorking() == Boolean.TRUE).mapToLong(Node::getActiveDocuments).sum();
        this.activeDocuments.set(activeDocs);
        this.isBlockingWrites.set(this.nodes.stream().anyMatch(Node::isBlockingWrites));
        int numWorkingNodes = this.workingNodes();
        if (numWorkingNodes > 0) {
            boolean balanced;
            long average = activeDocs / (long)numWorkingNodes;
            long skew = this.nodes.stream().filter(node -> node.isWorking() == Boolean.TRUE).mapToLong(node -> Math.abs(node.getActiveDocuments() - average)).sum();
            boolean bl = balanced = (double)skew <= (double)activeDocs * 0.1;
            if (!this.isBalanced.get() || balanced != this.isBalanced.get()) {
                if (!this.isSparse()) {
                    log.info("Content is " + (balanced ? "" : "not ") + "well balanced. Current deviation = " + skew * 100L / activeDocs + " %. activeDocs = " + activeDocs + ", skew = " + skew + ", average = " + average);
                }
                this.isBalanced.set(balanced);
            }
        } else {
            this.isBalanced.set(true);
        }
    }

    long activeDocuments() {
        return this.activeDocuments.get();
    }

    public boolean isBlockingWrites() {
        return this.isBlockingWrites.get();
    }

    public boolean isBalanced() {
        return this.isBalanced.get();
    }

    public boolean isSparse() {
        if (this.nodes.isEmpty()) {
            return false;
        }
        return this.activeDocuments.get() / (long)this.nodes.size() < 100L;
    }

    public boolean fullCoverageStatusChanged(boolean hasFullCoverageNow) {
        boolean previousState = this.hasFullCoverage.getAndSet(hasFullCoverageNow);
        return previousState != hasFullCoverageNow;
    }

    public String toString() {
        return "group " + this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        return ((Group)other).id == this.id;
    }
}

