/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.cluster;

import com.yahoo.component.ComponentId;
import com.yahoo.container.protect.Error;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cluster.ClusterMonitor;
import com.yahoo.search.cluster.Hasher;
import com.yahoo.search.cluster.NodeManager;
import com.yahoo.search.cluster.PingableSearcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.Exceptions;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public abstract class ClusterSearcher<T>
extends PingableSearcher
implements NodeManager<T> {
    private final Hasher<T> hasher;
    private final ClusterMonitor<T> monitor;

    public ClusterSearcher(ComponentId id, List<T> connections, boolean internal) {
        this(id, connections, new Hasher(), internal);
    }

    public ClusterSearcher(ComponentId id, List<T> connections, Hasher<T> hasher, boolean internal) {
        this(id, connections, hasher, internal, true);
    }

    protected ClusterSearcher(ComponentId id, List<T> connections, Hasher<T> hasher, boolean internal, boolean startPingThread) {
        super(id);
        this.hasher = hasher;
        this.monitor = new ClusterMonitor(this, startPingThread);
        for (T connection : connections) {
            this.monitor.add(connection, internal);
            hasher.add(connection);
        }
    }

    @Override
    public final void ping(ClusterMonitor<T> clusterMonitor, T p, Executor executor) {
        Pong pong;
        this.log(Level.FINE, "Sending ping to: ", p);
        Pinger pinger = new Pinger(p);
        FutureTask<Pong> future = new FutureTask<Pong>(pinger);
        executor.execute(future);
        Throwable logThrowable = null;
        try {
            pong = future.get(clusterMonitor.getConfiguration().getFailLimit(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            pong = new Pong(ErrorMessage.createUnspecifiedError("Ping was interrupted: " + p));
            logThrowable = e;
        }
        catch (ExecutionException e) {
            pong = new Pong(ErrorMessage.createUnspecifiedError("Execution was interrupted: " + p));
            logThrowable = e;
        }
        catch (LinkageError e) {
            pong = new Pong(ErrorMessage.createErrorInPluginSearcher("Class loading problem", e));
            logThrowable = e;
        }
        catch (TimeoutException e) {
            pong = new Pong(ErrorMessage.createNoAnswerWhenPingingNode("Ping thread timed out."));
        }
        future.cancel(true);
        if (pong.badResponse()) {
            clusterMonitor.failed(p, pong.error().get());
            this.log(Level.FINE, "Failed ping - ", pong);
        } else {
            clusterMonitor.responded(p);
            this.log(Level.FINE, "Answered ping - ", p);
        }
        if (logThrowable != null) {
            StackTraceElement[] trace = logThrowable.getStackTrace();
            String traceAsString = null;
            if (trace != null) {
                StringBuilder b = new StringBuilder(": ");
                for (StackTraceElement k : trace) {
                    if (k == null) {
                        b.append("null\n");
                        continue;
                    }
                    b.append(k.toString()).append('\n');
                }
                traceAsString = b.toString();
            }
            this.getLogger().warning("Caught " + logThrowable.getClass().getName() + " exception in " + this.getId().getName() + " ping" + (trace == null ? ", no stack trace available." : traceAsString));
        }
    }

    protected abstract Pong ping(Ping var1, T var2);

    protected T getFirstConnection(Hasher.NodeList<T> nodes, int code, int trynum, Query query) {
        return nodes.select(code, trynum);
    }

    @Override
    public final Result search(Query query, Execution execution) {
        Result result;
        int tries = 0;
        Hasher.NodeList<T> nodes = this.getHasher().getNodes();
        if (nodes.getNodeCount() == 0) {
            return this.search(query, execution, ErrorMessage.createNoBackendsInService("No nodes in service in " + this + " (" + this.monitor.nodeMonitors().size() + " was configured, none is responding)"));
        }
        int code = query.hashCode();
        T connection = this.getFirstConnection(nodes, code, tries, query);
        do {
            if (connection == null) {
                return this.search(query, execution, ErrorMessage.createNoBackendsInService("No in node could handle " + query + " according to " + this.hasher + " in " + this));
            }
            if (this.timedOut(query)) {
                return new Result(query, ErrorMessage.createTimeout("No time left for searching"));
            }
            if (query.getTraceLevel() >= 8) {
                query.trace("Trying " + connection, false, 8);
            }
            if (!this.shouldRetry(query, result = this.robustSearch(query, execution, connection))) {
                return result;
            }
            if (query.getTraceLevel() >= 6) {
                query.trace("Error from connection " + connection + " : " + result.hits().getError(), false, 6);
            }
            if (result.hits().getError().getCode() == Error.TIMEOUT.code) {
                return result;
            }
            this.log(Level.FINER, "No result, checking for timeout.");
            connection = nodes.select(code, ++tries);
        } while (tries < nodes.getNodeCount());
        return result;
    }

    protected boolean shouldRetry(Query query, Result result) {
        return result.hits().getError() != null;
    }

    protected Result search(Query query, Execution execution, ErrorMessage message) {
        return new Result(query, message);
    }

    protected Result robustSearch(Query query, Execution execution, T connection) {
        Result result;
        try {
            result = this.search(query, execution, connection);
        }
        catch (RuntimeException e) {
            this.log(Level.WARNING, "An exception occurred while invoking backend searcher.", e);
            result = new Result(query, ErrorMessage.createBackendCommunicationError("Failed calling " + connection + " in " + this + " for " + query + ": " + Exceptions.toMessageString((Throwable)e)));
        }
        if (result == null) {
            result = new Result(query, ErrorMessage.createBackendCommunicationError("No result returned in " + this + " from " + connection + " for " + query));
        }
        return result;
    }

    protected abstract Result search(Query var1, Execution var2, T var3);

    @Override
    public final void fill(Result result, String summaryClass, Execution execution) {
        int code;
        Query query = result.getQuery();
        Hasher.NodeList<T> nodes = this.getHasher().getNodes();
        T connection = nodes.select(code = query.hashCode(), 0);
        if (connection != null) {
            if (this.timedOut(query)) {
                result.hits().addError(ErrorMessage.createTimeout("No time left to get summaries for " + result));
            } else {
                this.doFill(connection, result, summaryClass, execution);
            }
        } else {
            result.hits().addError(ErrorMessage.createNoBackendsInService("Could not fill '" + result + "' in '" + this + "'"));
        }
    }

    private void doFill(T connection, Result result, String summaryClass, Execution execution) {
        try {
            this.fill(result, summaryClass, execution, connection);
        }
        catch (RuntimeException e) {
            result.hits().addError(ErrorMessage.createBackendCommunicationError("Error filling " + result + " from " + connection + ": " + Exceptions.toMessageString((Throwable)e)));
        }
    }

    protected abstract void fill(Result var1, String var2, Execution var3, T var4);

    @Override
    public void working(T node) {
        this.getHasher().add(node);
    }

    @Override
    public void failed(T node) {
        this.getHasher().remove(node);
    }

    public Hasher<T> getHasher() {
        return this.hasher;
    }

    public ClusterMonitor<T> getMonitor() {
        return this.monitor;
    }

    protected boolean timedOut(Query query) {
        return query.getDurationTime() >= query.getTimeout();
    }

    protected void log(Level level, Object ... objects) {
        if (!this.getLogger().isLoggable(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object);
        }
        this.getLogger().log(level, sb.toString());
    }

    public void deconstruct() {
        super.deconstruct();
        this.monitor.shutdown();
    }

    private class Pinger
    implements Callable<Pong> {
        private T connection;

        public Pinger(T connection) {
            this.connection = connection;
        }

        @Override
        public Pong call() {
            try {
                return ClusterSearcher.this.ping(new Ping(ClusterSearcher.this.monitor.getConfiguration().getRequestTimeout()), this.connection);
            }
            catch (RuntimeException e) {
                return new Pong(ErrorMessage.createBackendCommunicationError("Exception when pinging " + this.connection + ": " + Exceptions.toMessageString((Throwable)e)));
            }
        }
    }
}

