/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.language.Language;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.BlockItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.parser.SimpleParser;
import com.yahoo.prelude.query.parser.Token;
import com.yahoo.search.query.parser.ParserEnvironment;
import java.util.ListIterator;

public class AnyParser
extends SimpleParser {
    public AnyParser(ParserEnvironment environment) {
        super(environment);
    }

    @Override
    protected Item parseItems() {
        return this.anyItems(true);
    }

    Item parseFilter(String filter, Language queryLanguage, IndexFacts.Session indexFacts) {
        this.setState(queryLanguage, indexFacts);
        this.tokenize(filter, null, indexFacts, queryLanguage);
        Item filterRoot = this.anyItems(true);
        if (filterRoot == null) {
            return null;
        }
        this.markAllTermsAsFilters(filterRoot);
        return filterRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Item negativeItem() {
        int position = this.tokens.getPosition();
        Item item = null;
        try {
            this.tokens.skipMultiple(Token.Kind.PLUS);
            if (!this.tokens.skipMultiple(Token.Kind.MINUS)) {
                Item item2 = null;
                return item2;
            }
            if (this.tokens.currentIsNoIgnore(Token.Kind.SPACE)) {
                Item item3 = null;
                return item3;
            }
            item = this.indexableItem();
            if (item == null && (item = this.compositeItem()) != null && item instanceof OrItem) {
                AndItem and = new AndItem();
                ListIterator<Item> i = ((OrItem)item).getItemIterator();
                while (i.hasNext()) {
                    and.addItem((Item)i.next());
                }
                item = and;
            }
            if (item != null) {
                item.setProtected(true);
            }
            Item item4 = item;
            return item4;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    @Override
    protected Item combineItems(Item topLevelItem, Item item) {
        if (topLevelItem == null) {
            return item;
        }
        if (topLevelItem instanceof OrItem && item instanceof OrItem) {
            OrItem newTopOr = new OrItem();
            newTopOr.addItem(topLevelItem);
            newTopOr.addItem(item);
            return newTopOr;
        }
        if (!(topLevelItem instanceof RankItem)) {
            RankItem rank = new RankItem();
            if (topLevelItem instanceof NotItem) {
                rank.addItem(topLevelItem);
                rank.addItem(item);
            } else {
                rank.addItem(item);
                rank.addItem(topLevelItem);
            }
            return rank;
        }
        if (topLevelItem instanceof RankItem && item instanceof RankItem && ((RankItem)item).getItem(0) instanceof OrItem) {
            RankItem itemAsRank = (RankItem)item;
            OrItem or = (OrItem)itemAsRank.getItem(0);
            ((RankItem)topLevelItem).addItem(0, or);
            for (int i = 1; i < itemAsRank.getItemCount(); ++i) {
                or.addItem(0, itemAsRank.getItem(i));
            }
            return topLevelItem;
        }
        ((RankItem)topLevelItem).addItem(0, item);
        return topLevelItem;
    }

    Item applyFilter(Item root, String filter, Language queryLanguage, IndexFacts.Session indexFacts) {
        this.setState(queryLanguage, indexFacts);
        this.tokenize(filter, null, indexFacts, queryLanguage);
        return this.filterItems(root);
    }

    private void markAllTermsAsFilters(Item root) {
        if (root instanceof BlockItem) {
            root.setFilter(true);
        }
        if (root instanceof TermItem) {
            root.setFilter(true);
        } else {
            if (root instanceof PhraseItem) {
                root.setFilter(true);
            }
            ListIterator<Item> i = ((CompositeItem)root).getItemIterator();
            while (i.hasNext()) {
                this.markAllTermsAsFilters((Item)i.next());
            }
        }
    }

    private Item filterItems(Item root) {
        while (this.tokens.hasNext()) {
            Item item = null;
            item = this.positiveItem();
            root = this.addAndFilter(root, item);
            if (item == null) {
                item = this.negativeItem();
                root = this.addNotFilter(root, item);
            }
            if (item == null) {
                item = this.indexableItem();
                root = this.addRankFilter(root, item);
            }
            if (item != null) {
                this.markAllTermsAsFilters(item);
                continue;
            }
            this.tokens.skip();
        }
        return root;
    }

    private Item addAndFilter(Item root, Item item) {
        if (item == null) {
            return root;
        }
        if (root instanceof AndItem) {
            ((AndItem)root).addItem(item);
            return root;
        }
        if (root instanceof RankItem) {
            Item firstChild = ((RankItem)root).getItem(0);
            if (firstChild instanceof AndItem) {
                ((AndItem)firstChild).addItem(item);
                return root;
            }
            if (firstChild instanceof NotItem) {
                ((NotItem)firstChild).addPositiveItem(item);
                return root;
            }
        }
        AndItem and = new AndItem();
        and.addItem(root);
        and.addItem(item);
        return and;
    }

    private Item addNotFilter(Item root, Item item) {
        if (item == null) {
            return root;
        }
        if (root instanceof NotItem) {
            ((NotItem)root).addNegativeItem(item);
            return root;
        }
        if (root instanceof RankItem) {
            RankItem rootAsRank = (RankItem)root;
            Item firstChild = rootAsRank.getItem(0);
            if (firstChild instanceof NotItem) {
                ((NotItem)firstChild).addNegativeItem(item);
                return root;
            }
            NotItem not = new NotItem();
            not.addPositiveItem(rootAsRank.removeItem(0));
            not.addNegativeItem(item);
            if (rootAsRank.getItemCount() == 0) {
                return not;
            }
            rootAsRank.addItem(0, not);
            return root;
        }
        NotItem not = new NotItem();
        not.addPositiveItem(root);
        not.addNegativeItem(item);
        return not;
    }

    private Item addRankFilter(Item root, Item item) {
        if (item == null) {
            return root;
        }
        if (root instanceof RankItem) {
            ((RankItem)root).addItem(item);
            return root;
        }
        RankItem rank = new RankItem();
        rank.addItem(root);
        rank.addItem(item);
        return rank;
    }
}

