/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.yahoo.container.logging.TraceRenderer;
import com.yahoo.data.JsonProducer;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.JsonRender;
import com.yahoo.data.access.simple.Value;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.lang.MutableBoolean;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.rendering.AsynchronousSectionedRenderer;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.result.AbstractList;
import com.yahoo.search.grouping.result.BucketGroupId;
import com.yahoo.search.grouping.result.Group;
import com.yahoo.search.grouping.result.GroupId;
import com.yahoo.search.grouping.result.RawBucketId;
import com.yahoo.search.grouping.result.RawId;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.grouping.result.ValueGroupId;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.DefaultErrorHit;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.FeatureData;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.NanNumber;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.LongSupplier;

public class JsonRenderer
extends AsynchronousSectionedRenderer<Result> {
    private static final CompoundName DEBUG_RENDERING_KEY = new CompoundName("renderer.json.debug");
    private static final CompoundName JSON_CALLBACK = new CompoundName("jsoncallback");
    private static final String BUCKET_LIMITS = "limits";
    private static final String BUCKET_TO = "to";
    private static final String BUCKET_FROM = "from";
    private static final String CHILDREN = "children";
    private static final String CONTINUATION = "continuation";
    private static final String COVERAGE = "coverage";
    private static final String COVERAGE_COVERAGE = "coverage";
    private static final String COVERAGE_DOCUMENTS = "documents";
    private static final String COVERAGE_DEGRADE = "degraded";
    private static final String COVERAGE_DEGRADE_MATCHPHASE = "match-phase";
    private static final String COVERAGE_DEGRADE_TIMEOUT = "timeout";
    private static final String COVERAGE_DEGRADE_ADAPTIVE_TIMEOUT = "adaptive-timeout";
    private static final String COVERAGE_DEGRADED_NON_IDEAL_STATE = "non-ideal-state";
    private static final String COVERAGE_FULL = "full";
    private static final String COVERAGE_NODES = "nodes";
    private static final String COVERAGE_RESULTS = "results";
    private static final String COVERAGE_RESULTS_FULL = "resultsFull";
    private static final String ERRORS = "errors";
    private static final String ERROR_CODE = "code";
    private static final String ERROR_MESSAGE = "message";
    private static final String ERROR_SOURCE = "source";
    private static final String ERROR_STACK_TRACE = "stackTrace";
    private static final String ERROR_SUMMARY = "summary";
    private static final String FIELDS = "fields";
    private static final String ID = "id";
    private static final String LABEL = "label";
    private static final String RELEVANCE = "relevance";
    private static final String ROOT = "root";
    private static final String SOURCE = "source";
    private static final String TOTAL_COUNT = "totalCount";
    private static final String TIMING = "timing";
    private static final String QUERY_TIME = "querytime";
    private static final String SUMMARY_FETCH_TIME = "summaryfetchtime";
    private static final String SEARCH_TIME = "searchtime";
    private static final String TYPES = "types";
    private static final String GROUPING_VALUE = "value";
    private static final String VESPA_HIDDEN_FIELD_PREFIX = "$";
    private final JsonFactory generatorFactory = new JsonFactory();
    private JsonGenerator generator;
    private FieldConsumer fieldConsumer;
    private Deque<Integer> renderedChildren;
    private boolean debugRendering;
    private LongSupplier timeSource;
    private OutputStream stream;

    public JsonRenderer() {
        this(null);
    }

    public JsonRenderer(Executor executor) {
        super(executor);
        this.generatorFactory.setCodec((ObjectCodec)JsonRenderer.createJsonCodec());
    }

    protected static ObjectMapper createJsonCodec() {
        return new ObjectMapper().disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
    }

    public void init() {
        super.init();
        this.debugRendering = false;
        this.setGenerator(null, this.debugRendering);
        this.renderedChildren = null;
        this.timeSource = System::currentTimeMillis;
        this.stream = null;
    }

    public void beginResponse(OutputStream stream) throws IOException {
        this.beginJsonCallback(stream);
        this.debugRendering = this.getDebugRendering(this.getResult().getQuery());
        this.setGenerator(this.generatorFactory.createGenerator(stream, JsonEncoding.UTF8), this.debugRendering);
        this.renderedChildren = new ArrayDeque<Integer>();
        this.generator.writeStartObject();
        this.renderTrace(this.getExecution().trace());
        this.renderTiming();
        this.generator.writeFieldName(ROOT);
    }

    private void renderTiming() throws IOException {
        if (!this.getResult().getQuery().getPresentation().getTiming()) {
            return;
        }
        double milli = 0.001;
        long now = this.timeSource.getAsLong();
        long searchTime = now - this.getResult().getElapsedTime().first();
        double searchSeconds = (double)searchTime * milli;
        this.generator.writeObjectFieldStart(TIMING);
        if (this.getResult().getElapsedTime().firstFill() != 0L) {
            long queryTime = this.getResult().getElapsedTime().weightedSearchTime();
            long summaryFetchTime = this.getResult().getElapsedTime().weightedFillTime();
            double querySeconds = (double)queryTime * milli;
            double summarySeconds = (double)summaryFetchTime * milli;
            this.generator.writeNumberField(QUERY_TIME, querySeconds);
            this.generator.writeNumberField(SUMMARY_FETCH_TIME, summarySeconds);
        }
        this.generator.writeNumberField(SEARCH_TIME, searchSeconds);
        this.generator.writeEndObject();
    }

    private boolean getDebugRendering(Query q) {
        return q != null && q.properties().getBoolean(DEBUG_RENDERING_KEY, false);
    }

    protected void renderTrace(Execution.Trace trace) throws IOException {
        if (!trace.traceNode().children().iterator().hasNext()) {
            return;
        }
        if (this.getResult().getQuery().getTraceLevel() == 0) {
            return;
        }
        try {
            long basetime = trace.traceNode().timestamp();
            if (basetime == 0L) {
                basetime = this.getResult().getElapsedTime().first();
            }
            trace.accept((TraceVisitor)new TraceRenderer(this.generator, (TraceRenderer.FieldConsumer)this.fieldConsumer, basetime));
        }
        catch (TraceRenderer.TraceRenderWrapper e) {
            throw new IOException(e);
        }
    }

    public void beginList(DataList<?> list) throws IOException {
        Preconditions.checkArgument((boolean)(list instanceof HitGroup), (String)"Expected subclass of com.yahoo.search.result.HitGroup, got %s.", list.getClass());
        this.moreChildren();
        this.renderHitGroupHead((HitGroup)list);
    }

    protected void moreChildren() throws IOException {
        if (!this.renderedChildren.isEmpty()) {
            this.childrenArray();
        }
        this.renderedChildren.push(0);
    }

    private void childrenArray() throws IOException {
        if (this.renderedChildren.peek() == 0) {
            this.generator.writeArrayFieldStart(CHILDREN);
        }
        this.renderedChildren.push(this.renderedChildren.pop() + 1);
    }

    private void lessChildren() throws IOException {
        int lastRenderedChildren = this.renderedChildren.pop();
        if (lastRenderedChildren > 0) {
            this.generator.writeEndArray();
        }
    }

    protected void renderHitGroupHead(HitGroup hitGroup) throws IOException {
        ErrorHit errorHit;
        this.generator.writeStartObject();
        this.renderHitContents(hitGroup);
        if (this.getRecursionLevel() == 1) {
            this.renderCoverage();
        }
        if ((errorHit = hitGroup.getErrorHit()) != null) {
            this.renderErrors(errorHit.errors());
        }
    }

    protected void renderErrors(Set<ErrorMessage> errors) throws IOException {
        if (errors.isEmpty()) {
            return;
        }
        this.generator.writeArrayFieldStart(ERRORS);
        for (ErrorMessage e : errors) {
            String summary = e.getMessage();
            String source = e.getSource();
            Throwable cause = e.getCause();
            String message = e.getDetailedMessage();
            this.generator.writeStartObject();
            this.generator.writeNumberField(ERROR_CODE, e.getCode());
            this.generator.writeStringField(ERROR_SUMMARY, summary);
            if (source != null) {
                this.generator.writeStringField("source", source);
            }
            if (message != null) {
                this.generator.writeStringField(ERROR_MESSAGE, message);
            }
            if (cause != null && cause.getStackTrace().length > 0) {
                StringWriter s = new StringWriter();
                PrintWriter p = new PrintWriter(s);
                cause.printStackTrace(p);
                p.close();
                this.generator.writeStringField(ERROR_STACK_TRACE, s.toString());
            }
            this.generator.writeEndObject();
        }
        this.generator.writeEndArray();
    }

    protected void renderCoverage() throws IOException {
        Coverage c = this.getResult().getCoverage(false);
        if (c == null) {
            return;
        }
        this.generator.writeObjectFieldStart("coverage");
        this.generator.writeNumberField("coverage", c.getResultPercentage());
        this.generator.writeNumberField(COVERAGE_DOCUMENTS, c.getDocs());
        if (c.isDegraded()) {
            this.generator.writeObjectFieldStart(COVERAGE_DEGRADE);
            this.generator.writeBooleanField(COVERAGE_DEGRADE_MATCHPHASE, c.isDegradedByMatchPhase());
            this.generator.writeBooleanField(COVERAGE_DEGRADE_TIMEOUT, c.isDegradedByTimeout());
            this.generator.writeBooleanField(COVERAGE_DEGRADE_ADAPTIVE_TIMEOUT, c.isDegradedByAdapativeTimeout());
            this.generator.writeBooleanField(COVERAGE_DEGRADED_NON_IDEAL_STATE, c.isDegradedByNonIdealState());
            this.generator.writeEndObject();
        }
        this.generator.writeBooleanField(COVERAGE_FULL, c.getFull());
        this.generator.writeNumberField(COVERAGE_NODES, c.getNodes());
        this.generator.writeNumberField(COVERAGE_RESULTS, c.getResultSets());
        this.generator.writeNumberField(COVERAGE_RESULTS_FULL, c.getFullResultSets());
        this.generator.writeEndObject();
    }

    protected void renderHit(Hit hit) throws IOException {
        if (!this.shouldRender(hit)) {
            return;
        }
        this.childrenArray();
        this.generator.writeStartObject();
        this.renderHitContents(hit);
        this.generator.writeEndObject();
    }

    protected boolean shouldRender(Hit hit) {
        return !(hit instanceof DefaultErrorHit);
    }

    protected void renderHitContents(Hit hit) throws IOException {
        String source;
        String id = hit.getDisplayId();
        if (id != null) {
            this.generator.writeStringField(ID, id);
        }
        this.generator.writeNumberField(RELEVANCE, hit.getRelevance().getScore());
        if (hit.types().size() > 0) {
            this.generator.writeArrayFieldStart(TYPES);
            for (String t : hit.types()) {
                this.generator.writeString(t);
            }
            this.generator.writeEndArray();
        }
        if ((source = hit.getSource()) != null) {
            this.generator.writeStringField("source", hit.getSource());
        }
        this.renderSpecialCasesForGrouping(hit);
        this.renderAllFields(hit);
    }

    protected void renderAllFields(Hit hit) throws IOException {
        this.fieldConsumer.startHitFields();
        this.renderTotalHitCount(hit);
        this.renderStandardFields(hit);
        this.fieldConsumer.endHitFields();
    }

    private void renderStandardFields(Hit hit) {
        hit.forEachFieldAsRaw(this.fieldConsumer);
    }

    private void renderSpecialCasesForGrouping(Hit hit) throws IOException {
        if (hit instanceof AbstractList) {
            this.renderGroupingListSyntheticFields((AbstractList)hit);
        } else if (hit instanceof Group) {
            this.renderGroupingGroupSyntheticFields(hit);
        }
    }

    private void renderGroupingGroupSyntheticFields(Hit hit) throws IOException {
        this.renderGroupMetadata(((Group)hit).getGroupId());
        if (hit instanceof RootGroup) {
            this.renderContinuations(Collections.singletonMap("this", ((RootGroup)hit).continuation()));
        }
    }

    private void renderGroupingListSyntheticFields(AbstractList a) throws IOException {
        this.writeGroupingLabel(a);
        this.renderContinuations(a.continuations());
    }

    private void writeGroupingLabel(AbstractList a) throws IOException {
        this.generator.writeStringField(LABEL, a.getLabel());
    }

    protected void renderContinuations(Map<String, Continuation> continuations) throws IOException {
        if (continuations.isEmpty()) {
            return;
        }
        this.generator.writeObjectFieldStart(CONTINUATION);
        for (Map.Entry<String, Continuation> e : continuations.entrySet()) {
            this.generator.writeStringField(e.getKey(), e.getValue().toString());
        }
        this.generator.writeEndObject();
    }

    protected void renderGroupMetadata(GroupId id) throws IOException {
        if (!(id instanceof ValueGroupId) && !(id instanceof BucketGroupId)) {
            return;
        }
        if (id instanceof ValueGroupId) {
            ValueGroupId valueId = (ValueGroupId)id;
            this.generator.writeStringField(GROUPING_VALUE, JsonRenderer.getIdValue(valueId));
        } else {
            BucketGroupId bucketId = (BucketGroupId)id;
            this.generator.writeObjectFieldStart(BUCKET_LIMITS);
            this.generator.writeStringField(BUCKET_FROM, JsonRenderer.getBucketFrom(bucketId));
            this.generator.writeStringField(BUCKET_TO, JsonRenderer.getBucketTo(bucketId));
            this.generator.writeEndObject();
        }
    }

    private static String getIdValue(ValueGroupId<?> id) {
        return (id instanceof RawId ? Arrays.toString((byte[])((RawId)id).getValue()) : id.getValue()).toString();
    }

    private static String getBucketFrom(BucketGroupId<?> id) {
        return (id instanceof RawBucketId ? Arrays.toString((byte[])((RawBucketId)id).getFrom()) : id.getFrom()).toString();
    }

    private static String getBucketTo(BucketGroupId<?> id) {
        return (id instanceof RawBucketId ? Arrays.toString((byte[])((RawBucketId)id).getTo()) : id.getTo()).toString();
    }

    protected void renderTotalHitCount(Hit hit) throws IOException {
        if (this.getRecursionLevel() != 1 || !(hit instanceof HitGroup)) {
            return;
        }
        this.fieldConsumer.ensureFieldsField();
        this.generator.writeNumberField(TOTAL_COUNT, this.getResult().getTotalHitCount());
    }

    public void data(Data data) throws IOException {
        Preconditions.checkArgument((boolean)(data instanceof Hit), (String)"Expected subclass of com.yahoo.search.result.Hit, got %s.", data.getClass());
        this.renderHit((Hit)data);
    }

    public void endList(DataList<?> list) throws IOException {
        this.lessChildren();
        this.generator.writeEndObject();
    }

    public void endResponse() throws IOException {
        this.generator.close();
        this.endJsonCallback();
    }

    public String getEncoding() {
        return "utf-8";
    }

    public String getMimeType() {
        return "application/json";
    }

    private Result getResult() {
        Response r = this.getResponse();
        Preconditions.checkArgument((boolean)(r instanceof Result), (String)"JsonRenderer can only render instances of com.yahoo.search.Result, got instance of %s.", r.getClass());
        return (Result)r;
    }

    private void beginJsonCallback(OutputStream stream) throws IOException {
        if (this.shouldRenderJsonCallback()) {
            String jsonCallback = this.getJsonCallback() + "(";
            stream.write(jsonCallback.getBytes(StandardCharsets.UTF_8));
            this.stream = stream;
        }
    }

    private void endJsonCallback() throws IOException {
        if (this.shouldRenderJsonCallback() && this.stream != null) {
            this.stream.write(");".getBytes(StandardCharsets.UTF_8));
        }
    }

    private boolean shouldRenderJsonCallback() {
        String jsonCallback = this.getJsonCallback();
        return jsonCallback != null && !"".equals(jsonCallback);
    }

    private String getJsonCallback() {
        Result result = this.getResult();
        Query query = result.getQuery();
        if (query != null) {
            return query.properties().getString(JSON_CALLBACK, null);
        }
        return null;
    }

    private void setGenerator(JsonGenerator generator, boolean debugRendering) {
        this.generator = generator;
        this.fieldConsumer = generator == null ? null : this.createFieldConsumer(generator, debugRendering);
    }

    protected FieldConsumer createFieldConsumer(JsonGenerator generator, boolean debugRendering) {
        return new FieldConsumer(generator, debugRendering);
    }

    void setTimeSource(LongSupplier timeSource) {
        this.timeSource = timeSource;
    }

    public static class FieldConsumer
    implements Hit.RawUtf8Consumer,
    TraceRenderer.FieldConsumer {
        private final JsonGenerator generator;
        private final boolean debugRendering;
        private MutableBoolean hasFieldsField;

        public FieldConsumer(JsonGenerator generator, boolean debugRendering) {
            this.generator = generator;
            this.debugRendering = debugRendering;
        }

        void startHitFields() {
            this.hasFieldsField = new MutableBoolean(false);
        }

        void ensureFieldsField() throws IOException {
            if (this.hasFieldsField.get()) {
                return;
            }
            this.generator.writeObjectFieldStart(JsonRenderer.FIELDS);
            this.hasFieldsField.set(true);
        }

        void endHitFields() throws IOException {
            if (!this.hasFieldsField.get()) {
                return;
            }
            this.generator.writeEndObject();
            this.hasFieldsField = null;
        }

        @Override
        public void accept(String name, Object value) {
            try {
                if (this.shouldRender(name, value)) {
                    this.ensureFieldsField();
                    this.generator.writeFieldName(name);
                    this.renderFieldContents(value);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void accept(String name, byte[] utf8Data, int offset, int length) {
            try {
                if (this.shouldRenderUtf8Value(name, length)) {
                    this.ensureFieldsField();
                    this.generator.writeFieldName(name);
                    this.generator.writeUTF8String(utf8Data, offset, length);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected boolean shouldRender(String name, Object value) {
            if (this.debugRendering) {
                return true;
            }
            if (name.startsWith(JsonRenderer.VESPA_HIDDEN_FIELD_PREFIX)) {
                return false;
            }
            if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
                return false;
            }
            if (value instanceof StringFieldValue && ((StringFieldValue)value).getString().isEmpty()) {
                return false;
            }
            return !(value instanceof NanNumber);
        }

        protected boolean shouldRenderUtf8Value(String name, int length) {
            if (this.debugRendering) {
                return true;
            }
            if (name.startsWith(JsonRenderer.VESPA_HIDDEN_FIELD_PREFIX)) {
                return false;
            }
            return length != 0;
        }

        private static Inspector wrapAsMap(Inspector data) {
            if (data.type() != Type.ARRAY) {
                return null;
            }
            if (data.entryCount() == 0) {
                return null;
            }
            Value.ObjectValue map = new Value.ObjectValue();
            for (int i = 0; i < data.entryCount(); ++i) {
                Inspector obj = data.entry(i);
                if (obj.type() != Type.OBJECT) {
                    return null;
                }
                if (obj.fieldCount() != 2) {
                    return null;
                }
                Inspector key = obj.field("key");
                Inspector value = obj.field(JsonRenderer.GROUPING_VALUE);
                if (key.type() != Type.STRING) {
                    return null;
                }
                if (!value.valid()) {
                    return null;
                }
                map.put(key.asString(), value);
            }
            return map;
        }

        private void renderInspector(Inspector data) throws IOException {
            Inspector asMap = FieldConsumer.wrapAsMap(data);
            if (asMap != null) {
                StringBuilder intermediate = new StringBuilder();
                JsonRender.render((Inspectable)asMap, (StringBuilder)intermediate, (boolean)true);
                this.generator.writeRawValue(intermediate.toString());
            } else {
                this.renderInspectorDirect(data);
            }
        }

        private void renderInspectorDirect(Inspector data) throws IOException {
            StringBuilder intermediate = new StringBuilder();
            JsonRender.render((Inspectable)data, (StringBuilder)intermediate, (boolean)true);
            this.generator.writeRawValue(intermediate.toString());
        }

        protected void renderFieldContents(Object field) throws IOException {
            if (field instanceof Inspectable && !(field instanceof FeatureData)) {
                this.renderInspector(((Inspectable)field).inspect());
            } else {
                this.accept(field);
            }
        }

        public void accept(Object field) throws IOException {
            if (field == null) {
                this.generator.writeNull();
            } else if (field instanceof Boolean) {
                this.generator.writeBoolean(((Boolean)field).booleanValue());
            } else if (field instanceof Number) {
                this.renderNumberField((Number)field);
            } else if (field instanceof TreeNode) {
                this.generator.writeTree((TreeNode)field);
            } else if (field instanceof Tensor) {
                this.renderTensor(Optional.of((Tensor)field));
            } else if (field instanceof FeatureData) {
                this.generator.writeRawValue(((FeatureData)field).toJson());
            } else if (field instanceof Inspectable) {
                this.renderInspectorDirect(((Inspectable)field).inspect());
            } else if (field instanceof JsonProducer) {
                this.generator.writeRawValue(((JsonProducer)field).toJson());
            } else if (field instanceof StringFieldValue) {
                this.generator.writeString(((StringFieldValue)field).getString());
            } else if (field instanceof TensorFieldValue) {
                this.renderTensor(((TensorFieldValue)field).getTensor());
            } else if (field instanceof FieldValue) {
                ((FieldValue)field).serialize(null, (FieldWriter)new JsonWriter(this.generator));
            } else {
                this.generator.writeString(field.toString());
            }
        }

        private void renderNumberField(Number field) throws IOException {
            if (field instanceof Integer) {
                this.generator.writeNumber(field.intValue());
            } else if (field instanceof Float) {
                this.generator.writeNumber(field.floatValue());
            } else if (field instanceof Double) {
                this.generator.writeNumber(field.doubleValue());
            } else if (field instanceof Long) {
                this.generator.writeNumber(field.longValue());
            } else if (field instanceof Byte || field instanceof Short) {
                this.generator.writeNumber(field.intValue());
            } else if (field instanceof BigInteger) {
                this.generator.writeNumber((BigInteger)field);
            } else if (field instanceof BigDecimal) {
                this.generator.writeNumber((BigDecimal)field);
            } else {
                this.generator.writeNumber(field.doubleValue());
            }
        }

        private void renderTensor(Optional<Tensor> tensor) throws IOException {
            this.generator.writeStartObject();
            this.generator.writeArrayFieldStart("cells");
            if (tensor.isPresent()) {
                Iterator i = tensor.get().cellIterator();
                while (i.hasNext()) {
                    Tensor.Cell cell = (Tensor.Cell)i.next();
                    this.generator.writeStartObject();
                    this.generator.writeObjectFieldStart("address");
                    for (int d = 0; d < cell.getKey().size(); ++d) {
                        this.generator.writeObjectField(((TensorType.Dimension)tensor.get().type().dimensions().get(d)).name(), (Object)cell.getKey().label(d));
                    }
                    this.generator.writeEndObject();
                    this.generator.writeObjectField(JsonRenderer.GROUPING_VALUE, (Object)cell.getValue());
                    this.generator.writeEndObject();
                }
            }
            this.generator.writeEndArray();
            this.generator.writeEndObject();
        }
    }
}

