/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.google.common.collect.ImmutableList;
import com.yahoo.search.dispatch.searchcluster.Node;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class Group {
    private final int id;
    private final ImmutableList<Node> nodes;
    private final AtomicBoolean hasSufficientCoverage = new AtomicBoolean(true);
    private final AtomicBoolean hasFullCoverage = new AtomicBoolean(true);
    private final AtomicLong activeDocuments = new AtomicLong(0L);
    private final AtomicBoolean isBlockingWrites = new AtomicBoolean(false);
    private final AtomicBoolean isContentWellBalanced = new AtomicBoolean(true);
    private static final double MAX_UNBALANCE = 0.1;
    private static final Logger log = Logger.getLogger(Group.class.getName());

    public Group(int id, List<Node> nodes) {
        this.id = id;
        this.nodes = ImmutableList.copyOf(nodes);
        int idx = 0;
        for (Node node : nodes) {
            node.setPathIndex(idx);
            ++idx;
        }
    }

    public int id() {
        return this.id;
    }

    public ImmutableList<Node> nodes() {
        return this.nodes;
    }

    public boolean hasSufficientCoverage() {
        return this.hasSufficientCoverage.get();
    }

    void setHasSufficientCoverage(boolean sufficientCoverage) {
        this.hasSufficientCoverage.lazySet(sufficientCoverage);
    }

    public int workingNodes() {
        return (int)this.nodes.stream().filter(node -> node.isWorking() == Boolean.TRUE).count();
    }

    void aggregateNodeValues() {
        long activeDocs = this.nodes.stream().filter(node -> node.isWorking() == Boolean.TRUE).mapToLong(Node::getActiveDocuments).sum();
        this.activeDocuments.set(activeDocs);
        this.isBlockingWrites.set(this.nodes.stream().anyMatch(Node::isBlockingWrites));
        int numWorkingNodes = this.workingNodes();
        if (numWorkingNodes > 0) {
            boolean isDeviationSmall;
            long average = activeDocs / (long)numWorkingNodes;
            long deviation = this.nodes.stream().filter(node -> node.isWorking() == Boolean.TRUE).mapToLong(node -> Math.abs(node.getActiveDocuments() - average)).sum();
            boolean bl = isDeviationSmall = (double)deviation <= (double)activeDocs * 0.1;
            if (!(this.isContentWellBalanced.get() && isDeviationSmall == this.isContentWellBalanced.get() || activeDocs <= 0L)) {
                log.info("Content is " + (isDeviationSmall ? "" : "not ") + "well balanced. Current deviation = " + deviation * 100L / activeDocs + " %. activeDocs = " + activeDocs + ", deviation = " + deviation + ", average = " + average);
                this.isContentWellBalanced.set(isDeviationSmall);
            }
        } else {
            this.isContentWellBalanced.set(true);
        }
    }

    long getActiveDocuments() {
        return this.activeDocuments.get();
    }

    public boolean isBlockingWrites() {
        return this.isBlockingWrites.get();
    }

    public boolean isContentWellBalanced() {
        return this.isContentWellBalanced.get();
    }

    public boolean isFullCoverageStatusChanged(boolean hasFullCoverageNow) {
        boolean previousState = this.hasFullCoverage.getAndSet(hasFullCoverageNow);
        return previousState != hasFullCoverageNow;
    }

    public String toString() {
        return "group " + this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        return ((Group)other).id == this.id;
    }
}

