/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.statistics;

import com.yahoo.collections.TinyIdentitySet;
import com.yahoo.search.statistics.TimeTracker;
import java.util.LinkedHashMap;
import java.util.Set;

public class ElapsedTime {
    private Set<TimeTracker> tracks = new TinyIdentitySet(8);

    public void add(TimeTracker track) {
        this.tracks.add(track);
    }

    private long fetcher(TimeTracker.Activity toFetch, TimeTracker fetchFrom) {
        switch (toFetch) {
            case SEARCH: {
                return fetchFrom.searchTime();
            }
            case FILL: {
                return fetchFrom.fillTime();
            }
            case PING: {
                return fetchFrom.pingTime();
            }
        }
        return 0L;
    }

    public long weightedFillTime() {
        return this.weightedTime(TimeTracker.Activity.FILL);
    }

    private long weightedTime(TimeTracker.Activity kind) {
        long total = 0L;
        long elapsed = 0L;
        long first = Long.MAX_VALUE;
        long last = 0L;
        if (this.tracks.isEmpty()) {
            return 0L;
        }
        for (TimeTracker track : this.tracks) {
            total += track.totalTime();
            elapsed += this.fetcher(kind, track);
            last = Math.max(last, track.last());
            first = Math.min(first, track.first());
        }
        if (total == 0L) {
            return 0L;
        }
        return (last - first) * elapsed / total;
    }

    private long absoluteTime(TimeTracker.Activity kind) {
        long elapsed = 0L;
        if (this.tracks.isEmpty()) {
            return 0L;
        }
        for (TimeTracker track : this.tracks) {
            elapsed += this.fetcher(kind, track);
        }
        return elapsed;
    }

    public long fillTime() {
        return this.absoluteTime(TimeTracker.Activity.FILL);
    }

    public long totalTime() {
        long total = 0L;
        for (TimeTracker track : this.tracks) {
            total += track.totalTime();
        }
        return total;
    }

    public long weightedSearchTime() {
        return this.weightedTime(TimeTracker.Activity.SEARCH);
    }

    public long searchTime() {
        return this.absoluteTime(TimeTracker.Activity.SEARCH);
    }

    public long pingTime() {
        return this.absoluteTime(TimeTracker.Activity.PING);
    }

    public long weightedPingTime() {
        return this.weightedTime(TimeTracker.Activity.PING);
    }

    public long first() {
        long first = Long.MAX_VALUE;
        for (TimeTracker track : this.tracks) {
            first = Math.min(first, track.first());
        }
        return first;
    }

    public long last() {
        long last = 0L;
        for (TimeTracker track : this.tracks) {
            last = Math.max(last, track.last());
        }
        return last;
    }

    public void merge(ElapsedTime other) {
        for (TimeTracker t : other.tracks) {
            this.add(t);
        }
    }

    public long firstFill() {
        long first = Long.MAX_VALUE;
        if (this.tracks.isEmpty()) {
            return 0L;
        }
        for (TimeTracker t : this.tracks) {
            long candidate = t.firstFill();
            if (candidate == 0L) continue;
            first = Math.min(first, t.firstFill());
        }
        return first;
    }

    public boolean hasDetailedData() {
        for (TimeTracker t : this.tracks) {
            if (t.searcherTracking() == null) continue;
            return true;
        }
        return false;
    }

    public String detailedReport() {
        LinkedHashMap<String, TimeTracker.SearcherTimer> raw = new LinkedHashMap<String, TimeTracker.SearcherTimer>();
        StringBuilder report = new StringBuilder();
        report.append("Time use per searcher: ");
        for (TimeTracker t : this.tracks) {
            TimeTracker.SearcherTimer[] searchers;
            if (t.searcherTracking() == null) continue;
            for (TimeTracker.SearcherTimer s : searchers = t.searcherTracking()) {
                TimeTracker.SearcherTimer sum;
                if (raw.containsKey(s.getName())) {
                    sum = (TimeTracker.SearcherTimer)raw.get(s.getName());
                } else {
                    sum = new TimeTracker.SearcherTimer(s.getName());
                    raw.put(s.getName(), sum);
                }
                sum.merge(s);
            }
        }
        int preLen = report.length();
        for (TimeTracker.SearcherTimer value : raw.values()) {
            if (report.length() > preLen) {
                report.append(",\n    ");
            }
            report.append(value.toString());
        }
        report.append(".");
        return report.toString();
    }
}

