/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.data.JsonProducer;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.JsonRender;
import com.yahoo.data.access.simple.Value;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.JsonFormat;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FeatureData
implements Inspectable,
JsonProducer {
    private static final FeatureData empty = new FeatureData(Value.empty());
    private final Inspector value;
    private Set<String> featureNames = null;
    private Map<String, Double> decodedDoubles = null;
    private Map<String, Tensor> decodedTensors = null;
    private String jsonForm = null;

    public FeatureData(Inspector value) {
        this.value = value;
    }

    public static FeatureData empty() {
        return empty;
    }

    public Inspector inspect() {
        return this.value;
    }

    @Override
    public String toJson() {
        if (this == empty) {
            return "{}";
        }
        if (this.jsonForm != null) {
            return this.jsonForm;
        }
        this.jsonForm = this.writeJson(new StringBuilder()).toString();
        return this.jsonForm;
    }

    @Override
    public StringBuilder writeJson(StringBuilder target) {
        return JsonRender.render((Inspectable)this.value, (JsonRender.StringEncoder)new Encoder(target, true));
    }

    public Double getDouble(String featureName) {
        Double value;
        if (this.decodedDoubles == null) {
            this.decodedDoubles = new HashMap<String, Double>();
        }
        if ((value = this.decodedDoubles.get(featureName)) != null) {
            return value;
        }
        value = this.decodeDouble(featureName);
        if (value != null) {
            this.decodedDoubles.put(featureName, value);
        }
        return value;
    }

    private Double decodeDouble(String featureName) {
        Inspector featureValue = this.getInspector(featureName);
        if (!featureValue.valid()) {
            return null;
        }
        switch (featureValue.type()) {
            case DOUBLE: {
                return featureValue.asDouble();
            }
            case DATA: {
                throw new IllegalArgumentException("Feature '" + featureName + "' is a tensor, not a double");
            }
        }
        throw new IllegalStateException("Unexpected feature value type " + featureValue.type());
    }

    public Tensor getTensor(String featureName) {
        Tensor value;
        if (this.decodedTensors == null) {
            this.decodedTensors = new HashMap<String, Tensor>();
        }
        if ((value = this.decodedTensors.get(featureName)) != null) {
            return value;
        }
        value = this.decodeTensor(featureName);
        if (value != null) {
            this.decodedTensors.put(featureName, value);
        }
        return value;
    }

    private Tensor decodeTensor(String featureName) {
        Inspector featureValue = this.getInspector(featureName);
        if (!featureValue.valid()) {
            return null;
        }
        switch (featureValue.type()) {
            case DOUBLE: {
                return Tensor.from((double)featureValue.asDouble());
            }
            case DATA: {
                return TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])featureValue.asData()));
            }
        }
        throw new IllegalStateException("Unexpected feature value type " + featureValue.type());
    }

    private Inspector getInspector(String featureName) {
        Inspector featureValue = this.value.field(featureName);
        if (featureValue.valid()) {
            return featureValue;
        }
        return this.value.field("rankingExpression(" + featureName + ")");
    }

    public Set<String> featureNames() {
        if (this == empty) {
            return Collections.emptySet();
        }
        if (this.featureNames != null) {
            return this.featureNames;
        }
        this.featureNames = new HashSet<String>();
        this.value.fields().forEach(field -> this.featureNames.add((String)field.getKey()));
        return this.featureNames;
    }

    public String toString() {
        if (this.value.type() == Type.EMPTY) {
            return "";
        }
        return this.toJson();
    }

    public int hashCode() {
        return this.toJson().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FeatureData)) {
            return false;
        }
        return ((FeatureData)other).toJson().equals(this.toJson());
    }

    private static class Encoder
    extends JsonRender.StringEncoder {
        Encoder(StringBuilder out, boolean compact) {
            super(out, compact);
        }

        public void encodeDATA(byte[] value) {
            this.target().append(new String(JsonFormat.encodeWithType((Tensor)TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])value))), StandardCharsets.UTF_8));
        }
    }
}

