/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.rewrite;

import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.QueryCanonicalizer;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.prelude.query.parser.CustomParser;
import com.yahoo.prelude.querytransform.PhraseMatcher;
import com.yahoo.search.Query;
import com.yahoo.search.query.Model;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.query.parser.ParserFactory;
import com.yahoo.search.query.rewrite.RewriterUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class RewriterFeatures {
    private static final Logger logger = Logger.getLogger(RewriterFeatures.class.getName());

    public static Query addUnitToOriginalQuery(Query query, String boostingQuery, boolean keepOriginalQuery) throws RuntimeException {
        RewriterUtils.log(logger, query, "Adding proximity boosting to [" + boostingQuery + "]");
        Model queryModel = query.getModel();
        QueryTree qTree = queryModel.getQueryTree();
        Item oldRoot = qTree.getRoot();
        if (oldRoot == null) {
            RewriterUtils.error(logger, query, "Error retrieving query tree root");
            throw new RuntimeException("Error retrieving query tree root");
        }
        Item origQueryItem = RewriterFeatures.convertStringToQTree(query, boostingQuery);
        if (oldRoot instanceof AndItem && oldRoot.equals(origQueryItem)) {
            PhraseItem phrase = RewriterFeatures.convertAndToPhrase((AndItem)oldRoot);
            if (!keepOriginalQuery) {
                qTree.setRoot(phrase);
            } else {
                OrItem newRoot = new OrItem();
                newRoot.addItem(oldRoot);
                newRoot.addItem(phrase);
                qTree.setRoot(newRoot);
                queryModel.setType(Query.Type.ADVANCED);
            }
            RewriterUtils.log(logger, query, "Added proximity boosting successfully");
            return query;
        }
        if (oldRoot instanceof OrItem && ((OrItem)oldRoot).getItemIndex(origQueryItem) != -1 && origQueryItem instanceof AndItem) {
            PhraseItem pI;
            if (!keepOriginalQuery) {
                ((OrItem)oldRoot).removeItem(origQueryItem);
            }
            if (((OrItem)oldRoot).getItemIndex(pI = RewriterFeatures.convertAndToPhrase((AndItem)origQueryItem)) == -1) {
                ((OrItem)oldRoot).addItem(RewriterFeatures.convertAndToPhrase((AndItem)origQueryItem));
                RewriterUtils.log(logger, query, "Added proximity boosting successfully");
                return query;
            }
        }
        RewriterUtils.log(logger, query, "No proximity boosting added");
        return query;
    }

    public static Query addRewritesAsEquiv(Query query, String matchingStr, String rewrites, boolean addUnitToRewrites, int maxNumRewrites) throws RuntimeException {
        OrItem newRoot;
        String normalizedQuery = RewriterUtils.getNormalizedOriginalQuery(query);
        RewriterUtils.log(logger, query, "Adding rewrites [" + rewrites + "] to the query [" + normalizedQuery + "]");
        if (rewrites.equalsIgnoreCase(normalizedQuery) || rewrites.equalsIgnoreCase("n/a")) {
            RewriterUtils.log(logger, query, "No rewrite added");
            return query;
        }
        Model queryModel = query.getModel();
        QueryTree qTree = queryModel.getQueryTree();
        Item oldRoot = qTree.getRoot();
        if (oldRoot == null) {
            RewriterUtils.error(logger, query, "Error retrieving query tree root");
            throw new RuntimeException("Error retrieving query tree root");
        }
        StringTokenizer rewrite_list = new StringTokenizer(rewrites, "\t");
        Item rI = null;
        Item matchingStrItem = RewriterFeatures.convertStringToQTree(query, matchingStr);
        PhraseItem matchingStrPhraseItem = null;
        if (matchingStrItem instanceof AndItem) {
            matchingStrPhraseItem = RewriterFeatures.convertAndToPhrase((AndItem)matchingStrItem);
        }
        if (oldRoot instanceof OrItem) {
            if (((OrItem)oldRoot).getItemIndex(matchingStrItem) == -1) {
                RewriterUtils.log(logger, query, "Whole query matching is used, skipping rewrite");
                return query;
            }
            newRoot = (OrItem)oldRoot;
        } else if (oldRoot.equals(matchingStrItem) || oldRoot.equals(matchingStrPhraseItem)) {
            newRoot = new OrItem();
            newRoot.addItem(oldRoot);
        } else {
            RewriterUtils.log(logger, query, "Whole query matching is used, skipping rewrite");
            return query;
        }
        int numRewrites = 0;
        while (rewrite_list.hasMoreTokens() && (maxNumRewrites == 0 || numRewrites < maxNumRewrites)) {
            rI = RewriterFeatures.convertStringToQTree(query, rewrite_list.nextToken());
            if (addUnitToRewrites && rI instanceof AndItem) {
                rI = RewriterFeatures.convertAndToPhrase((AndItem)rI);
            }
            if (newRoot.getItemIndex(rI) == -1) {
                newRoot.addItem(rI);
                ++numRewrites;
                continue;
            }
            RewriterUtils.log(logger, query, "Rewrite already exist, skipping");
        }
        qTree.setRoot(newRoot);
        queryModel.setType(Query.Type.ADVANCED);
        RewriterUtils.log(logger, query, "Added rewrite successfully");
        return query;
    }

    public static Set<PhraseMatcher.Phrase> getNonOverlappingFullPhraseMatches(PhraseMatcher phraseMatcher, Query query) throws RuntimeException {
        RewriterUtils.log(logger, query, "Retrieving longest non-overlapping full phrase matches");
        if (phraseMatcher == null) {
            return null;
        }
        Item root = query.getModel().getQueryTree().getRoot();
        List<PhraseMatcher.Phrase> matches = phraseMatcher.matchPhrases(root);
        if (matches == null || matches.isEmpty()) {
            return null;
        }
        HashSet<PhraseMatcher.Phrase> resultMatches = new HashSet<PhraseMatcher.Phrase>();
        ListIterator<PhraseMatcher.Phrase> matchesIter = matches.listIterator();
        while (matchesIter.hasNext()) {
            PhraseMatcher.Phrase phrase = matchesIter.next();
            RewriterUtils.log(logger, query, "Working on phrase: " + phrase);
            CompositeItem currOwner = phrase.getOwner();
            if (!(currOwner != null && (phrase.isComplete() && currOwner instanceof AndItem || phrase.getLength() == 1 && currOwner instanceof OrItem || phrase.getLength() == 1 && currOwner instanceof RankItem && phrase.getStartIndex() == 0)) && (currOwner != null || phrase.getLength() != 1)) continue;
            resultMatches.add(phrase);
            RewriterUtils.log(logger, query, "Keeping phrase: " + phrase);
        }
        RewriterUtils.log(logger, query, "Successfully Retrieved longest non-overlapping full phrase matches");
        return resultMatches;
    }

    public static Set<PhraseMatcher.Phrase> getNonOverlappingPartialPhraseMatches(PhraseMatcher phraseMatcher, Query query) throws RuntimeException {
        RewriterUtils.log(logger, query, "Retrieving longest non-overlapping partial phrase matches");
        if (phraseMatcher == null) {
            return null;
        }
        Item root = query.getModel().getQueryTree().getRoot();
        List<PhraseMatcher.Phrase> matches = phraseMatcher.matchPhrases(root);
        if (matches == null || matches.isEmpty()) {
            return null;
        }
        HashSet<PhraseMatcher.Phrase> resultMatches = new HashSet<PhraseMatcher.Phrase>();
        ArrayList<PhraseMatcher.Phrase> phrasesInSubTree = new ArrayList<PhraseMatcher.Phrase>();
        CompositeItem prevOwner = null;
        ListIterator<PhraseMatcher.Phrase> matchesIter = matches.listIterator();
        while (matchesIter.hasNext()) {
            PhraseMatcher.Phrase phrase = matchesIter.next();
            RewriterUtils.log(logger, query, "Working on phrase: " + phrase);
            CompositeItem currOwner = phrase.getOwner();
            if (!phrasesInSubTree.isEmpty() && currOwner != null && prevOwner != null && !currOwner.equals(prevOwner)) {
                RewriterUtils.log(logger, query, "Previous phrase is in different AND item");
                List<PhraseMatcher.Phrase> subTreeMatches = RewriterFeatures.getNonOverlappingMatchesInAndItem(phrasesInSubTree, query);
                if (subTreeMatches == null) {
                    RewriterUtils.error(logger, query, "Error retrieving matches from subtree");
                    throw new RuntimeException("Error retrieving matches from subtree");
                }
                resultMatches.addAll(subTreeMatches);
                phrasesInSubTree.clear();
            }
            if (currOwner != null && currOwner instanceof AndItem) {
                phrasesInSubTree.add(phrase);
            } else if (!(phrase.getLength() != 1 || currOwner != null && currOwner instanceof RankItem && phrase.getStartIndex() != 0)) {
                resultMatches.add(phrase);
            }
            prevOwner = currOwner;
        }
        if (!phrasesInSubTree.isEmpty()) {
            RewriterUtils.log(logger, query, "Last phrase is in AND item");
            List<PhraseMatcher.Phrase> subTreeMatches = RewriterFeatures.getNonOverlappingMatchesInAndItem(phrasesInSubTree, query);
            if (subTreeMatches == null) {
                RewriterUtils.error(logger, query, "Error retrieving matches from subtree");
                throw new RuntimeException("Error retrieving matches from subtree");
            }
            resultMatches.addAll(subTreeMatches);
        }
        RewriterUtils.log(logger, query, "Successfully Retrieved longest non-overlapping partial phrase matches");
        return resultMatches;
    }

    public static List<PhraseMatcher.Phrase> getNonOverlappingMatchesInAndItem(List<PhraseMatcher.Phrase> allMatches, Query query) throws RuntimeException {
        RewriterUtils.log(logger, query, "Retrieving longest non-overlapping matches in subtree");
        if (allMatches == null || allMatches.isEmpty()) {
            return null;
        }
        if (allMatches.size() == 1) {
            RewriterUtils.log(logger, query, "Only one match in subtree");
            return allMatches;
        }
        RewriterUtils.log(logger, query, "Sorting the phrases");
        PhraseLength phraseLength = new PhraseLength();
        Collections.sort(allMatches, phraseLength);
        int numWords = allMatches.get(0).getOwner().getItemCount();
        BitSet matchPos = new BitSet(numWords);
        RewriterUtils.log(logger, query, "Removing matches that are overlapping with previously selected ones");
        ListIterator<PhraseMatcher.Phrase> allMatchesIter = allMatches.listIterator();
        while (allMatchesIter.hasNext()) {
            PhraseMatcher.Phrase currMatch = allMatchesIter.next();
            PhraseMatcher.Phrase.MatchIterator matchIter = currMatch.itemIterator();
            if (matchIter.hasNext() && matchIter.next().isFilter()) {
                RewriterUtils.log(logger, query, "Removing filter item" + currMatch);
                allMatchesIter.remove();
                continue;
            }
            BitSet currMatchPos = new BitSet(numWords);
            currMatchPos.set(currMatch.getStartIndex(), currMatch.getLength() + currMatch.getStartIndex());
            if (currMatchPos.intersects(matchPos)) {
                RewriterUtils.log(logger, query, "Removing " + currMatch);
                allMatchesIter.remove();
                continue;
            }
            RewriterUtils.log(logger, query, "Keeping " + currMatch);
            matchPos.or(currMatchPos);
        }
        return allMatches;
    }

    public static Query addExpansions(Query query, Set<PhraseMatcher.Phrase> matches, String expandIndex, int maxNumRewrites, boolean removeOriginal, boolean addUnitToRewrites) throws RuntimeException {
        String cleanupError;
        if (matches == null) {
            RewriterUtils.log(logger, query, "No expansions to be added");
            return query;
        }
        RewriterUtils.log(logger, query, "Adding expansions to matching phrases");
        Model queryModel = query.getModel();
        QueryTree qTree = queryModel.getQueryTree();
        Iterator<PhraseMatcher.Phrase> matchesIter = matches.iterator();
        CompositeItem parent = null;
        while (matchesIter.hasNext()) {
            Item matchItem;
            PhraseMatcher.Phrase match = matchesIter.next();
            RewriterUtils.log(logger, query, "Working on phrase: " + match);
            String expansionStr = match.getData();
            if (expansionStr.equalsIgnoreCase("n/a") && expandIndex == null) continue;
            StringTokenizer expansions = new StringTokenizer(expansionStr, "\t");
            OrItem expansionGrp = new OrItem();
            String matchStr = RewriterFeatures.convertMatchToString(match);
            for (int numRewrites = 0; expansions.hasMoreTokens() && (maxNumRewrites == 0 || numRewrites < maxNumRewrites); ++numRewrites) {
                String expansion = expansions.nextToken();
                RewriterUtils.log(logger, query, "Working on expansion: " + expansion);
                if (expansion.equalsIgnoreCase("n/a")) {
                    expansion = matchStr;
                }
                Item expansionItem = RewriterFeatures.convertStringToQTree(query, expansion);
                if (addUnitToRewrites && expansionItem instanceof AndItem) {
                    expansionItem = RewriterFeatures.convertAndToPhrase((AndItem)expansionItem);
                }
                expansionGrp.addItem(expansionItem);
                if (expandIndex != null) {
                    WordItem expansionIndexItem = new WordItem(expansion, expandIndex);
                    expansionGrp.addItem(expansionIndexItem);
                }
                RewriterUtils.log(logger, query, "Adding expansion: " + expansion);
            }
            if (!removeOriginal && expansionGrp.getItemIndex(matchItem = RewriterFeatures.convertStringToQTree(query, matchStr)) == -1) {
                expansionGrp.addItem(matchItem);
            }
            parent = match.getOwner();
            int matchIndex = match.getStartIndex();
            if (parent != null) {
                for (int i = 0; i < match.getLength(); ++i) {
                    parent.removeItem(matchIndex);
                }
                parent.addItem(matchIndex, expansionGrp);
                continue;
            }
            RewriterUtils.log(logger, query, "Single root item");
            qTree.setRoot(expansionGrp);
            break;
        }
        if (parent != null && (cleanupError = QueryCanonicalizer.canonicalize(qTree)) != null) {
            RewriterUtils.error(logger, query, "Error canonicalizing query tree");
            throw new RuntimeException("Error canonicalizing query tree");
        }
        queryModel.setType(Query.Type.ADVANCED);
        RewriterUtils.log(logger, query, "Successfully added expansions to matching phrases");
        return query;
    }

    public static String convertMatchToString(PhraseMatcher.Phrase phrase) {
        StringBuilder buffer = new StringBuilder();
        PhraseMatcher.Phrase.MatchIterator i = phrase.itemIterator();
        while (i.hasNext()) {
            buffer.append(((Item)i.next()).toString());
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        return buffer.toString();
    }

    static Item convertStringToQTree(Query query, String stringToParse) {
        RewriterUtils.log(logger, query, "Converting string [" + stringToParse + "] to query tree");
        if (stringToParse == null) {
            return new NullItem();
        }
        Model model = query.getModel();
        CustomParser parser = (CustomParser)ParserFactory.newInstance(model.getType(), ParserEnvironment.fromExecutionContext(query.getModel().getExecution().context()));
        IndexFacts indexFacts = new IndexFacts();
        Item item = parser.parse(stringToParse, null, model.getParsingLanguage(), indexFacts.newSession(model.getSources(), model.getRestrict()), model.getDefaultIndex());
        RewriterUtils.log(logger, query, "Converted string: [" + item.toString() + "]");
        return item;
    }

    private static PhraseItem convertAndToPhrase(AndItem andItem) {
        PhraseItem result = new PhraseItem();
        ListIterator<Item> subItems = andItem.getItemIterator();
        while (subItems.hasNext()) {
            Item curr = (Item)subItems.next();
            if (curr instanceof IntItem) {
                WordItem numItem = new WordItem(((IntItem)curr).stringValue());
                result.addItem(numItem);
                continue;
            }
            result.addItem(curr);
        }
        return result;
    }

    private static class PhraseLength
    implements Comparator<PhraseMatcher.Phrase> {
        private PhraseLength() {
        }

        @Override
        public int compare(PhraseMatcher.Phrase phrase1, PhraseMatcher.Phrase phrase2) {
            if (phrase2.getLength() > phrase1.getLength() || phrase2.getLength() == phrase1.getLength() && phrase2.getStartIndex() <= phrase1.getStartIndex()) {
                return 1;
            }
            return -1;
        }
    }
}

