/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.RankProperties;
import java.util.Objects;

public class Diversity
implements Cloneable {
    private static final QueryProfileType argumentType = new QueryProfileType("diversity");
    public static final String ATTRIBUTE = "attribute";
    public static final String MINGROUPS = "minGroups";
    public static final String CUTOFF = "cutoff";
    public static final String FACTOR = "factor";
    public static final String STRATEGY = "strategy";
    private String attribute = null;
    private Long minGroups = null;
    private Double cutoffFactor = null;
    private CutoffStrategy cutoffStrategy = null;

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setMinGroups(long minGroups) {
        this.minGroups = minGroups;
    }

    public Long getMinGroups() {
        return this.minGroups;
    }

    public void setCutoffFactor(double cutoffFactor) {
        this.cutoffFactor = cutoffFactor;
    }

    public Double getCutoffFactor() {
        return this.cutoffFactor;
    }

    public void setCutoffStrategy(String cutoffStrategy) {
        this.cutoffStrategy = CutoffStrategy.valueOf(cutoffStrategy);
    }

    public CutoffStrategy getCutoffStrategy() {
        return this.cutoffStrategy;
    }

    public void prepare(RankProperties rankProperties) {
        if (this.attribute == null && this.minGroups == null) {
            return;
        }
        if (this.attribute != null && !this.attribute.isEmpty()) {
            rankProperties.put("vespa.matchphase.diversity.attribute", this.attribute);
        }
        if (this.minGroups != null) {
            rankProperties.put("vespa.matchphase.diversity.mingroups", String.valueOf(this.minGroups));
        }
        if (this.cutoffFactor != null) {
            rankProperties.put("vespa.matchphase.diversity.cutoff.factor", String.valueOf(this.cutoffFactor));
        }
        if (this.cutoffStrategy != null) {
            rankProperties.put("vespa.matchphase.diversity.cutoff.strategy", (Object)this.cutoffStrategy);
        }
    }

    public Diversity clone() {
        try {
            return (Diversity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen", e);
        }
    }

    public int hashCode() {
        int hash = 0;
        if (this.attribute != null) {
            hash += 11 * this.attribute.hashCode();
        }
        if (this.minGroups != null) {
            hash += 13 * this.minGroups.hashCode();
        }
        if (this.cutoffFactor != null) {
            hash += 17 * this.cutoffFactor.hashCode();
        }
        if (this.cutoffStrategy != null) {
            hash += 19 * this.cutoffStrategy.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Diversity)) {
            return false;
        }
        Diversity other = (Diversity)o;
        if (!Objects.equals(this.attribute, other.attribute)) {
            return false;
        }
        if (!Objects.equals(this.minGroups, other.minGroups)) {
            return false;
        }
        if (!Objects.equals(this.cutoffFactor, other.cutoffFactor)) {
            return false;
        }
        return Objects.equals((Object)this.cutoffStrategy, (Object)other.cutoffStrategy);
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(ATTRIBUTE, "string"));
        argumentType.addField(new FieldDescription(MINGROUPS, "long"));
        argumentType.freeze();
    }

    public static enum CutoffStrategy {
        loose,
        strict;

    }
}

