/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.protect.Validator;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.OverridableQueryProfile;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BackedOverridableQueryProfile
extends OverridableQueryProfile
implements Cloneable {
    private final QueryProfile backingProfile;

    public BackedOverridableQueryProfile(QueryProfile backingProfile) {
        Validator.ensureNotNull((String)"An overridable query profile must be backed by a real query profile", (Object)backingProfile);
        this.setType(backingProfile.getType());
        this.backingProfile = backingProfile;
    }

    @Override
    public String getSource() {
        return this.backingProfile.getSource();
    }

    @Override
    public synchronized void freeze() {
        super.freeze();
        this.backingProfile.freeze();
    }

    @Override
    protected Object localLookup(String localName, DimensionBinding dimensionBinding) {
        Object valueInThis = super.localLookup(localName, dimensionBinding);
        if (valueInThis != null) {
            return valueInThis;
        }
        return this.backingProfile.localLookup(localName, dimensionBinding);
    }

    @Override
    protected Boolean isLocalInstanceOverridable(String localName) {
        Boolean valueInThis = super.isLocalInstanceOverridable(localName);
        if (valueInThis != null) {
            return valueInThis;
        }
        return this.backingProfile.isLocalInstanceOverridable(localName);
    }

    @Override
    protected QueryProfile createSubProfile(String name, DimensionBinding dimensionBinding) {
        Object backing = this.backingProfile.lookup(new CompoundName(name), true, dimensionBinding.createFor(this.backingProfile.getDimensions()));
        if (backing instanceof QueryProfile) {
            return new BackedOverridableQueryProfile((QueryProfile)backing);
        }
        return new OverridableQueryProfile();
    }

    @Override
    public BackedOverridableQueryProfile clone() {
        return (BackedOverridableQueryProfile)super.clone();
    }

    public QueryProfile getBacking() {
        return this.backingProfile;
    }

    @Override
    public void addInherited(QueryProfile inherited) {
        this.backingProfile.addInherited(inherited);
    }

    void addInheritedHere(QueryProfile inherited) {
        super.addInherited(inherited);
    }

    @Override
    protected void visitVariants(boolean allowContent, QueryProfileVisitor visitor, DimensionBinding dimensionBinding) {
        super.visitVariants(allowContent, visitor, dimensionBinding);
        if (visitor.isDone()) {
            return;
        }
        this.backingProfile.visitVariants(allowContent, visitor, dimensionBinding);
    }

    @Override
    protected void visitInherited(boolean allowContent, QueryProfileVisitor visitor, DimensionBinding dimensionBinding, QueryProfile owner) {
        super.visitInherited(allowContent, visitor, dimensionBinding, owner);
        if (visitor.isDone()) {
            return;
        }
        this.backingProfile.visitInherited(allowContent, visitor, dimensionBinding, owner);
    }

    @Override
    protected Object getContent(String localKey) {
        Object value = super.getContent(localKey);
        if (value != null) {
            return value;
        }
        return this.backingProfile.getContent(localKey);
    }

    @Override
    protected Map<String, Object> getContent() {
        Map<String, Object> thisContent = super.getContent();
        Map<String, Object> backingContent = this.backingProfile.getContent();
        if (thisContent.isEmpty()) {
            return backingContent;
        }
        if (backingContent.isEmpty()) {
            return thisContent;
        }
        HashMap<String, Object> content = new HashMap<String, Object>(backingContent);
        content.putAll(thisContent);
        return content;
    }

    @Override
    public String toString() {
        return "overridable wrapper of " + this.backingProfile;
    }

    @Override
    public boolean isExplicit() {
        return this.backingProfile.isExplicit();
    }

    @Override
    public List<String> getDimensions() {
        List<String> dimensions = super.getDimensions();
        if (dimensions != null) {
            return dimensions;
        }
        return this.backingProfile.getDimensions();
    }
}

