/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.handler;

import com.google.inject.Inject;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.Vtag;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.container.core.ContainerHttpConfig;
import com.yahoo.container.handler.Coverage;
import com.yahoo.container.handler.Timing;
import com.yahoo.container.handler.threadpool.ContainerThreadPool;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.jdisc.VespaHeaders;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.container.logging.HitCounts;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.language.Linguistics;
import com.yahoo.net.HostName;
import com.yahoo.net.UriTools;
import com.yahoo.prelude.query.parser.ParseException;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.handler.HttpSearchResponse;
import com.yahoo.search.handler.SearchResponse;
import com.yahoo.search.query.context.QueryContext;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfile;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileConfigurer;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.search.query.properties.DefaultProperties;
import com.yahoo.search.query.ranking.SoftTimeout;
import com.yahoo.search.rendering.Renderer;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.ExecutionFactory;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.search.statistics.ElapsedTime;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.statistics.Callback;
import com.yahoo.statistics.Handle;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;
import com.yahoo.text.Lowercase;
import com.yahoo.vespa.configdefinition.SpecialtokensConfig;
import com.yahoo.yolean.Exceptions;
import com.yahoo.yolean.trace.TraceNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchHandler
extends LoggingRequestHandler {
    private static final Logger log = Logger.getLogger(SearchHandler.class.getName());
    private final AtomicInteger requestsInFlight = new AtomicInteger(0);
    private final int maxThreads;
    private static final CompoundName DETAILED_TIMING_LOGGING = new CompoundName("trace.timingDetails");
    private static final CompoundName FORCE_TIMESTAMPS = new CompoundName("trace.timestamps");
    private static final String SEARCH_CONNECTIONS = "search_connections";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final Value searchConnections;
    public static final String defaultSearchChainName = "default";
    private static final String fallbackSearchChain = "vespa";
    private final CompiledQueryProfileRegistry queryProfileRegistry;
    private final Optional<String> hostResponseHeaderKey;
    private final String selfHostname = HostName.getLocalhost();
    private final ExecutionFactory executionFactory;
    private final AtomicLong numRequestsLeftToTrace;

    @Inject
    public SearchHandler(Statistics statistics, Metric metric, ContainerThreadPool threadpool, AccessLog ignored, CompiledQueryProfileRegistry queryProfileRegistry, ContainerHttpConfig config, ExecutionFactory executionFactory) {
        this(statistics, metric, threadpool.executor(), ignored, queryProfileRegistry, config, executionFactory);
    }

    public SearchHandler(Statistics statistics, Metric metric, Executor executor, AccessLog ignored, CompiledQueryProfileRegistry queryProfileRegistry, ContainerHttpConfig containerHttpConfig, ExecutionFactory executionFactory) {
        this(statistics, metric, executor, queryProfileRegistry, executionFactory, containerHttpConfig.numQueriesToTraceOnDebugAfterConstruction(), containerHttpConfig.hostResponseHeaderKey().equals("") ? Optional.empty() : Optional.of(containerHttpConfig.hostResponseHeaderKey()));
    }

    @Deprecated
    public SearchHandler(Statistics statistics, Metric metric, Executor executor, AccessLog ignored, QueryProfilesConfig queryProfileConfig, ContainerHttpConfig containerHttpConfig, ExecutionFactory executionFactory) {
        this(statistics, metric, executor, QueryProfileConfigurer.createFromConfig(queryProfileConfig).compile(), executionFactory, containerHttpConfig.numQueriesToTraceOnDebugAfterConstruction(), containerHttpConfig.hostResponseHeaderKey().equals("") ? Optional.empty() : Optional.of(containerHttpConfig.hostResponseHeaderKey()));
    }

    public SearchHandler(Statistics statistics, Metric metric, Executor executor, AccessLog ignored, CompiledQueryProfileRegistry queryProfileRegistry, ExecutionFactory executionFactory, Optional<String> hostResponseHeaderKey) {
        this(statistics, metric, executor, queryProfileRegistry, executionFactory, 0L, hostResponseHeaderKey);
    }

    private SearchHandler(Statistics statistics, Metric metric, Executor executor, CompiledQueryProfileRegistry queryProfileRegistry, ExecutionFactory executionFactory, long numQueriesToTraceOnDebugAfterStartup, Optional<String> hostResponseHeaderKey) {
        super(executor, metric, true);
        log.log(Level.FINE, "SearchHandler.init " + System.identityHashCode((Object)this));
        this.queryProfileRegistry = queryProfileRegistry;
        this.executionFactory = executionFactory;
        this.maxThreads = SearchHandler.examineExecutor(executor);
        this.searchConnections = new Value(SEARCH_CONNECTIONS, statistics, new Value.Parameters().setLogRaw(Boolean.valueOf(true)).setLogMax(Boolean.valueOf(true)).setLogMean(Boolean.valueOf(true)).setLogMin(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(true)).setCallback((Callback)new MeanConnections()));
        this.hostResponseHeaderKey = hostResponseHeaderKey;
        this.numRequestsLeftToTrace = new AtomicLong(numQueriesToTraceOnDebugAfterStartup);
    }

    @Deprecated
    public SearchHandler(ChainsConfig chainsConfig, IndexInfoConfig indexInfo, QrSearchersConfig clusters, SpecialtokensConfig specialtokens, Statistics statistics, Linguistics linguistics, Metric metric, ComponentRegistry<com.yahoo.processing.rendering.Renderer> renderers, Executor executor, AccessLog accessLog, QueryProfilesConfig queryProfileConfig, ComponentRegistry<Searcher> searchers, ContainerHttpConfig containerHttpConfig) {
        this(statistics, metric, executor, accessLog, queryProfileConfig, containerHttpConfig, new ExecutionFactory(chainsConfig, indexInfo, clusters, searchers, specialtokens, linguistics, renderers));
    }

    private static int examineExecutor(Executor executor) {
        if (executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executor).getMaximumPoolSize();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpResponse handle(HttpRequest request) {
        this.requestsInFlight.incrementAndGet();
        try {
            HttpSearchResponse httpSearchResponse = this.handleBody(request);
            return httpSearchResponse;
        }
        catch (IllegalInputException e) {
            HttpResponse httpResponse = this.illegalQueryResponse(request, (RuntimeException)((Object)e));
            return httpResponse;
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Failed handling " + request, e);
            HttpResponse httpResponse = this.internalServerErrorResponse(request, e);
            return httpResponse;
        }
        finally {
            this.requestsInFlight.decrementAndGet();
        }
    }

    public Optional<Request.RequestType> getRequestType() {
        return Optional.of(Request.RequestType.READ);
    }

    private int getHttpResponseStatus(HttpRequest httpRequest, Result result) {
        boolean benchmarkOutput = VespaHeaders.benchmarkOutput((HttpRequest)httpRequest);
        if (benchmarkOutput) {
            return VespaHeaders.getEagerErrorStatus((ErrorMessage)result.hits().getError(), SearchResponse.getErrorIterator(result.hits().getErrorHit()));
        }
        return VespaHeaders.getStatus((boolean)SearchResponse.isSuccess(result), (ErrorMessage)result.hits().getError(), SearchResponse.getErrorIterator(result.hits().getErrorHit()));
    }

    private HttpResponse errorResponse(HttpRequest request, com.yahoo.search.result.ErrorMessage errorMessage) {
        Query query = new Query();
        Result result = new Result(query, errorMessage);
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.getRendererCopy(ComponentSpecification.fromString((String)request.getProperty("format")));
        return new HttpSearchResponse(this.getHttpResponseStatus(request, result), result, query, renderer);
    }

    private HttpResponse illegalQueryResponse(HttpRequest request, RuntimeException e) {
        return this.errorResponse(request, com.yahoo.search.result.ErrorMessage.createIllegalQuery(Exceptions.toMessageString((Throwable)e)));
    }

    private HttpResponse internalServerErrorResponse(HttpRequest request, RuntimeException e) {
        return this.errorResponse(request, com.yahoo.search.result.ErrorMessage.createInternalServerError(Exceptions.toMessageString((Throwable)e)));
    }

    private HttpSearchResponse handleBody(HttpRequest request) {
        Result result;
        Map<String, String> requestMap = this.requestMapFromRequest(request);
        String queryProfileName = requestMap.getOrDefault("queryProfile", null);
        CompiledQueryProfile queryProfile = this.queryProfileRegistry.findQueryProfile(queryProfileName);
        Query query = new Query(request, requestMap, queryProfile);
        boolean benchmarking = VespaHeaders.benchmarkOutput((HttpRequest)request);
        boolean benchmarkCoverage = VespaHeaders.benchmarkCoverage((boolean)benchmarking, (HeaderFields)request.getJDiscRequest().headers());
        if (benchmarking && !request.hasProperty(SoftTimeout.enableProperty.toString())) {
            query.properties().set(SoftTimeout.enableProperty, false);
        }
        String invalidReason = query.validate();
        Chain searchChain = null;
        String searchChainName = null;
        if (invalidReason == null) {
            Tuple2<String, Chain<Searcher>> nameAndChain = this.resolveChain(query.properties().getString(Query.SEARCH_CHAIN));
            searchChainName = (String)nameAndChain.first;
            searchChain = (Chain)nameAndChain.second;
        }
        if (invalidReason != null) {
            result = new Result(query, com.yahoo.search.result.ErrorMessage.createIllegalQuery(invalidReason));
        } else if (queryProfile == null && queryProfileName != null) {
            result = new Result(query, com.yahoo.search.result.ErrorMessage.createIllegalQuery("Could not resolve query profile '" + queryProfileName + "'"));
        } else if (searchChain == null) {
            result = new Result(query, com.yahoo.search.result.ErrorMessage.createInvalidQueryParameter("No search chain named '" + searchChainName + "' was found"));
        } else {
            String pathAndQuery = UriTools.rawRequest((URI)request.getUri());
            result = this.search(pathAndQuery, query, (Chain<Searcher>)searchChain);
        }
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.toRendererCopy(query.getPresentation().getRenderer());
        HttpSearchResponse response = new HttpSearchResponse(this.getHttpResponseStatus(request, result), result, query, renderer, SearchHandler.extractTraceNode(query));
        response.setRequestType(Request.RequestType.READ);
        this.hostResponseHeaderKey.ifPresent(key -> response.headers().add(key, this.selfHostname));
        if (benchmarking) {
            VespaHeaders.benchmarkOutput((HeaderFields)response.headers(), (boolean)benchmarkCoverage, (Timing)response.getTiming(), (HitCounts)response.getHitCounts(), (int)SearchHandler.getErrors(result), (Coverage)response.getCoverage());
        }
        return response;
    }

    private static TraceNode extractTraceNode(Query query) {
        Execution.Trace trace;
        QueryContext queryContext;
        if (log.isLoggable(Level.FINE) && (queryContext = query.getContext(false)) != null && (trace = queryContext.getTrace()) != null) {
            return trace.traceNode();
        }
        return null;
    }

    private static int getErrors(Result result) {
        return result.hits().getErrorHit() == null ? 0 : 1;
    }

    private com.yahoo.processing.rendering.Renderer<Result> toRendererCopy(ComponentSpecification format) {
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.executionFactory.rendererRegistry().getRenderer(format);
        renderer = this.perRenderingCopy(renderer);
        return renderer;
    }

    private Tuple2<String, Chain<Searcher>> resolveChain(String explicitChainName) {
        Chain<Searcher> searchChain;
        String chainName = explicitChainName;
        if (chainName == null) {
            chainName = defaultSearchChainName;
        }
        if ((searchChain = this.executionFactory.searchChainRegistry().getChain(chainName)) == null && explicitChainName == null) {
            chainName = fallbackSearchChain;
            searchChain = this.executionFactory.searchChainRegistry().getChain(chainName);
        }
        return new Tuple2((Object)chainName, searchChain);
    }

    public Result searchAndFill(Query query, Chain<? extends Searcher> searchChain) {
        Result errorResult = this.validateQuery(query);
        if (errorResult != null) {
            return errorResult;
        }
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.executionFactory.rendererRegistry().getRenderer(query.getPresentation().getRenderer());
        if (query.getPresentation().getSummary() == null && renderer instanceof Renderer) {
            query.getPresentation().setSummary(((Renderer)renderer).getDefaultSummaryClass());
        }
        Execution execution = this.executionFactory.newExecution(searchChain);
        query.getModel().setExecution(execution);
        if (log.isLoggable(Level.FINE) && this.numRequestsLeftToTrace.getAndDecrement() > 0L) {
            query.setTraceLevel(Math.max(1, query.getTraceLevel()));
            execution.trace().setForceTimestamps(true);
        } else {
            execution.trace().setForceTimestamps(query.properties().getBoolean(FORCE_TIMESTAMPS, false));
        }
        if (query.properties().getBoolean(DETAILED_TIMING_LOGGING, false)) {
            execution.context().setDetailedDiagnostics(true);
        }
        Result result = execution.search(query);
        this.ensureQuerySet(result, query);
        execution.fill(result, result.getQuery().getPresentation().getSummary());
        this.traceExecutionTimes(query, result);
        this.traceVespaVersion(query);
        this.traceRequestAttributes(query);
        return result;
    }

    private void traceRequestAttributes(Query query) {
        int miminumTraceLevel = 7;
        if (query.getTraceLevel() >= 7) {
            query.trace("Request attributes: " + query.getHttpRequest().getJDiscRequest().context(), miminumTraceLevel);
        }
    }

    public com.yahoo.processing.rendering.Renderer<Result> getRendererCopy(ComponentSpecification spec) {
        com.yahoo.processing.rendering.Renderer<Result> renderer = this.executionFactory.rendererRegistry().getRenderer(spec);
        return this.perRenderingCopy(renderer);
    }

    private com.yahoo.processing.rendering.Renderer<Result> perRenderingCopy(com.yahoo.processing.rendering.Renderer<Result> renderer) {
        com.yahoo.processing.rendering.Renderer copy = renderer.clone();
        copy.init();
        return copy;
    }

    private void ensureQuerySet(Result result, Query fallbackQuery) {
        Query query = result.getQuery();
        if (query == null) {
            result.setQuery(fallbackQuery);
        }
    }

    private Result search(String request, Query query, Chain<Searcher> searchChain) {
        if (query.getTraceLevel() >= 2) {
            query.trace("Invoking " + searchChain, false, 2);
        }
        if (this.searchConnections != null) {
            this.connectionStatistics();
        } else {
            log.log(Level.WARNING, "searchConnections is a null reference, probably a known race condition during startup.", new IllegalStateException("searchConnections reference is null."));
        }
        try {
            return this.searchAndFill(query, searchChain);
        }
        catch (ParseException e) {
            com.yahoo.search.result.ErrorMessage error = com.yahoo.search.result.ErrorMessage.createIllegalQuery("Could not parse query [" + request + "]: " + Exceptions.toMessageString((Throwable)e));
            log.log(Level.FINE, () -> ((com.yahoo.search.result.ErrorMessage)error).getDetailedMessage());
            return new Result(query, error);
        }
        catch (IllegalInputException e) {
            com.yahoo.search.result.ErrorMessage error = com.yahoo.search.result.ErrorMessage.createBadRequest("Invalid request [" + request + "]: " + Exceptions.toMessageString((Throwable)e));
            log.log(Level.FINE, () -> ((com.yahoo.search.result.ErrorMessage)error).getDetailedMessage());
            return new Result(query, error);
        }
        catch (IllegalArgumentException e) {
            this.log(request, query, e);
            return new Result(query, com.yahoo.search.result.ErrorMessage.createUnspecifiedError("Failed: " + Exceptions.toMessageString((Throwable)e), e));
        }
        catch (LinkageError | StackOverflowError e) {
            com.yahoo.search.result.ErrorMessage error = com.yahoo.search.result.ErrorMessage.createErrorInPluginSearcher("Error executing " + searchChain + "]: " + Exceptions.toMessageString((Throwable)e), e);
            this.log(request, query, e);
            return new Result(query, error);
        }
        catch (Exception e) {
            this.log(request, query, e);
            return new Result(query, com.yahoo.search.result.ErrorMessage.createUnspecifiedError("Failed: " + Exceptions.toMessageString((Throwable)e), e));
        }
    }

    private void connectionStatistics() {
        long maxThreadsAsLong;
        long connectionsAsLong;
        int connections = this.requestsInFlight.intValue();
        this.searchConnections.put((double)connections);
        if (this.maxThreads > 3 && (connectionsAsLong = (long)connections) >= (maxThreadsAsLong = (long)this.maxThreads) * 9L / 10L) {
            if (connectionsAsLong == maxThreadsAsLong * 9L / 10L) {
                log.log(Level.WARNING, this.threadConsumptionMessage(connections, this.maxThreads, "90"));
            } else if (connectionsAsLong == maxThreadsAsLong * 95L / 100L) {
                log.log(Level.WARNING, this.threadConsumptionMessage(connections, this.maxThreads, "95"));
            } else if (connectionsAsLong == maxThreadsAsLong) {
                log.log(Level.WARNING, this.threadConsumptionMessage(connections, this.maxThreads, "100"));
            }
        }
    }

    private String threadConsumptionMessage(int connections, int maxThreads, String percentage) {
        return percentage + "% of possible search connections (" + connections + " of maximum " + maxThreads + ") currently active.";
    }

    private void log(String request, Query query, Throwable e) {
        if (e.getStackTrace().length == 0) {
            log.log(Level.SEVERE, "Failed executing " + query.toDetailString() + " [" + request + "], received exception with no context", e);
        } else {
            log.log(Level.SEVERE, "Failed executing " + query.toDetailString() + " [" + request + "]", e);
        }
    }

    private Result validateQuery(Query query) {
        if (query.getHttpRequest().getProperty(DefaultProperties.MAX_HITS.toString()) != null) {
            throw new RuntimeException(DefaultProperties.MAX_HITS + " must be specified in a query profile.");
        }
        if (query.getHttpRequest().getProperty(DefaultProperties.MAX_OFFSET.toString()) != null) {
            throw new RuntimeException(DefaultProperties.MAX_OFFSET + " must be specified in a query profile.");
        }
        int maxHits = query.properties().getInteger(DefaultProperties.MAX_HITS);
        int maxOffset = query.properties().getInteger(DefaultProperties.MAX_OFFSET);
        if (query.getHits() > maxHits) {
            return new Result(query, com.yahoo.search.result.ErrorMessage.createIllegalQuery(query.getHits() + " hits requested, configured limit: " + maxHits + "."));
        }
        if (query.getOffset() > maxOffset) {
            return new Result(query, com.yahoo.search.result.ErrorMessage.createIllegalQuery("Offset of " + query.getOffset() + " requested, configured limit: " + maxOffset + "."));
        }
        return null;
    }

    private void traceExecutionTimes(Query query, Result result) {
        if (query.getTraceLevel() < 3) {
            return;
        }
        ElapsedTime elapsedTime = result.getElapsedTime();
        long now = System.currentTimeMillis();
        if (elapsedTime.firstFill() != 0L) {
            query.trace("Query time " + query + ": " + (elapsedTime.firstFill() - elapsedTime.first()) + " ms", false, 3);
            query.trace("Summary fetch time " + query + ": " + (now - elapsedTime.firstFill()) + " ms", false, 3);
        } else {
            query.trace("Total search time " + query + ": " + (now - elapsedTime.first()) + " ms", false, 3);
        }
    }

    private void traceVespaVersion(Query query) {
        query.trace("Vespa version: " + Vtag.currentVersion.toString(), false, 4);
    }

    public SearchChainRegistry getSearchChainRegistry() {
        return this.executionFactory.searchChainRegistry();
    }

    private static String getMediaType(HttpRequest request) {
        String header = request.getHeader("Content-Type");
        if (header == null) {
            return "";
        }
        int semi = header.indexOf(59);
        if (semi != -1) {
            header = header.substring(0, semi);
        }
        return Lowercase.toLowerCase((String)header.trim());
    }

    private Map<String, String> requestMapFromRequest(HttpRequest request) {
        Cursor inspector;
        if (request.getMethod() != HttpRequest.Method.POST || !JSON_CONTENT_TYPE.equals(SearchHandler.getMediaType(request))) {
            return request.propertyMap();
        }
        try {
            byte[] byteArray = IOUtils.readBytes((InputStream)request.getData(), (int)4096);
            inspector = SlimeUtils.jsonToSlime((byte[])byteArray).get();
            if (inspector.field("error_message").valid()) {
                throw new IllegalInputException("Illegal query: " + inspector.field("error_message").asString() + " at: '" + new String(inspector.field("offending_input").asData(), StandardCharsets.UTF_8) + "'");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading POSTed data", e);
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        this.createRequestMapping((Inspector)inspector, requestMap, "");
        requestMap.putAll(request.propertyMap());
        if (requestMap.containsKey("yql") && (requestMap.containsKey("select.where") || requestMap.containsKey("select.grouping"))) {
            throw new IllegalInputException("Illegal query: Query contains both yql and select parameter");
        }
        if (requestMap.containsKey("query") && (requestMap.containsKey("select.where") || requestMap.containsKey("select.grouping"))) {
            throw new IllegalInputException("Illegal query: Query contains both query and select parameter");
        }
        return requestMap;
    }

    public void createRequestMapping(Inspector inspector, Map<String, String> map, String parent) {
        inspector.traverse((key, value) -> {
            String qualifiedKey = parent + key;
            switch (value.type()) {
                case BOOL: {
                    map.put(qualifiedKey, Boolean.toString(value.asBool()));
                    break;
                }
                case DOUBLE: {
                    map.put(qualifiedKey, Double.toString(value.asDouble()));
                    break;
                }
                case LONG: {
                    map.put(qualifiedKey, Long.toString(value.asLong()));
                    break;
                }
                case STRING: {
                    map.put(qualifiedKey, value.asString());
                    break;
                }
                case ARRAY: {
                    map.put(qualifiedKey, value.toString());
                    break;
                }
                case OBJECT: {
                    if (qualifiedKey.equals("select.where") || qualifiedKey.equals("select.grouping")) {
                        map.put(qualifiedKey, value.toString());
                        break;
                    }
                    this.createRequestMapping(value, map, qualifiedKey + ".");
                }
            }
        });
    }

    private final class MeanConnections
    implements Callback {
        private MeanConnections() {
        }

        public void run(Handle h, boolean firstTime) {
            if (firstTime) {
                SearchHandler.this.metric.set(SearchHandler.SEARCH_CONNECTIONS, (Number)0.0, null);
                return;
            }
            Value v = (Value)h;
            SearchHandler.this.metric.set(SearchHandler.SEARCH_CONNECTIONS, (Number)v.getMean(), null);
        }
    }
}

