/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.google.inject.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.grouping.GroupingQueryParser;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.UnavailableAttributeException;
import com.yahoo.search.grouping.request.AttributeMapLookupValue;
import com.yahoo.search.grouping.request.AttributeValue;
import com.yahoo.search.grouping.request.ExpressionVisitor;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.config.search.AttributesConfig;
import java.util.HashMap;

@Before(value={"backend"})
@After(value={"SelectParameterParsing"})
@Provides(value={"GroupingValidated"})
public class GroupingValidator
extends Searcher {
    public static final String GROUPING_VALIDATED = "GroupingValidated";
    public static final CompoundName PARAM_ENABLED = new CompoundName("validate_" + GroupingQueryParser.PARAM_REQUEST);
    private final HashMap<String, AttributesConfig.Attribute> attributes = new HashMap();
    private final String clusterName;
    private final boolean enabled;

    @Inject
    public GroupingValidator(QrSearchersConfig qrsConfig, ClusterConfig clusterConfig, AttributesConfig attributesConfig) {
        int clusterId = clusterConfig.clusterId();
        QrSearchersConfig.Searchcluster.Indexingmode.Enum indexingMode = qrsConfig.searchcluster(clusterId).indexingmode();
        this.enabled = indexingMode != QrSearchersConfig.Searchcluster.Indexingmode.STREAMING;
        this.clusterName = this.enabled ? qrsConfig.searchcluster(clusterId).name() : null;
        for (AttributesConfig.Attribute attr : attributesConfig.attribute()) {
            this.attributes.put(attr.name(), attr);
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        if (this.enabled && query.properties().getBoolean(PARAM_ENABLED, true)) {
            MyVisitor visitor = new MyVisitor();
            for (GroupingRequest req : query.getSelect().getGrouping()) {
                req.getRootOperation().visitExpressions(visitor);
            }
        }
        return execution.search(query);
    }

    private void verifyHasAttribute(String attributeName) {
        if (!this.attributes.containsKey(attributeName)) {
            throw new UnavailableAttributeException(this.clusterName, attributeName);
        }
    }

    private void verifyCompatibleAttributeTypes(String keyAttributeName, String keySourceAttributeName) {
        AttributesConfig.Attribute keyAttribute = this.attributes.get(keyAttributeName);
        AttributesConfig.Attribute keySourceAttribute = this.attributes.get(keySourceAttributeName);
        if (!keySourceAttribute.datatype().equals((Object)keyAttribute.datatype())) {
            throw new IllegalInputException("Grouping request references key source attribute '" + keySourceAttributeName + "' with data type '" + keySourceAttribute.datatype() + "' that is different than data type '" + keyAttribute.datatype() + "' of key attribute '" + keyAttributeName + "'");
        }
        if (!keySourceAttribute.collectiontype().equals((Object)AttributesConfig.Attribute.Collectiontype.Enum.SINGLE)) {
            throw new IllegalInputException("Grouping request references key source attribute '" + keySourceAttributeName + "' which is not of single value type");
        }
    }

    private class MyVisitor
    implements ExpressionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitExpression(GroupingExpression exp) {
            if (exp instanceof AttributeMapLookupValue) {
                AttributeMapLookupValue mapLookup = (AttributeMapLookupValue)exp;
                GroupingValidator.this.verifyHasAttribute(mapLookup.getKeyAttribute());
                GroupingValidator.this.verifyHasAttribute(mapLookup.getValueAttribute());
                if (mapLookup.hasKeySourceAttribute()) {
                    GroupingValidator.this.verifyHasAttribute(mapLookup.getKeySourceAttribute());
                    GroupingValidator.this.verifyCompatibleAttributeTypes(mapLookup.getKeyAttribute(), mapLookup.getKeySourceAttribute());
                }
            } else if (exp instanceof AttributeValue) {
                GroupingValidator.this.verifyHasAttribute(((AttributeValue)exp).getAttributeName());
            }
        }
    }
}

