/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermType;
import com.yahoo.prelude.semantics.engine.Match;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Production;
import com.yahoo.protect.Validator;

public abstract class TermProduction
extends Production {
    private String label = null;
    private TermType termType;

    public TermProduction() {
        this(null, TermType.DEFAULT);
    }

    public TermProduction(String label) {
        this(label, TermType.DEFAULT);
    }

    public TermProduction(TermType termType) {
        this(null, termType);
    }

    public TermProduction(String label, TermType termType) {
        this.label = label;
        this.setTermType(termType);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public TermType getTermType() {
        return this.termType;
    }

    public void setTermType(TermType termType) {
        Validator.ensureNotNull((String)"Type of produced Term", (Object)termType);
        this.termType = termType;
    }

    protected void insertMatch(RuleEvaluation e, Match matched, Item newItem, int offset) {
        newItem.setWeight(this.getWeight());
        int insertPosition = matched.getPosition() + offset;
        if (insertPosition > matched.getParent().getItemCount()) {
            insertPosition = matched.getParent().getItemCount();
        }
        e.insertItem(newItem, matched.getParent(), insertPosition, this.getTermType());
        if (e.getTraceLevel() >= 6) {
            e.trace(6, "Inserted item '" + newItem + "' at position " + insertPosition + " producing " + e.getEvaluation().getQuery().getModel().getQueryTree());
        }
    }

    protected String getLabelString() {
        if (this.label == null) {
            return "";
        }
        return this.label + ":";
    }

    @Override
    public final String toInnerString() {
        if (this.termType == null) {
            return this.toInnerTermString();
        }
        return this.termType.toSign() + this.toInnerTermString();
    }

    protected abstract String toInnerTermString();
}

