/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermType;
import com.yahoo.prelude.semantics.engine.EvaluationException;
import com.yahoo.prelude.semantics.engine.ReferencedMatches;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.TermProduction;
import com.yahoo.protect.Validator;
import java.util.Set;

public class ReferenceTermProduction
extends TermProduction {
    private String reference;

    public ReferenceTermProduction(String reference) {
        this.setReference(reference);
    }

    public ReferenceTermProduction(String reference, TermType termType) {
        super(termType);
        this.setReference(reference);
    }

    public ReferenceTermProduction(String label, String reference) {
        super(label);
        this.setReference(reference);
    }

    public ReferenceTermProduction(String label, String reference, TermType termType) {
        super(label, termType);
        this.setReference(reference);
    }

    public void setReference(String reference) {
        Validator.ensureNotNull((String)"reference name of a produced reference term", (Object)reference);
        this.reference = reference;
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    void addMatchReferences(Set<String> matchReferences) {
        matchReferences.add(this.reference);
    }

    @Override
    public void produce(RuleEvaluation e, int offset) {
        ReferencedMatches referencedMatches = e.getReferencedMatches(this.reference);
        if (referencedMatches == null) {
            throw new EvaluationException("Referred match '" + this.reference + "' not found");
        }
        if (this.replacing) {
            this.replaceMatches(e, referencedMatches);
        } else {
            this.addMatches(e, referencedMatches);
        }
    }

    public void replaceMatches(RuleEvaluation e, ReferencedMatches referencedMatches) {
        Item referencedItem = referencedMatches.toItem(this.getLabel());
        if (referencedItem == null) {
            return;
        }
        e.removeMatches(referencedMatches);
        this.insertMatch(e, referencedMatches.matchIterator().next(), referencedItem, 0);
    }

    private void addMatches(RuleEvaluation e, ReferencedMatches referencedMatches) {
        Item referencedItem = referencedMatches.toItem(this.getLabel());
        if (referencedItem == null) {
            return;
        }
        e.addItem(referencedItem, this.getTermType());
    }

    @Override
    public String toInnerTermString() {
        return this.getLabelString() + "[" + this.reference + "]";
    }
}

