/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.language.Language;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PhraseSegmentItem;
import com.yahoo.prelude.query.SegmentItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.searchchain.Execution;
import java.util.ListIterator;

@After(value={"unblendedResult"})
@Before(value={"Stemming"})
@Provides(value={"TermOrderRelaxation"})
public class CJKSearcher
extends Searcher {
    public static final String TERM_ORDER_RELAXATION = "TermOrderRelaxation";

    @Override
    public Result search(Query query, Execution execution) {
        Language language = query.getModel().getParsingLanguage();
        if (!language.isCjk()) {
            return execution.search(query);
        }
        QueryTree tree = query.getModel().getQueryTree();
        tree.setRoot(this.transform(tree.getRoot()));
        query.trace("Rewriting for CJK behavior for implicit phrases", true, 2);
        return execution.search(query);
    }

    private Item transform(Item root) {
        if (root instanceof PhraseItem) {
            PhraseItem asPhrase = (PhraseItem)root;
            if (asPhrase.isExplicit() || this.hasOverlappingTokens(asPhrase)) {
                return root;
            }
            AndItem replacement = new AndItem();
            ListIterator<Item> i = ((CompositeItem)root).getItemIterator();
            while (i.hasNext()) {
                Item item = i.next();
                if (item instanceof WordItem) {
                    replacement.addItem(item);
                    continue;
                }
                if (item instanceof PhraseSegmentItem) {
                    replacement.addItem(new AndSegmentItem((PhraseSegmentItem)item));
                    continue;
                }
                replacement.addItem(item);
            }
            return replacement;
        }
        if (root instanceof PhraseSegmentItem) {
            PhraseSegmentItem asSegment = (PhraseSegmentItem)root;
            if (asSegment.isExplicit() || this.hasOverlappingTokens(asSegment)) {
                return root;
            }
            return new AndSegmentItem(asSegment);
        }
        if (root instanceof SegmentItem) {
            return root;
        }
        if (root instanceof CompositeItem) {
            ListIterator<Item> i = ((CompositeItem)root).getItemIterator();
            while (i.hasNext()) {
                Item transformedItem;
                Item item = i.next();
                if (item == (transformedItem = this.transform(item))) continue;
                i.set(transformedItem);
            }
            return root;
        }
        return root;
    }

    private boolean hasOverlappingTokens(PhraseItem phrase) {
        boolean has = false;
        ListIterator<Item> i = phrase.getItemIterator();
        while (i.hasNext()) {
            Item segment = (Item)i.next();
            if (segment instanceof PhraseSegmentItem) {
                has = this.hasOverlappingTokens((PhraseSegmentItem)segment);
            }
            if (!has) continue;
            return true;
        }
        return has;
    }

    private boolean hasOverlappingTokens(PhraseSegmentItem segments) {
        int segmentsLength = 0;
        ListIterator<Item> i = segments.getItemIterator();
        while (i.hasNext()) {
            WordItem segment = (WordItem)i.next();
            segmentsLength += segment.getWord().length();
        }
        return segmentsLength > segments.getRawWord().length();
    }
}

