/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;

public class WandItem
extends WeightedSetItem {
    private final int targetNumHits;
    private double scoreThreshold = 0.0;
    private double thresholdBoostFactor = 1.0;

    public WandItem(String fieldName, int targetNumHits) {
        super(fieldName);
        this.targetNumHits = targetNumHits;
    }

    public void setScoreThreshold(double scoreThreshold) {
        this.scoreThreshold = scoreThreshold;
    }

    public void setThresholdBoostFactor(double thresholdBoostFactor) {
        this.thresholdBoostFactor = thresholdBoostFactor;
    }

    public int getTargetNumHits() {
        return this.targetNumHits;
    }

    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    public double getThresholdBoostFactor() {
        return this.thresholdBoostFactor;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WAND;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.targetNumHits, (ByteBuffer)buffer);
        buffer.putDouble(this.scoreThreshold);
        buffer.putDouble(this.thresholdBoostFactor);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.targetNumHits);
        buffer.append(",");
        buffer.append(this.scoreThreshold);
        buffer.append(",");
        buffer.append(this.thresholdBoostFactor);
        buffer.append(")");
        buffer.append(" ");
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("targetNumHits", this.targetNumHits);
        discloser.addProperty("scoreThreshold", this.scoreThreshold);
        discloser.addProperty("thresholdBoostFactor", this.thresholdBoostFactor);
    }
}

