/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermItem;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class RegExpItem
extends TermItem {
    private String expression;
    private Pattern regexp;

    public RegExpItem(String indexName, boolean isFromQuery, String expression) {
        super(indexName, isFromQuery, null);
        this.setValue(expression);
    }

    @Override
    public String stringValue() {
        return this.expression;
    }

    @Override
    public boolean isStemmed() {
        return true;
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public void setValue(String expression) {
        this.regexp = Pattern.compile(expression);
        this.expression = expression;
    }

    @Override
    public String getRawWord() {
        return this.stringValue();
    }

    @Override
    public boolean isWords() {
        return false;
    }

    @Override
    public String getIndexedString() {
        return this.stringValue();
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.REGEXP;
    }

    @Override
    public String getName() {
        return Item.ItemType.REGEXP.name();
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        RegExpItem.putString(this.getIndexedString(), buffer);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegExpItem [expression=").append(this.expression).append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegExpItem other = (RegExpItem)obj;
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }

    public Pattern getRegexp() {
        return this.regexp;
    }
}

