/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import com.yahoo.protect.Validator;
import com.yahoo.search.query.QueryTree;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;

public abstract class CompositeItem
extends Item {
    private List<Item> subitems = new ArrayList<Item>(4);

    @Override
    public void setIndexName(String index) {
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            item.setIndexName(index);
        }
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        for (Item item : this.subitems) {
            discloser.addChild(item);
        }
    }

    public void ensureNotInSubtree(CompositeItem item) {
        ListIterator<Item> i = item.getItemIterator();
        while (i.hasNext()) {
            Item possibleCycle = (Item)i.next();
            if (this == possibleCycle) {
                throw new IllegalArgumentException("Cannot add " + item + " to " + this + " as it would create a cycle");
            }
            if (!(possibleCycle instanceof CompositeItem)) continue;
            this.ensureNotInSubtree((CompositeItem)possibleCycle);
        }
    }

    public void addItem(Item item) {
        this.adding(item);
        this.subitems.add(item);
    }

    protected void adding(Item item) {
        Validator.ensureNotNull((String)"A composite item child", (Object)item);
        Validator.ensure((String)"Attempted to add a composite to itself", (item != this ? 1 : 0) != 0);
        if (item instanceof CompositeItem) {
            this.ensureNotInSubtree((CompositeItem)item);
        }
        item.setParent(this);
    }

    public void addItem(int index, Item item) {
        if (index > this.subitems.size() || index < 0) {
            throw new IndexOutOfBoundsException("Could not add a subitem at position " + index + " to " + this);
        }
        this.adding(item);
        this.subitems.add(index, item);
    }

    void insertNullFirstItem() {
        this.subitems.add(0, null);
    }

    public Item getItem(int index) {
        return this.subitems.get(index);
    }

    public Item setItem(int index, Item item) {
        if (index >= this.subitems.size() || index < 0) {
            throw new IndexOutOfBoundsException("Could not add a subitem at position " + index + " to " + this);
        }
        this.adding(item);
        Item old = this.subitems.set(index, item);
        if (old != item) {
            this.removing(old);
        }
        return old;
    }

    public int getItemIndex(Item item) {
        return this.subitems.indexOf(item);
    }

    public Item removeItem(int index) {
        Item item = this.subitems.remove(index);
        this.removing(item);
        return item;
    }

    private void removing(Item item) {
        if (item == null) {
            return;
        }
        if (item.getParent() == this) {
            item.setParent(null);
        }
    }

    public boolean removeItem(Item item) {
        boolean removed = this.subitems.remove(item);
        if (removed) {
            this.removing(item);
        }
        return removed;
    }

    public int getItemCount() {
        return this.subitems.size();
    }

    public ListIterator<Item> getItemIterator() {
        return new ListIteratorWrapper(this);
    }

    public List<Item> items() {
        return Collections.unmodifiableList(this.subitems);
    }

    @Override
    public int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        int itemCount = 1;
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item subitem = (Item)i.next();
            itemCount += subitem.encode(buffer);
        }
        return itemCount;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.encodingArity(), (ByteBuffer)buffer);
    }

    protected int encodingArity() {
        return this.subitems.size();
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        ListIterator<Item> i = this.getItemIterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            buffer.append(item.toString());
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
    }

    @Override
    protected boolean shouldParenthize() {
        return this.getParent() != null && !(this.getParent() instanceof QueryTree);
    }

    @Override
    public CompositeItem clone() {
        CompositeItem copy = (CompositeItem)super.clone();
        copy.subitems = new ArrayList<Item>();
        for (Item subItem : this.subitems) {
            Item subItemCopy = subItem.clone();
            subItemCopy.setParent(copy);
            copy.subitems.add(subItemCopy);
        }
        this.fixConnexity(copy);
        return copy;
    }

    private void fixConnexity(CompositeItem copy) {
        ArrayList<Item> flatland = new ArrayList<Item>();
        ArrayList<Item> flatCopy = new ArrayList<Item>();
        this.taggingFlatten(this, flatland);
        this.taggingFlatten(copy, flatCopy);
        int barrier = flatland.size();
        for (int i = 0; i < barrier; ++i) {
            Item orig = (Item)flatland.get(i);
            int connectedTo = this.find(orig.connectedItem, flatland);
            if (connectedTo < 0) continue;
            TaggableItem tagged = (TaggableItem)flatCopy.get(i);
            tagged.setConnectivity((Item)flatCopy.get(connectedTo), orig.connectivity);
        }
    }

    private void taggingFlatten(Item tree, List<Item> container) {
        if (tree.hasUniqueID()) {
            container.add(tree);
        } else if (tree instanceof CompositeItem) {
            CompositeItem asComposite = (CompositeItem)tree;
            ListIterator<Item> i = asComposite.getItemIterator();
            while (i.hasNext()) {
                this.taggingFlatten((Item)i.next(), container);
            }
        }
    }

    private int find(Item needle, List<Item> haystack) {
        if (needle == null) {
            return -1;
        }
        int barrier = haystack.size();
        for (int i = 0; i < barrier; ++i) {
            if (haystack.get(i) != needle) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        int code = this.getName().hashCode() + this.subitems.size() * 17;
        for (int i = 0; i < this.subitems.size() && i <= 5; ++i) {
            code += this.subitems.get(i).hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        CompositeItem other = (CompositeItem)object;
        return this.subitems.equals(other.subitems);
    }

    public void lock() {
    }

    public boolean isLocked() {
        return false;
    }

    @Override
    public int getTermCount() {
        int terms = 0;
        for (Item item : this.subitems) {
            terms += item.getTermCount();
        }
        return terms;
    }

    public Optional<Item> extractSingleChild() {
        return this.getItemCount() == 1 ? Optional.of(this.getItem(0)) : Optional.empty();
    }

    private static class ListIteratorWrapper
    implements ListIterator<Item> {
        private CompositeItem owner;
        private ListIterator<Item> wrapped;
        private Item current = null;

        public ListIteratorWrapper(CompositeItem owner) {
            this.owner = owner;
            this.wrapped = owner.subitems.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public Item next() {
            this.current = this.wrapped.next();
            return this.current;
        }

        @Override
        public boolean hasPrevious() {
            return this.wrapped.hasPrevious();
        }

        @Override
        public Item previous() {
            Item current = this.wrapped.previous();
            return current;
        }

        @Override
        public int nextIndex() {
            return this.wrapped.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.wrapped.previousIndex();
        }

        @Override
        public void remove() {
            this.owner.removing(this.current);
            this.wrapped.remove();
        }

        @Override
        public void set(Item o) {
            Item newItem = o;
            this.owner.removing(this.current);
            this.owner.adding(newItem);
            this.current = newItem;
            this.wrapped.set(newItem);
        }

        @Override
        public void add(Item o) {
            Item newItem = o;
            this.owner.adding(newItem);
            this.wrapped.add(o);
        }
    }
}

