/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.language.process.StemMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Index {
    public static final Index nullIndex = new Index("(null)");
    private final String name;
    private String type;
    private final List<String> aliases = new ArrayList<String>();
    private boolean tensor = false;
    private boolean uriIndex = false;
    private boolean hostIndex = false;
    private StemMode stemMode = StemMode.NONE;
    private boolean isAttribute = false;
    private boolean isDefaultPosition = false;
    private boolean dynamicSummary = false;
    private boolean highlightSummary = false;
    private boolean lowercase = false;
    private boolean plainTokens = false;
    private boolean multivalue = false;
    private boolean fastSearch = false;
    private boolean normalize = false;
    private boolean literalBoost = false;
    private boolean numerical = false;
    private boolean predicate = false;
    private long predicateUpperBound = Long.MAX_VALUE;
    private long predicateLowerBound = Long.MIN_VALUE;
    private boolean exact = false;
    private boolean isNGram = false;
    private int gramSize = 2;
    private Boolean phraseSegmenting = false;
    private String exactTerminator = null;
    private final Set<String> commands = new HashSet<String>();
    private final List<String> allCommands = new ArrayList<String>();

    public Index(String name) {
        this.name = name;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public List<String> aliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUriIndex() {
        return this.uriIndex;
    }

    public boolean isDefaultPosition() {
        return this.isDefaultPosition;
    }

    public void setDefaultPosition(boolean v) {
        this.isDefaultPosition = v;
    }

    public void setUriIndex(boolean uriIndex) {
        this.uriIndex = uriIndex;
    }

    public boolean isHostIndex() {
        return this.hostIndex;
    }

    public void setHostIndex(boolean hostIndex) {
        this.hostIndex = hostIndex;
    }

    public StemMode getStemMode() {
        return this.stemMode;
    }

    public void setStemMode(StemMode stemMode) {
        this.stemMode = stemMode;
    }

    public void setStemMode(String name) {
        this.stemMode = StemMode.valueOf((String)name);
    }

    public Index addCommand(String command) {
        this.allCommands.add(command);
        if (command.startsWith("type tensor(") || command.startsWith("type tensor<")) {
            this.setTensor(true);
        } else if ("fullurl".equals(command)) {
            this.setUriIndex(true);
        } else if ("urlhost".equals(command)) {
            this.setHostIndex(true);
        } else if (command.startsWith("stem ")) {
            this.setStemMode(command.substring(5));
        } else if (command.startsWith("stem:")) {
            this.setStemMode(command.substring(5));
        } else if ("stem".equals(command)) {
            this.setStemMode(StemMode.SHORTEST);
        } else if ("word".equals(command)) {
            this.setExact(true, null);
        } else if ("exact".equals(command)) {
            this.setExact(true, " ");
        } else if ("dynteaser".equals(command)) {
            this.setDynamicSummary(true);
        } else if ("highlight".equals(command)) {
            this.setHighlightSummary(true);
        } else if ("lowercase".equals(command)) {
            this.setLowercase(true);
        } else if (command.startsWith("exact ")) {
            this.setExact(true, command.substring(6));
        } else if (command.startsWith("ngram ")) {
            this.setNGram(true, Integer.parseInt(command.substring(6)));
        } else if (command.equals("attribute")) {
            this.setAttribute(true);
        } else if (command.equals("default-position")) {
            this.setDefaultPosition(true);
        } else if (command.equals("plain-tokens")) {
            this.setPlainTokens(true);
        } else if (command.equals("multivalue")) {
            this.setMultivalue(true);
        } else if (command.equals("fast-search")) {
            this.setFastSearch(true);
        } else if (command.equals("normalize")) {
            this.setNormalize(true);
        } else if (command.equals("literal-boost")) {
            this.setLiteralBoost(true);
        } else if (command.equals("numerical")) {
            this.setNumerical(true);
        } else if (command.equals("predicate")) {
            this.setPredicate(true);
        } else if (command.startsWith("predicate-bounds ")) {
            this.setPredicateBounds(command.substring(17));
        } else if (command.equals("phrase-segmenting")) {
            this.setPhraseSegmenting(true);
        } else if (command.startsWith("phrase-segmenting ")) {
            this.setPhraseSegmenting(Boolean.parseBoolean(command.substring("phrase-segmenting ".length())));
        } else {
            this.commands.add(command);
        }
        return this;
    }

    private void setTensor(boolean tensor) {
        this.tensor = tensor;
    }

    public boolean isTensor() {
        return this.tensor;
    }

    private void setPredicateBounds(String bounds) {
        this.predicateLowerBound = !bounds.startsWith("[..") ? Long.parseLong(bounds.substring(1, bounds.indexOf(".."))) : Long.MIN_VALUE;
        this.predicateUpperBound = !bounds.endsWith("..]") ? Long.parseLong(bounds.substring(bounds.indexOf("..") + 2, bounds.length() - 1)) : Long.MAX_VALUE;
    }

    public void setLowercase(boolean lowercase) {
        this.lowercase = lowercase;
    }

    public boolean isLowercase() {
        return this.lowercase;
    }

    public Iterator<String> commandIterator() {
        return this.commands.iterator();
    }

    public boolean hasCommand(String commandString) {
        return this.commands.contains(commandString);
    }

    public void setExact(boolean exact, String terminator) {
        this.exact = exact;
        this.exactTerminator = terminator;
    }

    public boolean isExact() {
        return this.exact;
    }

    public String getExactTerminator() {
        return this.exactTerminator;
    }

    public boolean isNGram() {
        return this.isNGram;
    }

    public int getGramSize() {
        return this.gramSize;
    }

    public void setNGram(boolean nGram, int gramSize) {
        this.isNGram = nGram;
        this.gramSize = gramSize;
    }

    public void setDynamicSummary(boolean dynamicSummary) {
        this.dynamicSummary = dynamicSummary;
    }

    public boolean getDynamicSummary() {
        return this.dynamicSummary;
    }

    public void setHighlightSummary(boolean highlightSummary) {
        this.highlightSummary = highlightSummary;
    }

    public boolean getHighlightSummary() {
        return this.highlightSummary;
    }

    public boolean isNull() {
        return "(null)".equals(this.name);
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    public boolean hasPlainTokens() {
        return this.plainTokens;
    }

    public void setPlainTokens(boolean plainTokens) {
        this.plainTokens = plainTokens;
    }

    public void setMultivalue(boolean multivalue) {
        this.multivalue = multivalue;
    }

    public boolean isMultivalue() {
        return this.multivalue;
    }

    public void setFastSearch(boolean fastSearch) {
        this.fastSearch = fastSearch;
    }

    public boolean isFastSearch() {
        return this.fastSearch;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean getNormalize() {
        return this.normalize;
    }

    public boolean getLiteralBoost() {
        return this.literalBoost;
    }

    public void setLiteralBoost(boolean literalBoost) {
        this.literalBoost = literalBoost;
    }

    public void setNumerical(boolean numerical) {
        this.numerical = numerical;
    }

    public boolean isNumerical() {
        return this.numerical;
    }

    public void setPredicate(boolean isPredicate) {
        this.predicate = isPredicate;
    }

    public boolean isPredicate() {
        return this.predicate;
    }

    public long getPredicateUpperBound() {
        return this.predicateUpperBound;
    }

    public long getPredicateLowerBound() {
        return this.predicateLowerBound;
    }

    public boolean getPhraseSegmenting() {
        return this.phraseSegmenting;
    }

    public boolean setPhraseSegmenting(boolean phraseSegmenting) {
        this.phraseSegmenting = phraseSegmenting;
        return this.phraseSegmenting;
    }

    public List<String> allCommands() {
        return this.allCommands;
    }

    public String toString() {
        return "index '" + this.getName() + "'";
    }

    public static class Attribute {
        private boolean tokenizedContent = false;
        public final String name;

        public Attribute(String name) {
            this.name = name;
        }

        public boolean isTokenizedContent() {
            return this.tokenizedContent;
        }

        public void setTokenizedContent(boolean tokenizedContent) {
            this.tokenizedContent = tokenizedContent;
        }
    }
}

