/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.BucketValue;
import com.yahoo.search.grouping.request.ConstantValue;
import com.yahoo.search.grouping.request.DoubleBucket;
import com.yahoo.search.grouping.request.DoublePredefined;
import com.yahoo.search.grouping.request.DoubleValue;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.InfiniteValue;
import com.yahoo.search.grouping.request.LongBucket;
import com.yahoo.search.grouping.request.LongPredefined;
import com.yahoo.search.grouping.request.LongValue;
import com.yahoo.search.grouping.request.PredefinedFunction;
import com.yahoo.search.grouping.request.RawBucket;
import com.yahoo.search.grouping.request.RawPredefined;
import com.yahoo.search.grouping.request.RawValue;
import com.yahoo.search.grouping.request.StringBucket;
import com.yahoo.search.grouping.request.StringPredefined;
import com.yahoo.search.grouping.request.StringValue;
import java.util.LinkedList;
import java.util.List;

public class BucketResolver {
    private final List<BucketValue> buckets = new LinkedList<BucketValue>();
    private ConstantValue<?> prev = null;
    private boolean previnclusive = false;
    private int idx = 0;

    public BucketResolver push(ConstantValue<?> val, boolean inclusive) {
        if (this.prev == null) {
            this.prev = val;
        } else {
            if (!(this.prev instanceof InfiniteValue || val instanceof InfiniteValue || this.prev.getClass().equals(val.getClass()))) {
                throw new IllegalArgumentException("Bucket type mismatch, expected '" + this.prev.getClass().getSimpleName() + "' got '" + val.getClass().getSimpleName() + "'.");
            }
            if (this.prev instanceof InfiniteValue && val instanceof InfiniteValue) {
                throw new IllegalArgumentException("Bucket type mismatch, cannot both be infinity.");
            }
        }
        if (++this.idx % 2 == 0) {
            ConstantValue<?> end;
            ConstantValue<?> begin = this.previnclusive ? this.prev : this.nextValue(this.prev);
            ConstantValue<?> constantValue = end = inclusive ? this.nextValue(val) : val;
            if (begin instanceof DoubleValue || end instanceof DoubleValue) {
                this.buckets.add(new DoubleBucket(begin, end));
            } else if (begin instanceof LongValue || end instanceof LongValue) {
                this.buckets.add(new LongBucket(begin, end));
            } else if (begin instanceof StringValue || end instanceof StringValue) {
                this.buckets.add(new StringBucket(begin, end));
            } else if (begin instanceof RawValue || end instanceof RawValue) {
                this.buckets.add(new RawBucket(begin, end));
            } else {
                throw new UnsupportedOperationException("Bucket type '" + val.getClass() + "' not supported.");
            }
        }
        this.prev = val;
        this.previnclusive = inclusive;
        return this;
    }

    public PredefinedFunction resolve(GroupingExpression exp) {
        if (this.idx % 2 == 1) {
            throw new IllegalStateException("Missing to-limit of last bucket.");
        }
        int len = this.buckets.size();
        if (len == 0) {
            throw new IllegalStateException("Expected at least one bucket, got none.");
        }
        ConstantValue<?> begin = this.buckets.get(0).getFrom();
        ConstantValue<?> end = this.buckets.get(0).getTo();
        if (begin instanceof DoubleValue || end instanceof DoubleValue) {
            if (len == 1) {
                return new DoublePredefined(exp, (DoubleBucket)this.buckets.get(0), new DoubleBucket[0]);
            }
            return new DoublePredefined(exp, (DoubleBucket)this.buckets.get(0), this.buckets.subList(1, len).toArray(new DoubleBucket[len - 1]));
        }
        if (begin instanceof LongValue || end instanceof LongValue) {
            if (len == 1) {
                return new LongPredefined(exp, (LongBucket)this.buckets.get(0), new LongBucket[0]);
            }
            return new LongPredefined(exp, (LongBucket)this.buckets.get(0), this.buckets.subList(1, len).toArray(new LongBucket[len - 1]));
        }
        if (begin instanceof StringValue || end instanceof StringValue) {
            if (len == 1) {
                return new StringPredefined(exp, (StringBucket)this.buckets.get(0), new StringBucket[0]);
            }
            return new StringPredefined(exp, (StringBucket)this.buckets.get(0), this.buckets.subList(1, len).toArray(new StringBucket[len - 1]));
        }
        if (begin instanceof RawValue || end instanceof RawValue) {
            if (len == 1) {
                return new RawPredefined(exp, (RawBucket)this.buckets.get(0), new RawBucket[0]);
            }
            return new RawPredefined(exp, (RawBucket)this.buckets.get(0), this.buckets.subList(1, len).toArray(new RawBucket[len - 1]));
        }
        throw new UnsupportedOperationException("Bucket type '" + begin.getClass() + "' not supported.");
    }

    private ConstantValue<?> nextValue(ConstantValue<?> value) {
        if (value instanceof LongValue) {
            return LongBucket.nextValue((LongValue)value);
        }
        if (value instanceof DoubleValue) {
            return DoubleBucket.nextValue((DoubleValue)value);
        }
        if (value instanceof StringValue) {
            return StringBucket.nextValue((StringValue)value);
        }
        if (value instanceof RawValue) {
            return RawBucket.nextValue((RawValue)value);
        }
        return value;
    }
}

