/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.language.LinguisticsCase;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.parser.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpecialTokens {
    private static final Logger log = Logger.getLogger(SpecialTokens.class.getName());
    private String name;
    private List<SpecialToken> specialTokens = new ArrayList<SpecialToken>();
    private boolean frozen = false;
    private int currentMaximumLength = 0;

    public SpecialTokens() {
        this.name = "(null)";
    }

    public SpecialTokens(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addSpecialToken(String token, String replace) {
        this.ensureNotFrozen();
        if (!this.caseIndependentLength(token)) {
            return;
        }
        SpecialToken specialTokenToAdd = new SpecialToken(token, replace);
        this.currentMaximumLength = Math.max(this.currentMaximumLength, specialTokenToAdd.token.length());
        this.specialTokens.add(specialTokenToAdd);
        Collections.sort(this.specialTokens);
    }

    private boolean caseIndependentLength(String token) {
        String asLow = LinguisticsCase.toLowerCase((String)token);
        String asHigh = token.toUpperCase(Locale.ENGLISH);
        if (asLow.length() != token.length() || asHigh.length() != token.length()) {
            log.log(Level.SEVERE, "Special token '" + token + "' has case sensitive length. Ignoring the token. Please report this message in a bug to the Vespa team.");
            return false;
        }
        return true;
    }

    public SpecialToken tokenize(String string, boolean substring) {
        String input = LinguisticsCase.toLowerCase((String)string.substring(0, Math.min(string.length(), this.currentMaximumLength)));
        for (SpecialToken special : this.specialTokens) {
            if (!input.startsWith(special.token()) || string.length() != special.token().length() && !substring && !this.tokenEndsAt(special.token().length(), string)) continue;
            return special;
        }
        return null;
    }

    private boolean tokenEndsAt(int position, String string) {
        return !Character.isLetterOrDigit(string.charAt(position));
    }

    public int size() {
        return this.specialTokens.size();
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Tried to modify a frozen SpecialTokens instance.");
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    public static final class SpecialToken
    implements Comparable<SpecialToken> {
        private String token;
        private String replace;

        public SpecialToken(String token, String replace) {
            this.token = LinguisticsCase.toLowerCase((String)token);
            this.replace = replace == null || replace.trim().equals("") ? this.token : LinguisticsCase.toLowerCase((String)replace);
        }

        public String token() {
            return this.token;
        }

        public String replace() {
            return this.replace;
        }

        @Override
        public int compareTo(SpecialToken other) {
            if (this.token().length() < other.token().length()) {
                return 1;
            }
            if (this.token().length() == other.token().length()) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof SpecialToken)) {
                return false;
            }
            return Objects.equals(this.token, ((SpecialToken)other).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public Token toToken(int start, String rawSource) {
            return new Token(Token.Kind.WORD, this.replace(), true, new Substring(start, start + this.token.length(), rawSource));
        }
    }
}

