/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.config.subscription.ConfigGetter;
import com.yahoo.prelude.query.parser.SpecialTokens;
import com.yahoo.vespa.configdefinition.SpecialtokensConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SpecialTokenRegistry {
    private static Logger log = Logger.getLogger(SpecialTokens.class.getName());
    private static final SpecialTokens nullSpecialTokens = new SpecialTokens();
    private Map<String, SpecialTokens> specialTokenMap = new HashMap<String, SpecialTokens>();
    private boolean frozen = false;

    public SpecialTokenRegistry() {
    }

    public SpecialTokenRegistry(String configId) {
        try {
            this.build((SpecialtokensConfig)new ConfigGetter(SpecialtokensConfig.class).getConfig(configId));
        }
        catch (Exception e) {
            log.config("No special tokens are configured (" + e.getMessage() + ")");
        }
    }

    public SpecialTokenRegistry(SpecialtokensConfig config) {
        if (config != null) {
            this.build(config);
        }
        this.freeze();
    }

    private void freeze() {
        this.frozen = true;
    }

    private void build(SpecialtokensConfig config) {
        ArrayList<SpecialTokens> list = new ArrayList<SpecialTokens>();
        for (SpecialtokensConfig.Tokenlist tokenList : config.tokenlist()) {
            SpecialTokens tokens = new SpecialTokens(tokenList.name());
            for (SpecialtokensConfig.Tokenlist.Tokens token : tokenList.tokens()) {
                tokens.addSpecialToken(token.token(), token.replace());
            }
            tokens.freeze();
            list.add(tokens);
        }
        this.addSpecialTokens(list);
    }

    public void addSpecialTokens(SpecialTokens specialTokens) {
        this.ensureNotFrozen();
        ArrayList<SpecialTokens> list = new ArrayList<SpecialTokens>();
        list.add(specialTokens);
        this.addSpecialTokens(list);
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Tried to modify a frozen SpecialTokenRegistry instance.");
        }
    }

    private void addSpecialTokens(List<SpecialTokens> list) {
        HashMap<String, SpecialTokens> tokens = new HashMap<String, SpecialTokens>(this.specialTokenMap);
        for (SpecialTokens t : list) {
            tokens.put(t.getName(), t);
        }
        this.specialTokenMap = tokens;
    }

    public SpecialTokens getSpecialTokens(String name) {
        SpecialTokens specialTokens;
        if (name == null || name.trim().equals("")) {
            name = "default";
        }
        if ((specialTokens = this.specialTokenMap.get(name)) == null) {
            return nullSpecialTokens;
        }
        return specialTokens;
    }
}

